/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PathNavigationRegion
implements CollisionGetter {
    protected final int centerX;
    protected final int centerZ;
    protected final ChunkAccess[][] chunks;
    protected boolean allEmpty;
    protected final Level level;
    private final Supplier<Holder<Biome>> plains;

    public PathNavigationRegion(Level var0, BlockPos var1, BlockPos var2) {
        int var7;
        int var6;
        this.level = var0;
        this.plains = Suppliers.memoize(() -> var0.registryAccess().lookupOrThrow(Registries.BIOME).getOrThrow(Biomes.PLAINS));
        this.centerX = SectionPos.blockToSectionCoord(var1.getX());
        this.centerZ = SectionPos.blockToSectionCoord(var1.getZ());
        int var3 = SectionPos.blockToSectionCoord(var2.getX());
        int var4 = SectionPos.blockToSectionCoord(var2.getZ());
        this.chunks = new ChunkAccess[var3 - this.centerX + 1][var4 - this.centerZ + 1];
        ChunkSource var5 = var0.getChunkSource();
        this.allEmpty = true;
        for (var6 = this.centerX; var6 <= var3; ++var6) {
            for (var7 = this.centerZ; var7 <= var4; ++var7) {
                this.chunks[var6 - this.centerX][var7 - this.centerZ] = var5.getChunkNow(var6, var7);
            }
        }
        for (var6 = SectionPos.blockToSectionCoord(var1.getX()); var6 <= SectionPos.blockToSectionCoord(var2.getX()); ++var6) {
            for (var7 = SectionPos.blockToSectionCoord(var1.getZ()); var7 <= SectionPos.blockToSectionCoord(var2.getZ()); ++var7) {
                ChunkAccess var8 = this.chunks[var6 - this.centerX][var7 - this.centerZ];
                if (var8 == null || var8.isYSpaceEmpty(var1.getY(), var2.getY())) continue;
                this.allEmpty = false;
                return;
            }
        }
    }

    private ChunkAccess getChunk(BlockPos var0) {
        return this.getChunk(SectionPos.blockToSectionCoord(var0.getX()), SectionPos.blockToSectionCoord(var0.getZ()));
    }

    private ChunkAccess getChunk(int var0, int var1) {
        int var2 = var0 - this.centerX;
        int var3 = var1 - this.centerZ;
        if (var2 < 0 || var2 >= this.chunks.length || var3 < 0 || var3 >= this.chunks[var2].length) {
            return new EmptyLevelChunk(this.level, new ChunkPos(var0, var1), this.plains.get());
        }
        ChunkAccess var4 = this.chunks[var2][var3];
        return var4 != null ? var4 : new EmptyLevelChunk(this.level, new ChunkPos(var0, var1), this.plains.get());
    }

    @Override
    public WorldBorder getWorldBorder() {
        return this.level.getWorldBorder();
    }

    @Override
    public BlockGetter getChunkForCollisions(int var0, int var1) {
        return this.getChunk(var0, var1);
    }

    @Override
    public List<VoxelShape> getEntityCollisions(@Nullable Entity var0, AABB var1) {
        return List.of();
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity(BlockPos var0) {
        ChunkAccess var1 = this.getChunk(var0);
        return var1.getBlockEntity(var0);
    }

    @Override
    public BlockState getBlockState(BlockPos var0) {
        if (this.isOutsideBuildHeight(var0)) {
            return Blocks.AIR.defaultBlockState();
        }
        ChunkAccess var1 = this.getChunk(var0);
        return var1.getBlockState(var0);
    }

    @Override
    public FluidState getFluidState(BlockPos var0) {
        if (this.isOutsideBuildHeight(var0)) {
            return Fluids.EMPTY.defaultFluidState();
        }
        ChunkAccess var1 = this.getChunk(var0);
        return var1.getFluidState(var0);
    }

    @Override
    public int getMinY() {
        return this.level.getMinY();
    }

    @Override
    public int getHeight() {
        return this.level.getHeight();
    }
}

