/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.slf4j.Logger;

public class BiomeGenerationSettings {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final BiomeGenerationSettings EMPTY = new BiomeGenerationSettings(HolderSet.direct(new Holder[0]), List.of());
    public static final MapCodec<BiomeGenerationSettings> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)ConfiguredWorldCarver.LIST_CODEC.promotePartial(Util.prefix("Carver: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).fieldOf("carvers").forGetter(var0 -> var0.carvers), (App)PlacedFeature.LIST_OF_LISTS_CODEC.promotePartial(Util.prefix("Features: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).fieldOf("features").forGetter(var0 -> var0.features)).apply((Applicative)var02, BiomeGenerationSettings::new));
    private final HolderSet<ConfiguredWorldCarver<?>> carvers;
    private final List<HolderSet<PlacedFeature>> features;
    private final Supplier<List<ConfiguredFeature<?, ?>>> flowerFeatures;
    private final Supplier<Set<PlacedFeature>> featureSet;

    BiomeGenerationSettings(HolderSet<ConfiguredWorldCarver<?>> var0, List<HolderSet<PlacedFeature>> var1) {
        this.carvers = var0;
        this.features = var1;
        this.flowerFeatures = Suppliers.memoize(() -> (List)var1.stream().flatMap(HolderSet::stream).map(Holder::value).flatMap(PlacedFeature::getFeatures).filter(var0 -> var0.feature() == Feature.FLOWER).collect(ImmutableList.toImmutableList()));
        this.featureSet = Suppliers.memoize(() -> var1.stream().flatMap(HolderSet::stream).map(Holder::value).collect(Collectors.toSet()));
    }

    public Iterable<Holder<ConfiguredWorldCarver<?>>> getCarvers() {
        return this.carvers;
    }

    public List<ConfiguredFeature<?, ?>> getFlowerFeatures() {
        return this.flowerFeatures.get();
    }

    public List<HolderSet<PlacedFeature>> features() {
        return this.features;
    }

    public boolean hasFeature(PlacedFeature var0) {
        return this.featureSet.get().contains(var0);
    }

    public static class Builder
    extends PlainBuilder {
        private final HolderGetter<PlacedFeature> placedFeatures;
        private final HolderGetter<ConfiguredWorldCarver<?>> worldCarvers;

        public Builder(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
            this.placedFeatures = var0;
            this.worldCarvers = var1;
        }

        public Builder addFeature(GenerationStep.Decoration var0, ResourceKey<PlacedFeature> var1) {
            this.addFeature(var0.ordinal(), this.placedFeatures.getOrThrow(var1));
            return this;
        }

        public Builder addCarver(ResourceKey<ConfiguredWorldCarver<?>> var0) {
            this.addCarver(this.worldCarvers.getOrThrow(var0));
            return this;
        }
    }

    public static class PlainBuilder {
        private final List<Holder<ConfiguredWorldCarver<?>>> carvers = new ArrayList();
        private final List<List<Holder<PlacedFeature>>> features = new ArrayList<List<Holder<PlacedFeature>>>();

        public PlainBuilder addFeature(GenerationStep.Decoration var0, Holder<PlacedFeature> var1) {
            return this.addFeature(var0.ordinal(), var1);
        }

        public PlainBuilder addFeature(int var0, Holder<PlacedFeature> var1) {
            this.addFeatureStepsUpTo(var0);
            this.features.get(var0).add(var1);
            return this;
        }

        public PlainBuilder addCarver(Holder<ConfiguredWorldCarver<?>> var0) {
            this.carvers.add(var0);
            return this;
        }

        private void addFeatureStepsUpTo(int var0) {
            while (this.features.size() <= var0) {
                this.features.add(Lists.newArrayList());
            }
        }

        public BiomeGenerationSettings build() {
            return new BiomeGenerationSettings(HolderSet.direct(this.carvers), (List)this.features.stream().map(HolderSet::direct).collect(ImmutableList.toImmutableList()));
        }
    }
}

