/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import org.slf4j.Logger;

public class MobSpawnSettings {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float DEFAULT_CREATURE_SPAWN_PROBABILITY = 0.1f;
    public static final WeightedList<SpawnerData> EMPTY_MOB_LIST = WeightedList.of();
    public static final MobSpawnSettings EMPTY = new Builder().build();
    public static final MapCodec<MobSpawnSettings> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.floatRange((float)0.0f, (float)0.9999999f).optionalFieldOf("creature_spawn_probability", (Object)Float.valueOf(0.1f)).forGetter(var0 -> Float.valueOf(var0.creatureGenerationProbability)), (App)Codec.simpleMap(MobCategory.CODEC, (Codec)WeightedList.codec(SpawnerData.CODEC).promotePartial(Util.prefix("Spawn data: ", arg_0 -> ((Logger)LOGGER).error(arg_0))), (Keyable)StringRepresentable.keys(MobCategory.values())).fieldOf("spawners").forGetter(var0 -> var0.spawners), (App)Codec.simpleMap(BuiltInRegistries.ENTITY_TYPE.byNameCodec(), MobSpawnCost.CODEC, BuiltInRegistries.ENTITY_TYPE).fieldOf("spawn_costs").forGetter(var0 -> var0.mobSpawnCosts)).apply((Applicative)var02, MobSpawnSettings::new));
    private final float creatureGenerationProbability;
    private final Map<MobCategory, WeightedList<SpawnerData>> spawners;
    private final Map<EntityType<?>, MobSpawnCost> mobSpawnCosts;

    MobSpawnSettings(float var0, Map<MobCategory, WeightedList<SpawnerData>> var1, Map<EntityType<?>, MobSpawnCost> var2) {
        this.creatureGenerationProbability = var0;
        this.spawners = ImmutableMap.copyOf(var1);
        this.mobSpawnCosts = ImmutableMap.copyOf(var2);
    }

    public WeightedList<SpawnerData> getMobs(MobCategory var0) {
        return this.spawners.getOrDefault(var0, EMPTY_MOB_LIST);
    }

    @Nullable
    public MobSpawnCost getMobSpawnCost(EntityType<?> var0) {
        return this.mobSpawnCosts.get(var0);
    }

    public float getCreatureProbability() {
        return this.creatureGenerationProbability;
    }

    public record MobSpawnCost(double energyBudget, double charge) {
        public static final Codec<MobSpawnCost> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.DOUBLE.fieldOf("energy_budget").forGetter(var0 -> var0.energyBudget), (App)Codec.DOUBLE.fieldOf("charge").forGetter(var0 -> var0.charge)).apply((Applicative)var02, MobSpawnCost::new));
    }

    public record SpawnerData(EntityType<?> type, int minCount, int maxCount) {
        public static final MapCodec<SpawnerData> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("type").forGetter(var0 -> var0.type), (App)ExtraCodecs.POSITIVE_INT.fieldOf("minCount").forGetter(var0 -> var0.minCount), (App)ExtraCodecs.POSITIVE_INT.fieldOf("maxCount").forGetter(var0 -> var0.maxCount)).apply((Applicative)var02, SpawnerData::new)).validate(var0 -> {
            if (var0.minCount > var0.maxCount) {
                return DataResult.error(() -> "minCount needs to be smaller or equal to maxCount");
            }
            return DataResult.success((Object)var0);
        });

        public SpawnerData {
            var0 = var0.getCategory() == MobCategory.MISC ? EntityType.PIG : var0;
        }

        @Override
        public String toString() {
            return String.valueOf(EntityType.getKey(this.type)) + "*(" + this.minCount + "-" + this.maxCount + ")";
        }
    }

    public static class Builder {
        private final Map<MobCategory, WeightedList.Builder<SpawnerData>> spawners = Util.makeEnumMap(MobCategory.class, var0 -> WeightedList.builder());
        private final Map<EntityType<?>, MobSpawnCost> mobSpawnCosts = Maps.newLinkedHashMap();
        private float creatureGenerationProbability = 0.1f;

        public Builder addSpawn(MobCategory var0, int var1, SpawnerData var2) {
            this.spawners.get(var0).add(var2, var1);
            return this;
        }

        public Builder addMobCharge(EntityType<?> var0, double var1, double var3) {
            this.mobSpawnCosts.put(var0, new MobSpawnCost(var3, var1));
            return this;
        }

        public Builder creatureGenerationProbability(float var0) {
            this.creatureGenerationProbability = var0;
            return this;
        }

        public MobSpawnSettings build() {
            return new MobSpawnSettings(this.creatureGenerationProbability, (Map)this.spawners.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, var0 -> ((WeightedList.Builder)var0.getValue()).build())), (Map<EntityType<?>, MobSpawnCost>)ImmutableMap.copyOf(this.mobSpawnCosts));
        }
    }
}

