/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BellBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class BellBlock
extends BaseEntityBlock {
    public static final MapCodec<BellBlock> CODEC = BellBlock.simpleCodec(BellBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<BellAttachType> ATTACHMENT = BlockStateProperties.BELL_ATTACHMENT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final VoxelShape BELL_SHAPE = Shapes.or(Block.column(6.0, 6.0, 13.0), Block.column(8.0, 4.0, 6.0));
    private static final VoxelShape SHAPE_CEILING = Shapes.or(BELL_SHAPE, Block.column(2.0, 13.0, 16.0));
    private static final Map<Direction.Axis, VoxelShape> SHAPE_FLOOR = Shapes.rotateHorizontalAxis(Block.cube(16.0, 16.0, 8.0));
    private static final Map<Direction.Axis, VoxelShape> SHAPE_DOUBLE_WALL = Shapes.rotateHorizontalAxis(Shapes.or(BELL_SHAPE, Block.column(2.0, 16.0, 13.0, 15.0)));
    private static final Map<Direction, VoxelShape> SHAPE_SINGLE_WALL = Shapes.rotateHorizontal(Shapes.or(BELL_SHAPE, Block.boxZ(2.0, 13.0, 15.0, 0.0, 13.0)));
    public static final int EVENT_BELL_RING = 1;

    public MapCodec<BellBlock> codec() {
        return CODEC;
    }

    public BellBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(ATTACHMENT, BellAttachType.FLOOR)).setValue(POWERED, false));
    }

    @Override
    protected void neighborChanged(BlockState iblockdata, Level world, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        boolean flag1 = world.hasNeighborSignal(blockposition);
        if (flag1 != iblockdata.getValue(POWERED)) {
            if (flag1) {
                this.attemptToRing(world, blockposition, null);
            }
            world.setBlock(blockposition, (BlockState)iblockdata.setValue(POWERED, flag1), 3);
        }
    }

    @Override
    protected void onProjectileHit(Level world, BlockState iblockdata, BlockHitResult movingobjectpositionblock, Projectile iprojectile) {
        Player entityhuman1;
        Entity entity = iprojectile.getOwner();
        Player entityhuman = entity instanceof Player ? (entityhuman1 = (Player)entity) : null;
        Player entityhuman2 = entityhuman;
        this.onHit(world, iblockdata, movingobjectpositionblock, entityhuman2, true);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        return (InteractionResult)((Object)(this.onHit(world, iblockdata, movingobjectpositionblock, entityhuman, true) ? InteractionResult.SUCCESS : InteractionResult.PASS));
    }

    public boolean onHit(Level world, BlockState iblockdata, BlockHitResult movingobjectpositionblock, @Nullable Player entityhuman, boolean flag) {
        boolean flag1;
        Direction enumdirection = movingobjectpositionblock.getDirection();
        BlockPos blockposition = movingobjectpositionblock.getBlockPos();
        boolean bl = flag1 = !flag || this.isProperHit(iblockdata, enumdirection, movingobjectpositionblock.getLocation().y - (double)blockposition.getY());
        if (flag1) {
            boolean flag2 = this.attemptToRing(entityhuman, world, blockposition, enumdirection);
            if (flag2 && entityhuman != null) {
                entityhuman.awardStat(Stats.BELL_RING);
            }
            return true;
        }
        return false;
    }

    private boolean isProperHit(BlockState iblockdata, Direction enumdirection, double d0) {
        if (enumdirection.getAxis() != Direction.Axis.Y && d0 <= (double)0.8124f) {
            Direction enumdirection1 = iblockdata.getValue(FACING);
            BellAttachType blockpropertybellattach = iblockdata.getValue(ATTACHMENT);
            switch (blockpropertybellattach) {
                case FLOOR: {
                    return enumdirection1.getAxis() == enumdirection.getAxis();
                }
                case SINGLE_WALL: 
                case DOUBLE_WALL: {
                    return enumdirection1.getAxis() != enumdirection.getAxis();
                }
                case CEILING: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean attemptToRing(Level world, BlockPos blockposition, @Nullable Direction enumdirection) {
        return this.attemptToRing(null, world, blockposition, enumdirection);
    }

    public boolean attemptToRing(@Nullable Entity entity, Level world, BlockPos blockposition, @Nullable Direction enumdirection) {
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (!world.isClientSide() && tileentity instanceof BellBlockEntity) {
            if (enumdirection == null) {
                enumdirection = world.getBlockState(blockposition).getValue(FACING);
            }
            if (!CraftEventFactory.handleBellRingEvent(world, blockposition, enumdirection, entity)) {
                return false;
            }
            ((BellBlockEntity)tileentity).onHit(enumdirection);
            world.playSound((Entity)null, blockposition, SoundEvents.BELL_BLOCK, SoundSource.BLOCKS, 2.0f, 1.0f);
            world.gameEvent(entity, GameEvent.BLOCK_CHANGE, blockposition);
            return true;
        }
        return false;
    }

    private VoxelShape getVoxelShape(BlockState iblockdata) {
        Direction enumdirection = iblockdata.getValue(FACING);
        return switch (iblockdata.getValue(ATTACHMENT)) {
            case BellAttachType.FLOOR -> SHAPE_FLOOR.get(enumdirection.getAxis());
            case BellAttachType.SINGLE_WALL -> SHAPE_SINGLE_WALL.get(enumdirection);
            case BellAttachType.DOUBLE_WALL -> SHAPE_DOUBLE_WALL.get(enumdirection.getAxis());
            case BellAttachType.CEILING -> SHAPE_CEILING;
            default -> throw new MatchException(null, null);
        };
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return this.getVoxelShape(iblockdata);
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return this.getVoxelShape(iblockdata);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        Direction enumdirection = blockactioncontext.getClickedFace();
        BlockPos blockposition = blockactioncontext.getClickedPos();
        Level world = blockactioncontext.getLevel();
        Direction.Axis enumdirection_enumaxis = enumdirection.getAxis();
        if (enumdirection_enumaxis == Direction.Axis.Y) {
            BlockState iblockdata = (BlockState)((BlockState)this.defaultBlockState().setValue(ATTACHMENT, enumdirection == Direction.DOWN ? BellAttachType.CEILING : BellAttachType.FLOOR)).setValue(FACING, blockactioncontext.getHorizontalDirection());
            if (iblockdata.canSurvive(blockactioncontext.getLevel(), blockposition)) {
                return iblockdata;
            }
        } else {
            boolean flag = enumdirection_enumaxis == Direction.Axis.X && world.getBlockState(blockposition.west()).isFaceSturdy(world, blockposition.west(), Direction.EAST) && world.getBlockState(blockposition.east()).isFaceSturdy(world, blockposition.east(), Direction.WEST) || enumdirection_enumaxis == Direction.Axis.Z && world.getBlockState(blockposition.north()).isFaceSturdy(world, blockposition.north(), Direction.SOUTH) && world.getBlockState(blockposition.south()).isFaceSturdy(world, blockposition.south(), Direction.NORTH);
            BlockState iblockdata1 = (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, enumdirection.getOpposite())).setValue(ATTACHMENT, flag ? BellAttachType.DOUBLE_WALL : BellAttachType.SINGLE_WALL);
            if (iblockdata1.canSurvive(blockactioncontext.getLevel(), blockactioncontext.getClickedPos())) {
                return iblockdata1;
            }
            boolean flag1 = world.getBlockState(blockposition.below()).isFaceSturdy(world, blockposition.below(), Direction.UP);
            if ((iblockdata1 = (BlockState)iblockdata1.setValue(ATTACHMENT, flag1 ? BellAttachType.FLOOR : BellAttachType.CEILING)).canSurvive(blockactioncontext.getLevel(), blockactioncontext.getClickedPos())) {
                return iblockdata1;
            }
        }
        return null;
    }

    @Override
    protected void onExplosionHit(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPos> biconsumer) {
        if (explosion.canTriggerBlocks()) {
            this.attemptToRing(worldserver, blockposition, null);
        }
        super.onExplosionHit(iblockdata, worldserver, blockposition, explosion, biconsumer);
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        BellAttachType blockpropertybellattach = iblockdata.getValue(ATTACHMENT);
        Direction enumdirection1 = BellBlock.getConnectedDirection(iblockdata).getOpposite();
        if (enumdirection1 == enumdirection && !iblockdata.canSurvive(iworldreader, blockposition) && blockpropertybellattach != BellAttachType.DOUBLE_WALL) {
            return Blocks.AIR.defaultBlockState();
        }
        if (enumdirection.getAxis() == iblockdata.getValue(FACING).getAxis()) {
            if (blockpropertybellattach == BellAttachType.DOUBLE_WALL && !iblockdata1.isFaceSturdy(iworldreader, blockposition1, enumdirection)) {
                return (BlockState)((BlockState)iblockdata.setValue(ATTACHMENT, BellAttachType.SINGLE_WALL)).setValue(FACING, enumdirection.getOpposite());
            }
            if (blockpropertybellattach == BellAttachType.SINGLE_WALL && enumdirection1.getOpposite() == enumdirection && iblockdata1.isFaceSturdy(iworldreader, blockposition1, iblockdata.getValue(FACING))) {
                return (BlockState)iblockdata.setValue(ATTACHMENT, BellAttachType.DOUBLE_WALL);
            }
        }
        return super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    protected boolean canSurvive(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        Direction enumdirection = BellBlock.getConnectedDirection(iblockdata).getOpposite();
        return enumdirection == Direction.UP ? Block.canSupportCenter(iworldreader, blockposition.above(), Direction.DOWN) : FaceAttachedHorizontalDirectionalBlock.canAttach(iworldreader, blockposition, enumdirection);
    }

    private static Direction getConnectedDirection(BlockState iblockdata) {
        switch (iblockdata.getValue(ATTACHMENT)) {
            case FLOOR: {
                return Direction.UP;
            }
            case CEILING: {
                return Direction.DOWN;
            }
        }
        return iblockdata.getValue(FACING).getOpposite();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(FACING, ATTACHMENT, POWERED);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        return new BellBlockEntity(blockposition, iblockdata);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState iblockdata, BlockEntityType<T> tileentitytypes) {
        return BellBlock.createTickerHelper(tileentitytypes, BlockEntityType.BELL, world.isClientSide() ? BellBlockEntity::clientTick : BellBlockEntity::serverTick);
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return false;
    }

    @Override
    public BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        return (BlockState)iblockdata.setValue(FACING, enumblockrotation.rotate(iblockdata.getValue(FACING)));
    }

    @Override
    public BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        return iblockdata.rotate(enumblockmirror.getRotation(iblockdata.getValue(FACING)));
    }
}

