/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityInteractEvent;

public class ButtonBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static final MapCodec<ButtonBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(blockbuttonabstract -> blockbuttonabstract.type), (App)Codec.intRange((int)1, (int)1024).fieldOf("ticks_to_stay_pressed").forGetter(blockbuttonabstract -> blockbuttonabstract.ticksToStayPressed), ButtonBlock.propertiesCodec()).apply((Applicative)instance, ButtonBlock::new));
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private final BlockSetType type;
    private final int ticksToStayPressed;
    private final Function<BlockState, VoxelShape> shapes;

    public MapCodec<ButtonBlock> codec() {
        return CODEC;
    }

    protected ButtonBlock(BlockSetType blocksettype, int i, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info.sound(blocksettype.soundType()));
        this.type = blocksettype;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(POWERED, false)).setValue(FACE, AttachFace.WALL));
        this.ticksToStayPressed = i;
        this.shapes = this.makeShapes();
    }

    private Function<BlockState, VoxelShape> makeShapes() {
        VoxelShape voxelshape = Block.cube(14.0);
        VoxelShape voxelshape1 = Block.cube(12.0);
        Map<AttachFace, Map<Direction, VoxelShape>> map = Shapes.rotateAttachFace(Block.boxZ(6.0, 4.0, 8.0, 16.0));
        return this.getShapeForEachState(iblockdata -> Shapes.join((VoxelShape)((Map)map.get(iblockdata.getValue(FACE))).get(iblockdata.getValue(FACING)), iblockdata.getValue(POWERED) != false ? voxelshape : voxelshape1, BooleanOp.ONLY_FIRST));
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return this.shapes.apply(iblockdata);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        if (iblockdata.getValue(POWERED).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        boolean powered = iblockdata.getValue(POWERED);
        org.bukkit.block.Block block = world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
        int old = powered ? 15 : 0;
        int current = !powered ? 15 : 0;
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() > 0 != !powered) {
            return InteractionResult.SUCCESS;
        }
        this.press(iblockdata, world, blockposition, entityhuman);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void onExplosionHit(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPos> biconsumer) {
        if (explosion.canTriggerBlocks() && !iblockdata.getValue(POWERED).booleanValue()) {
            this.press(iblockdata, worldserver, blockposition, null);
        }
        super.onExplosionHit(iblockdata, worldserver, blockposition, explosion, biconsumer);
    }

    public void press(BlockState iblockdata, Level world, BlockPos blockposition, @Nullable Player entityhuman) {
        world.setBlock(blockposition, (BlockState)iblockdata.setValue(POWERED, true), 3);
        this.updateNeighbours(iblockdata, world, blockposition);
        world.scheduleTick(blockposition, this, this.ticksToStayPressed);
        this.playSound(entityhuman, world, blockposition, true);
        world.gameEvent((net.minecraft.world.entity.Entity)entityhuman, GameEvent.BLOCK_ACTIVATE, blockposition);
    }

    protected void playSound(@Nullable Player entityhuman, LevelAccessor generatoraccess, BlockPos blockposition, boolean flag) {
        generatoraccess.playSound(flag ? entityhuman : null, blockposition, this.getSound(flag), SoundSource.BLOCKS);
    }

    protected SoundEvent getSound(boolean flag) {
        return flag ? this.type.buttonClickOn() : this.type.buttonClickOff();
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, boolean flag) {
        if (!flag && iblockdata.getValue(POWERED).booleanValue()) {
            this.updateNeighbours(iblockdata, worldserver, blockposition);
        }
    }

    @Override
    protected int getSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return iblockdata.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return iblockdata.getValue(POWERED) != false && ButtonBlock.getConnectedDirection(iblockdata) == enumdirection ? 15 : 0;
    }

    @Override
    protected boolean isSignalSource(BlockState iblockdata) {
        return true;
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(POWERED).booleanValue()) {
            this.checkPressed(iblockdata, worldserver, blockposition);
        }
    }

    @Override
    protected void entityInside(BlockState iblockdata, Level world, BlockPos blockposition, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier insideblockeffectapplier) {
        if (!world.isClientSide() && this.type.canButtonBeActivatedByArrows() && !iblockdata.getValue(POWERED).booleanValue()) {
            this.checkPressed(iblockdata, world, blockposition);
        }
    }

    protected void checkPressed(BlockState iblockdata, Level world, BlockPos blockposition) {
        AbstractArrow entityarrow = this.type.canButtonBeActivatedByArrows() ? (AbstractArrow)world.getEntitiesOfClass(AbstractArrow.class, iblockdata.getShape(world, blockposition).bounds().move(blockposition)).stream().findFirst().orElse(null) : null;
        boolean flag = entityarrow != null;
        boolean flag1 = iblockdata.getValue(POWERED);
        if (flag1 != flag && flag) {
            org.bukkit.block.Block block = world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
            EntityInteractEvent event = new EntityInteractEvent((Entity)entityarrow.getBukkitEntity(), block);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        if (flag != flag1) {
            boolean powered = flag1;
            org.bukkit.block.Block block = world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
            int old = powered ? 15 : 0;
            int current = !powered ? 15 : 0;
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
            world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            if (flag && eventRedstone.getNewCurrent() <= 0 || !flag && eventRedstone.getNewCurrent() > 0) {
                return;
            }
            world.setBlock(blockposition, (BlockState)iblockdata.setValue(POWERED, flag), 3);
            this.updateNeighbours(iblockdata, world, blockposition);
            this.playSound(null, world, blockposition, flag);
            world.gameEvent((net.minecraft.world.entity.Entity)entityarrow, flag ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE, blockposition);
        }
        if (flag) {
            world.scheduleTick(new BlockPos(blockposition), this, this.ticksToStayPressed);
        }
    }

    private void updateNeighbours(BlockState iblockdata, Level world, BlockPos blockposition) {
        Direction enumdirection;
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation(world, enumdirection, (enumdirection = ButtonBlock.getConnectedDirection(iblockdata).getOpposite()).getAxis().isHorizontal() ? Direction.UP : (Direction)iblockdata.getValue(FACING));
        world.updateNeighborsAt(blockposition, this, orientation);
        world.updateNeighborsAt(blockposition.relative(enumdirection), this, orientation);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(FACING, POWERED, FACE);
    }
}

