/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SelectableSlotContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class ChiseledBookShelfBlock
extends BaseEntityBlock
implements SelectableSlotContainer {
    public static final MapCodec<ChiseledBookShelfBlock> CODEC = ChiseledBookShelfBlock.simpleCodec(ChiseledBookShelfBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty SLOT_0_OCCUPIED = BlockStateProperties.SLOT_0_OCCUPIED;
    public static final BooleanProperty SLOT_1_OCCUPIED = BlockStateProperties.SLOT_1_OCCUPIED;
    public static final BooleanProperty SLOT_2_OCCUPIED = BlockStateProperties.SLOT_2_OCCUPIED;
    public static final BooleanProperty SLOT_3_OCCUPIED = BlockStateProperties.SLOT_3_OCCUPIED;
    public static final BooleanProperty SLOT_4_OCCUPIED = BlockStateProperties.SLOT_4_OCCUPIED;
    public static final BooleanProperty SLOT_5_OCCUPIED = BlockStateProperties.SLOT_5_OCCUPIED;
    private static final int MAX_BOOKS_IN_STORAGE = 6;
    private static final int BOOKS_PER_ROW = 3;
    public static final List<BooleanProperty> SLOT_OCCUPIED_PROPERTIES = List.of(SLOT_0_OCCUPIED, SLOT_1_OCCUPIED, SLOT_2_OCCUPIED, SLOT_3_OCCUPIED, SLOT_4_OCCUPIED, SLOT_5_OCCUPIED);

    public MapCodec<ChiseledBookShelfBlock> codec() {
        return CODEC;
    }

    @Override
    public int getRows() {
        return 2;
    }

    @Override
    public int getColumns() {
        return 3;
    }

    public ChiseledBookShelfBlock(BlockBehaviour.Properties var0) {
        super(var0);
        BlockState var1 = (BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH);
        for (BooleanProperty var3 : SLOT_OCCUPIED_PROPERTIES) {
            var1 = (BlockState)var1.setValue(var3, false);
        }
        this.registerDefaultState(var1);
    }

    @Override
    protected InteractionResult useItemOn(ItemStack var0, BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, BlockHitResult var6) {
        BlockEntity blockEntity = var2.getBlockEntity(var3);
        if (!(blockEntity instanceof ChiseledBookShelfBlockEntity)) {
            return InteractionResult.PASS;
        }
        ChiseledBookShelfBlockEntity var7 = (ChiseledBookShelfBlockEntity)blockEntity;
        if (!var0.is(ItemTags.BOOKSHELF_BOOKS)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        OptionalInt var8 = this.getHitSlot(var6, var1.getValue(FACING));
        if (var8.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (((Boolean)var1.getValue(SLOT_OCCUPIED_PROPERTIES.get(var8.getAsInt()))).booleanValue()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        ChiseledBookShelfBlock.addBook(var2, var3, var4, var7, var0, var8.getAsInt());
        return InteractionResult.SUCCESS;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState var0, Level var1, BlockPos var2, Player var3, BlockHitResult var4) {
        BlockEntity blockEntity = var1.getBlockEntity(var2);
        if (!(blockEntity instanceof ChiseledBookShelfBlockEntity)) {
            return InteractionResult.PASS;
        }
        ChiseledBookShelfBlockEntity var5 = (ChiseledBookShelfBlockEntity)blockEntity;
        OptionalInt var6 = this.getHitSlot(var4, var0.getValue(FACING));
        if (var6.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (!((Boolean)var0.getValue(SLOT_OCCUPIED_PROPERTIES.get(var6.getAsInt()))).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        ChiseledBookShelfBlock.removeBook(var1, var2, var3, var5, var6.getAsInt());
        return InteractionResult.SUCCESS;
    }

    private static void addBook(Level var0, BlockPos var1, Player var2, ChiseledBookShelfBlockEntity var3, ItemStack var4, int var5) {
        if (var0.isClientSide()) {
            return;
        }
        var2.awardStat(Stats.ITEM_USED.get(var4.getItem()));
        SoundEvent var6 = var4.is(Items.ENCHANTED_BOOK) ? SoundEvents.CHISELED_BOOKSHELF_INSERT_ENCHANTED : SoundEvents.CHISELED_BOOKSHELF_INSERT;
        var3.setItem(var5, var4.consumeAndReturn(1, var2));
        var0.playSound(null, var1, var6, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void removeBook(Level var0, BlockPos var1, Player var2, ChiseledBookShelfBlockEntity var3, int var4) {
        if (var0.isClientSide()) {
            return;
        }
        ItemStack var5 = var3.removeItem(var4, 1);
        SoundEvent var6 = var5.is(Items.ENCHANTED_BOOK) ? SoundEvents.CHISELED_BOOKSHELF_PICKUP_ENCHANTED : SoundEvents.CHISELED_BOOKSHELF_PICKUP;
        var0.playSound(null, var1, var6, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!var2.getInventory().add(var5)) {
            var2.drop(var5, false);
        }
        var0.gameEvent((Entity)var2, GameEvent.BLOCK_CHANGE, var1);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos var0, BlockState var1) {
        return new ChiseledBookShelfBlockEntity(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(FACING);
        SLOT_OCCUPIED_PROPERTIES.forEach(var1 -> var0.add((Property<?>)var1));
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState var0, ServerLevel var1, BlockPos var2, boolean var3) {
        Containers.updateNeighboursAfterDestroy(var0, var1, var2);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        return (BlockState)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection().getOpposite());
    }

    @Override
    public BlockState rotate(BlockState var0, Rotation var1) {
        return (BlockState)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public BlockState mirror(BlockState var0, Mirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState var0, Level var1, BlockPos var2, Direction var3) {
        if (var1.isClientSide()) {
            return 0;
        }
        BlockEntity blockEntity = var1.getBlockEntity(var2);
        if (blockEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity var4 = (ChiseledBookShelfBlockEntity)blockEntity;
            return var4.getLastInteractedSlot() + 1;
        }
        return 0;
    }
}

