/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class CocoaBlock
extends HorizontalDirectionalBlock
implements BonemealableBlock {
    public static final MapCodec<CocoaBlock> CODEC = CocoaBlock.simpleCodec(CocoaBlock::new);
    public static final int MAX_AGE = 2;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_2;
    private static final List<Map<Direction, VoxelShape>> SHAPES = IntStream.rangeClosed(0, 2).mapToObj(i -> Shapes.rotateHorizontal(Block.column(4 + i * 2, 7 - i * 2, 12.0).move(0.0, 0.0, (double)(i - 5) / 16.0).optimize())).toList();

    public MapCodec<CocoaBlock> codec() {
        return CODEC;
    }

    public CocoaBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(AGE, 0));
    }

    @Override
    protected boolean isRandomlyTicking(BlockState iblockdata) {
        return iblockdata.getValue(AGE) < 2;
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        int i;
        if (worldserver.random.nextFloat() < (float)worldserver.spigotConfig.cocoaModifier / 500.0f && (i = iblockdata.getValue(AGE).intValue()) < 2) {
            CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, (BlockState)iblockdata.setValue(AGE, i + 1), 2);
        }
    }

    @Override
    protected boolean canSurvive(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        BlockState iblockdata1 = iworldreader.getBlockState(blockposition.relative((Direction)iblockdata.getValue(FACING)));
        return iblockdata1.is(BlockTags.JUNGLE_LOGS);
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPES.get(iblockdata.getValue(AGE)).get(iblockdata.getValue(FACING));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        BlockState iblockdata = this.defaultBlockState();
        Level iworldreader = blockactioncontext.getLevel();
        BlockPos blockposition = blockactioncontext.getClickedPos();
        for (Direction enumdirection : blockactioncontext.getNearestLookingDirections()) {
            if (!enumdirection.getAxis().isHorizontal() || !(iblockdata = (BlockState)iblockdata.setValue(FACING, enumdirection)).canSurvive(iworldreader, blockposition)) continue;
            return iblockdata;
        }
        return null;
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        return enumdirection == iblockdata.getValue(FACING) && !iblockdata.canSurvive(iworldreader, blockposition) ? Blocks.AIR.defaultBlockState() : super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata) {
        return iblockdata.getValue(AGE) < 2;
    }

    @Override
    public boolean isBonemealSuccess(Level world, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel worldserver, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, (BlockState)iblockdata.setValue(AGE, iblockdata.getValue(AGE) + 1), 2);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(FACING, AGE);
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return false;
    }
}

