/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class DecoratedPotBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<DecoratedPotBlock> CODEC = DecoratedPotBlock.simpleCodec(DecoratedPotBlock::new);
    public static final ResourceLocation SHERDS_DYNAMIC_DROP_ID = ResourceLocation.withDefaultNamespace("sherds");
    public static final EnumProperty<Direction> HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty CRACKED = BlockStateProperties.CRACKED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Block.column(14.0, 0.0, 16.0);

    public MapCodec<DecoratedPotBlock> codec() {
        return CODEC;
    }

    protected DecoratedPotBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HORIZONTAL_FACING, Direction.NORTH)).setValue(WATERLOGGED, false)).setValue(CRACKED, false));
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            scheduledtickaccess.scheduleTick(blockposition, Fluids.WATER, Fluids.WATER.getTickDelay(iworldreader));
        }
        return super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        FluidState fluid = blockactioncontext.getLevel().getFluidState(blockactioncontext.getClickedPos());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, blockactioncontext.getHorizontalDirection())).setValue(WATERLOGGED, fluid.getType() == Fluids.WATER)).setValue(CRACKED, false);
    }

    @Override
    protected InteractionResult useItemOn(ItemStack itemstack, BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, BlockHitResult movingobjectpositionblock) {
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            if (world.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            ItemStack itemstack1 = decoratedpotblockentity.getTheItem();
            if (!itemstack.isEmpty() && (itemstack1.isEmpty() || ItemStack.isSameItemSameComponents(itemstack1, itemstack) && itemstack1.getCount() < itemstack1.getMaxStackSize())) {
                float f;
                decoratedpotblockentity.wobble(DecoratedPotBlockEntity.WobbleStyle.POSITIVE);
                entityhuman.awardStat(Stats.ITEM_USED.get(itemstack.getItem()));
                ItemStack itemstack2 = itemstack.consumeAndReturn(1, entityhuman);
                if (decoratedpotblockentity.isEmpty()) {
                    decoratedpotblockentity.setTheItem(itemstack2);
                    f = (float)itemstack2.getCount() / (float)itemstack2.getMaxStackSize();
                } else {
                    itemstack1.grow(1);
                    f = (float)itemstack1.getCount() / (float)itemstack1.getMaxStackSize();
                }
                world.playSound((Entity)null, blockposition, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 0.7f + 0.5f * f);
                if (world instanceof ServerLevel) {
                    ServerLevel worldserver = (ServerLevel)world;
                    worldserver.sendParticles(ParticleTypes.DUST_PLUME, (double)blockposition.getX() + 0.5, (double)blockposition.getY() + 1.2, (double)blockposition.getZ() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
                }
                decoratedpotblockentity.setChanged();
                world.gameEvent((Entity)entityhuman, GameEvent.BLOCK_CHANGE, blockposition);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            world.playSound((Entity)null, blockposition, SoundEvents.DECORATED_POT_INSERT_FAIL, SoundSource.BLOCKS, 1.0f, 1.0f);
            decoratedpotblockentity.wobble(DecoratedPotBlockEntity.WobbleStyle.NEGATIVE);
            world.gameEvent((Entity)entityhuman, GameEvent.BLOCK_CHANGE, blockposition);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return false;
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPE;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(HORIZONTAL_FACING, WATERLOGGED, CRACKED);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        return new DecoratedPotBlockEntity(blockposition, iblockdata);
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, boolean flag) {
        Containers.updateNeighboursAfterDestroy(iblockdata, worldserver, blockposition);
    }

    @Override
    protected List<ItemStack> getDrops(BlockState iblockdata, LootParams.Builder lootparams_a) {
        BlockEntity tileentity = lootparams_a.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            lootparams_a.withDynamicDrop(SHERDS_DYNAMIC_DROP_ID, consumer -> {
                for (Item item : decoratedpotblockentity.getDecorations().ordered()) {
                    consumer.accept(item.getDefaultInstance());
                }
            });
        }
        return super.getDrops(iblockdata, lootparams_a);
    }

    @Override
    public BlockState playerWillDestroy(Level world, BlockPos blockposition, BlockState iblockdata, Player entityhuman) {
        ItemStack itemstack = entityhuman.getMainHandItem();
        BlockState iblockdata1 = iblockdata;
        if (itemstack.is(ItemTags.BREAKS_DECORATED_POTS) && !EnchantmentHelper.hasTag(itemstack, EnchantmentTags.PREVENTS_DECORATED_POT_SHATTERING)) {
            iblockdata1 = (BlockState)iblockdata.setValue(CRACKED, true);
            world.setBlock(blockposition, iblockdata1, 260);
        }
        return super.playerWillDestroy(world, blockposition, iblockdata1, entityhuman);
    }

    @Override
    protected FluidState getFluidState(BlockState iblockdata) {
        return iblockdata.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(iblockdata);
    }

    @Override
    protected SoundType getSoundType(BlockState iblockdata) {
        return iblockdata.getValue(CRACKED) != false ? SoundType.DECORATED_POT_CRACKED : SoundType.DECORATED_POT;
    }

    @Override
    protected void onProjectileHit(Level world, BlockState iblockdata, BlockHitResult movingobjectpositionblock, Projectile iprojectile) {
        ServerLevel worldserver;
        BlockPos blockposition = movingobjectpositionblock.getBlockPos();
        if (world instanceof ServerLevel && iprojectile.mayInteract(worldserver = (ServerLevel)world, blockposition) && iprojectile.mayBreak(worldserver)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(iprojectile, blockposition, this.getFluidState(iblockdata).createLegacyBlock())) {
                return;
            }
            world.setBlock(blockposition, (BlockState)iblockdata.setValue(CRACKED, true), 260);
            world.destroyBlock(blockposition, true, iprojectile);
        }
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata, boolean flag) {
        BlockEntity tileentity = iworldreader.getBlockEntity(blockposition);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            PotDecorations potdecorations = decoratedpotblockentity.getDecorations();
            return DecoratedPotBlockEntity.createDecoratedPotItem(potdecorations);
        }
        return super.getCloneItemStack(iworldreader, blockposition, iblockdata, flag);
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState iblockdata) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState iblockdata, Level world, BlockPos blockposition, Direction enumdirection) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity(world.getBlockEntity(blockposition));
    }

    @Override
    protected BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        return (BlockState)iblockdata.setValue(HORIZONTAL_FACING, enumblockrotation.rotate(iblockdata.getValue(HORIZONTAL_FACING)));
    }

    @Override
    protected BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        return iblockdata.rotate(enumblockmirror.getRotation(iblockdata.getValue(HORIZONTAL_FACING)));
    }
}

