/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.math.OctahedralGroup;
import com.mojang.serialization.Codec;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Rotation;

public enum Mirror implements StringRepresentable
{
    NONE("none", OctahedralGroup.IDENTITY),
    LEFT_RIGHT("left_right", OctahedralGroup.INVERT_Z),
    FRONT_BACK("front_back", OctahedralGroup.INVERT_X);

    public static final Codec<Mirror> CODEC;
    @Deprecated
    public static final Codec<Mirror> LEGACY_CODEC;
    private final String id;
    private final Component symbol;
    private final OctahedralGroup rotation;

    private Mirror(String var2, OctahedralGroup var3) {
        this.id = var2;
        this.symbol = Component.translatable("mirror." + var2);
        this.rotation = var3;
    }

    public int mirror(int var0, int var1) {
        int var2 = var1 / 2;
        int var3 = var0 > var2 ? var0 - var1 : var0;
        switch (this.ordinal()) {
            case 2: {
                return (var1 - var3) % var1;
            }
            case 1: {
                return (var2 - var3 + var1) % var1;
            }
        }
        return var0;
    }

    public Rotation getRotation(Direction var0) {
        Direction.Axis var1 = var0.getAxis();
        return this == LEFT_RIGHT && var1 == Direction.Axis.Z || this == FRONT_BACK && var1 == Direction.Axis.X ? Rotation.CLOCKWISE_180 : Rotation.NONE;
    }

    public Direction mirror(Direction var0) {
        if (this == FRONT_BACK && var0.getAxis() == Direction.Axis.X) {
            return var0.getOpposite();
        }
        if (this == LEFT_RIGHT && var0.getAxis() == Direction.Axis.Z) {
            return var0.getOpposite();
        }
        return var0;
    }

    public OctahedralGroup rotation() {
        return this.rotation;
    }

    public Component symbol() {
        return this.symbol;
    }

    @Override
    public String getSerializedName() {
        return this.id;
    }

    static {
        CODEC = StringRepresentable.fromEnum(Mirror::values);
        LEGACY_CODEC = ExtraCodecs.legacyEnum(Mirror::valueOf);
    }
}

