/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class PipeBlock
extends Block {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(Direction.NORTH, NORTH, Direction.EAST, EAST, Direction.SOUTH, SOUTH, Direction.WEST, WEST, Direction.UP, UP, Direction.DOWN, DOWN)));
    private final Function<BlockState, VoxelShape> shapes;

    protected PipeBlock(float var0, BlockBehaviour.Properties var1) {
        super(var1);
        this.shapes = this.makeShapes(var0);
    }

    protected abstract MapCodec<? extends PipeBlock> codec();

    private Function<BlockState, VoxelShape> makeShapes(float var0) {
        VoxelShape var1 = Block.cube(var0);
        Map<Direction, VoxelShape> var22 = Shapes.rotateAll(Block.boxZ(var0, 0.0, 8.0));
        return this.getShapeForEachState(var2 -> {
            VoxelShape var3 = var1;
            for (Map.Entry<Direction, BooleanProperty> var5 : PROPERTY_BY_DIRECTION.entrySet()) {
                if (!((Boolean)var2.getValue(var5.getValue())).booleanValue()) continue;
                var3 = Shapes.or((VoxelShape)var22.get(var5.getKey()), var3);
            }
            return var3;
        });
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState var0) {
        return false;
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return this.shapes.apply(var0);
    }
}

