/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class TintedParticleLeavesBlock
extends LeavesBlock {
    public static final MapCodec<TintedParticleLeavesBlock> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)ExtraCodecs.floatRange(0.0f, 1.0f).fieldOf("leaf_particle_chance").forGetter(var0 -> Float.valueOf(var0.leafParticleChance)), TintedParticleLeavesBlock.propertiesCodec()).apply((Applicative)var02, TintedParticleLeavesBlock::new));

    public TintedParticleLeavesBlock(float var0, BlockBehaviour.Properties var1) {
        super(var0, var1);
    }

    @Override
    protected void spawnFallingLeavesParticle(Level var0, BlockPos var1, RandomSource var2) {
        ColorParticleOption var3 = ColorParticleOption.create(ParticleTypes.TINTED_LEAVES, var0.getClientLeafTintColor(var1));
        ParticleUtils.spawnParticleBelow(var0, var1, var2, var3);
    }

    public MapCodec<? extends TintedParticleLeavesBlock> codec() {
        return CODEC;
    }
}

