/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class EnchantingTableBlockEntity
extends BlockEntity
implements Nameable {
    private static final Component DEFAULT_NAME = Component.translatable("container.enchant");
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    public float rot;
    public float oRot;
    public float tRot;
    private static final RandomSource RANDOM = RandomSource.create();
    @Nullable
    private Component name;

    public EnchantingTableBlockEntity(BlockPos var0, BlockState var1) {
        super(BlockEntityType.ENCHANTING_TABLE, var0, var1);
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        var0.storeNullable("CustomName", ComponentSerialization.CODEC, this.name);
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        this.name = EnchantingTableBlockEntity.parseCustomNameSafe(var0, "CustomName");
    }

    public static void bookAnimationTick(Level var0, BlockPos var1, BlockState var2, EnchantingTableBlockEntity var3) {
        float var5;
        var3.oOpen = var3.open;
        var3.oRot = var3.rot;
        Player var4 = var0.getNearestPlayer((double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, 3.0, false);
        if (var4 != null) {
            double var52 = var4.getX() - ((double)var1.getX() + 0.5);
            double var7 = var4.getZ() - ((double)var1.getZ() + 0.5);
            var3.tRot = (float)Mth.atan2(var7, var52);
            var3.open += 0.1f;
            if (var3.open < 0.5f || RANDOM.nextInt(40) == 0) {
                float var9 = var3.flipT;
                do {
                    var3.flipT += (float)(RANDOM.nextInt(4) - RANDOM.nextInt(4));
                } while (var9 == var3.flipT);
            }
        } else {
            var3.tRot += 0.02f;
            var3.open -= 0.1f;
        }
        while (var3.rot >= (float)Math.PI) {
            var3.rot -= (float)Math.PI * 2;
        }
        while (var3.rot < (float)(-Math.PI)) {
            var3.rot += (float)Math.PI * 2;
        }
        while (var3.tRot >= (float)Math.PI) {
            var3.tRot -= (float)Math.PI * 2;
        }
        while (var3.tRot < (float)(-Math.PI)) {
            var3.tRot += (float)Math.PI * 2;
        }
        for (var5 = var3.tRot - var3.rot; var5 >= (float)Math.PI; var5 -= (float)Math.PI * 2) {
        }
        while (var5 < (float)(-Math.PI)) {
            var5 += (float)Math.PI * 2;
        }
        var3.rot += var5 * 0.4f;
        var3.open = Mth.clamp(var3.open, 0.0f, 1.0f);
        ++var3.time;
        var3.oFlip = var3.flip;
        float var6 = (var3.flipT - var3.flip) * 0.4f;
        float var7 = 0.2f;
        var6 = Mth.clamp(var6, -0.2f, 0.2f);
        var3.flipA += (var6 - var3.flipA) * 0.9f;
        var3.flip += var3.flipA;
    }

    @Override
    public Component getName() {
        if (this.name != null) {
            return this.name;
        }
        return DEFAULT_NAME;
    }

    public void setCustomName(@Nullable Component var0) {
        this.name = var0;
    }

    @Override
    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        super.applyImplicitComponents(var0);
        this.name = var0.get(DataComponents.CUSTOM_NAME);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder var0) {
        super.collectImplicitComponents(var0);
        var0.set(DataComponents.CUSTOM_NAME, this.name);
    }

    @Override
    public void removeComponentsFromTag(ValueOutput var0) {
        var0.discard("CustomName");
    }
}

