/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;

public class ShulkerBoxBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    public static final int COLUMNS = 9;
    public static final int ROWS = 3;
    public static final int CONTAINER_SIZE = 27;
    public static final int EVENT_SET_OPEN_COUNT = 1;
    public static final int OPENING_TICK_LENGTH = 10;
    public static final float MAX_LID_HEIGHT = 0.5f;
    public static final float MAX_LID_ROTATION = 270.0f;
    private static final int[] SLOTS = IntStream.range(0, 27).toArray();
    private static final Component DEFAULT_NAME = Component.translatable("container.shulkerBox");
    private NonNullList<ItemStack> itemStacks;
    public int openCount;
    private AnimationStatus animationStatus;
    private float progress;
    private float progressOld;
    @Nullable
    private final DyeColor color;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;
    public boolean opened;

    @Override
    public List<ItemStack> getContents() {
        return this.itemStacks;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public ShulkerBoxBlockEntity(@Nullable DyeColor enumcolor, BlockPos blockposition, BlockState iblockdata) {
        super(BlockEntityType.SHULKER_BOX, blockposition, iblockdata);
        this.itemStacks = NonNullList.withSize(27, ItemStack.EMPTY);
        this.animationStatus = AnimationStatus.CLOSED;
        this.color = enumcolor;
    }

    public ShulkerBoxBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        super(BlockEntityType.SHULKER_BOX, blockposition, iblockdata);
        DyeColor enumcolor;
        this.itemStacks = NonNullList.withSize(27, ItemStack.EMPTY);
        this.animationStatus = AnimationStatus.CLOSED;
        Block block = iblockdata.getBlock();
        if (block instanceof ShulkerBoxBlock) {
            ShulkerBoxBlock blockshulkerbox = (ShulkerBoxBlock)block;
            enumcolor = blockshulkerbox.getColor();
        } else {
            enumcolor = null;
        }
        this.color = enumcolor;
    }

    public static void tick(Level world, BlockPos blockposition, BlockState iblockdata, ShulkerBoxBlockEntity tileentityshulkerbox) {
        tileentityshulkerbox.updateAnimation(world, blockposition, iblockdata);
    }

    private void updateAnimation(Level world, BlockPos blockposition, BlockState iblockdata) {
        this.progressOld = this.progress;
        switch (this.animationStatus.ordinal()) {
            case 0: {
                this.progress = 0.0f;
                break;
            }
            case 1: {
                this.progress += 0.1f;
                if (this.progressOld == 0.0f) {
                    ShulkerBoxBlockEntity.doNeighborUpdates(world, blockposition, iblockdata);
                }
                if (this.progress >= 1.0f) {
                    this.animationStatus = AnimationStatus.OPENED;
                    this.progress = 1.0f;
                    ShulkerBoxBlockEntity.doNeighborUpdates(world, blockposition, iblockdata);
                }
                this.moveCollidedEntities(world, blockposition, iblockdata);
                break;
            }
            case 2: {
                this.progress = 1.0f;
                break;
            }
            case 3: {
                this.progress -= 0.1f;
                if (this.progressOld == 1.0f) {
                    ShulkerBoxBlockEntity.doNeighborUpdates(world, blockposition, iblockdata);
                }
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = AnimationStatus.CLOSED;
                this.progress = 0.0f;
                ShulkerBoxBlockEntity.doNeighborUpdates(world, blockposition, iblockdata);
            }
        }
    }

    public AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    public AABB getBoundingBox(BlockState iblockdata) {
        Vec3 vec3d = new Vec3(0.5, 0.0, 0.5);
        return Shulker.getProgressAabb(1.0f, iblockdata.getValue(ShulkerBoxBlock.FACING), 0.5f * this.getProgress(1.0f), vec3d);
    }

    private void moveCollidedEntities(Level world, BlockPos blockposition, BlockState iblockdata) {
        Direction enumdirection;
        AABB axisalignedbb;
        List<Entity> list;
        if (iblockdata.getBlock() instanceof ShulkerBoxBlock && !(list = world.getEntities(null, axisalignedbb = Shulker.getProgressDeltaAabb(1.0f, enumdirection = iblockdata.getValue(ShulkerBoxBlock.FACING), this.progressOld, this.progress, blockposition.getBottomCenter()))).isEmpty()) {
            for (Entity entity : list) {
                if (entity.getPistonPushReaction() == PushReaction.IGNORE) continue;
                entity.move(MoverType.SHULKER_BOX, new Vec3((axisalignedbb.getXsize() + 0.01) * (double)enumdirection.getStepX(), (axisalignedbb.getYsize() + 0.01) * (double)enumdirection.getStepY(), (axisalignedbb.getZsize() + 0.01) * (double)enumdirection.getStepZ()));
            }
        }
    }

    @Override
    public int getContainerSize() {
        return this.itemStacks.size();
    }

    @Override
    public boolean triggerEvent(int i, int j) {
        if (i == 1) {
            this.openCount = j;
            if (j == 0) {
                this.animationStatus = AnimationStatus.CLOSING;
            }
            if (j == 1) {
                this.animationStatus = AnimationStatus.OPENING;
            }
            return true;
        }
        return super.triggerEvent(i, j);
    }

    private static void doNeighborUpdates(Level world, BlockPos blockposition, BlockState iblockdata) {
        iblockdata.updateNeighbourShapes(world, blockposition, 3);
        world.updateNeighborsAt(blockposition, iblockdata.getBlock());
    }

    @Override
    public void preRemoveSideEffects(BlockPos blockposition, BlockState iblockdata) {
    }

    @Override
    public void startOpen(ContainerUser containeruser) {
        if (!this.remove && !containeruser.getLivingEntity().isSpectator()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            if (this.opened) {
                return;
            }
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.openCount);
            if (this.openCount == 1) {
                this.level.gameEvent((Entity)containeruser.getLivingEntity(), GameEvent.CONTAINER_OPEN, this.worldPosition);
                this.level.playSound((Entity)null, this.worldPosition, SoundEvents.SHULKER_BOX_OPEN, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @Override
    public void stopOpen(ContainerUser containeruser) {
        if (!this.remove && !containeruser.getLivingEntity().isSpectator()) {
            --this.openCount;
            if (this.opened) {
                return;
            }
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.level.gameEvent((Entity)containeruser.getLivingEntity(), GameEvent.CONTAINER_CLOSE, this.worldPosition);
                this.level.playSound((Entity)null, this.worldPosition, SoundEvents.SHULKER_BOX_CLOSE, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @Override
    protected Component getDefaultName() {
        return DEFAULT_NAME;
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        super.loadAdditional(valueinput);
        this.loadFromTag(valueinput);
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        super.saveAdditional(valueoutput);
        if (!this.trySaveLootTable(valueoutput)) {
            ContainerHelper.saveAllItems(valueoutput, this.itemStacks, false);
        }
    }

    public void loadFromTag(ValueInput valueinput) {
        this.itemStacks = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(valueinput)) {
            ContainerHelper.loadAllItems(valueinput, this.itemStacks);
        }
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.itemStacks;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> nonnulllist) {
        this.itemStacks = nonnulllist;
    }

    @Override
    public int[] getSlotsForFace(Direction enumdirection) {
        return SLOTS;
    }

    @Override
    public boolean canPlaceItemThroughFace(int i, ItemStack itemstack, @Nullable Direction enumdirection) {
        return !(Block.byItem(itemstack.getItem()) instanceof ShulkerBoxBlock);
    }

    @Override
    public boolean canTakeItemThroughFace(int i, ItemStack itemstack, Direction enumdirection) {
        return true;
    }

    public float getProgress(float f) {
        return Mth.lerp(f, this.progressOld, this.progress);
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    @Override
    protected AbstractContainerMenu createMenu(int i, Inventory playerinventory) {
        return new ShulkerBoxMenu(i, playerinventory, this);
    }

    public boolean isClosed() {
        return this.animationStatus == AnimationStatus.CLOSED;
    }

    public static enum AnimationStatus {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

