/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class SpawnerBlockEntity
extends BlockEntity
implements Spawner {
    private final BaseSpawner spawner = new BaseSpawner(this){

        @Override
        public void broadcastEvent(Level var0, BlockPos var1, int var2) {
            var0.blockEvent(var1, Blocks.SPAWNER, var2, 0);
        }

        @Override
        public void setNextSpawnData(@Nullable Level var0, BlockPos var1, SpawnData var2) {
            super.setNextSpawnData(var0, var1, var2);
            if (var0 != null) {
                BlockState var3 = var0.getBlockState(var1);
                var0.sendBlockUpdated(var1, var3, var3, 260);
            }
        }
    };

    public SpawnerBlockEntity(BlockPos var0, BlockState var1) {
        super(BlockEntityType.MOB_SPAWNER, var0, var1);
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        this.spawner.load(this.level, this.worldPosition, var0);
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        this.spawner.save(var0);
    }

    public static void clientTick(Level var0, BlockPos var1, BlockState var2, SpawnerBlockEntity var3) {
        var3.spawner.clientTick(var0, var1);
    }

    public static void serverTick(Level var0, BlockPos var1, BlockState var2, SpawnerBlockEntity var3) {
        var3.spawner.serverTick((ServerLevel)var0, var1);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider var0) {
        CompoundTag var1 = this.saveCustomOnly(var0);
        var1.remove("SpawnPotentials");
        return var1;
    }

    @Override
    public boolean triggerEvent(int var0, int var1) {
        if (this.spawner.onEventTriggered(this.level, var0)) {
            return true;
        }
        return super.triggerEvent(var0, var1);
    }

    @Override
    public void setEntityId(EntityType<?> var0, RandomSource var1) {
        this.spawner.setEntityId(var0, this.level, var1, this.worldPosition);
        this.setChanged();
    }

    public BaseSpawner getSpawner() {
        return this.spawner;
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

