/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.pattern;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class BlockPattern {
    private final Predicate<BlockInWorld>[][][] pattern;
    private final int depth;
    private final int height;
    private final int width;

    public BlockPattern(Predicate<BlockInWorld>[][][] var0) {
        this.pattern = var0;
        this.depth = var0.length;
        if (this.depth > 0) {
            this.height = var0[0].length;
            this.width = this.height > 0 ? var0[0][0].length : 0;
        } else {
            this.height = 0;
            this.width = 0;
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    @VisibleForTesting
    public Predicate<BlockInWorld>[][][] getPattern() {
        return this.pattern;
    }

    @Nullable
    @VisibleForTesting
    public BlockPatternMatch matches(LevelReader var0, BlockPos var1, Direction var2, Direction var3) {
        LoadingCache<BlockPos, BlockInWorld> var4 = BlockPattern.createLevelCache(var0, false);
        return this.matches(var1, var2, var3, var4);
    }

    @Nullable
    private BlockPatternMatch matches(BlockPos var0, Direction var1, Direction var2, LoadingCache<BlockPos, BlockInWorld> var3) {
        for (int var4 = 0; var4 < this.width; ++var4) {
            for (int var5 = 0; var5 < this.height; ++var5) {
                for (int var6 = 0; var6 < this.depth; ++var6) {
                    if (this.pattern[var6][var5][var4].test((BlockInWorld)var3.getUnchecked((Object)BlockPattern.translateAndRotate(var0, var1, var2, var4, var5, var6)))) continue;
                    return null;
                }
            }
        }
        return new BlockPatternMatch(var0, var1, var2, var3, this.width, this.height, this.depth);
    }

    @Nullable
    public BlockPatternMatch find(LevelReader var0, BlockPos var1) {
        LoadingCache<BlockPos, BlockInWorld> var2 = BlockPattern.createLevelCache(var0, false);
        int var3 = Math.max(Math.max(this.width, this.height), this.depth);
        for (BlockPos var5 : BlockPos.betweenClosed(var1, var1.offset(var3 - 1, var3 - 1, var3 - 1))) {
            for (Direction var9 : Direction.values()) {
                for (Direction var13 : Direction.values()) {
                    BlockPatternMatch var14;
                    if (var13 == var9 || var13 == var9.getOpposite() || (var14 = this.matches(var5, var9, var13, var2)) == null) continue;
                    return var14;
                }
            }
        }
        return null;
    }

    public static LoadingCache<BlockPos, BlockInWorld> createLevelCache(LevelReader var0, boolean var1) {
        return CacheBuilder.newBuilder().build((CacheLoader)new BlockCacheLoader(var0, var1));
    }

    protected static BlockPos translateAndRotate(BlockPos var0, Direction var1, Direction var2, int var3, int var4, int var5) {
        if (var1 == var2 || var1 == var2.getOpposite()) {
            throw new IllegalArgumentException("Invalid forwards & up combination");
        }
        Vec3i var6 = new Vec3i(var1.getStepX(), var1.getStepY(), var1.getStepZ());
        Vec3i var7 = new Vec3i(var2.getStepX(), var2.getStepY(), var2.getStepZ());
        Vec3i var8 = var6.cross(var7);
        return var0.offset(var7.getX() * -var4 + var8.getX() * var3 + var6.getX() * var5, var7.getY() * -var4 + var8.getY() * var3 + var6.getY() * var5, var7.getZ() * -var4 + var8.getZ() * var3 + var6.getZ() * var5);
    }

    public static class BlockPatternMatch {
        private final BlockPos frontTopLeft;
        private final Direction forwards;
        private final Direction up;
        private final LoadingCache<BlockPos, BlockInWorld> cache;
        private final int width;
        private final int height;
        private final int depth;

        public BlockPatternMatch(BlockPos var0, Direction var1, Direction var2, LoadingCache<BlockPos, BlockInWorld> var3, int var4, int var5, int var6) {
            this.frontTopLeft = var0;
            this.forwards = var1;
            this.up = var2;
            this.cache = var3;
            this.width = var4;
            this.height = var5;
            this.depth = var6;
        }

        public BlockPos getFrontTopLeft() {
            return this.frontTopLeft;
        }

        public Direction getForwards() {
            return this.forwards;
        }

        public Direction getUp() {
            return this.up;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getDepth() {
            return this.depth;
        }

        public BlockInWorld getBlock(int var0, int var1, int var2) {
            return (BlockInWorld)this.cache.getUnchecked((Object)BlockPattern.translateAndRotate(this.frontTopLeft, this.getForwards(), this.getUp(), var0, var1, var2));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("up", (Object)this.up).add("forwards", (Object)this.forwards).add("frontTopLeft", (Object)this.frontTopLeft).toString();
        }
    }

    static class BlockCacheLoader
    extends CacheLoader<BlockPos, BlockInWorld> {
        private final LevelReader level;
        private final boolean loadChunks;

        public BlockCacheLoader(LevelReader var0, boolean var1) {
            this.level = var0;
            this.loadChunks = var1;
        }

        public BlockInWorld load(BlockPos var0) {
            return new BlockInWorld(this.level, var0, this.loadChunks);
        }

        public /* synthetic */ Object load(Object object) throws Exception {
            return this.load((BlockPos)object);
        }
    }
}

