/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.border;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.BorderStatus;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WorldBorder
extends SavedData {
    public static final double MAX_SIZE = 5.9999968E7;
    public static final double MAX_CENTER_COORDINATE = 2.9999984E7;
    public static final Codec<WorldBorder> CODEC = Settings.CODEC.xmap(Settings::toWorldBorder, Settings::new);
    public static final SavedDataType<WorldBorder> TYPE = new SavedDataType<WorldBorder>("world_border", persistentbase_a -> Settings.DEFAULT.toWorldBorder(), persistentbase_a -> CODEC, DataFixTypes.SAVED_DATA_WORLD_BORDER);
    private final List<BorderChangeListener> listeners = Lists.newArrayList();
    double damagePerBlock = 0.2;
    double safeZone = 5.0;
    int warningTime = 15;
    int warningBlocks = 5;
    double centerX;
    double centerZ;
    int absoluteMaxSize = 29999984;
    BorderExtent extent = new StaticBorderExtent(5.9999968E7);

    public boolean isWithinBounds(BlockPos blockposition) {
        return this.isWithinBounds(blockposition.getX(), blockposition.getZ());
    }

    public boolean isWithinBounds(Vec3 vec3d) {
        return this.isWithinBounds(vec3d.x, vec3d.z);
    }

    public boolean isWithinBounds(ChunkPos chunkcoordintpair) {
        return this.isWithinBounds(chunkcoordintpair.getMinBlockX(), chunkcoordintpair.getMinBlockZ()) && this.isWithinBounds(chunkcoordintpair.getMaxBlockX(), chunkcoordintpair.getMaxBlockZ());
    }

    public boolean isWithinBounds(AABB axisalignedbb) {
        return this.isWithinBounds(axisalignedbb.minX, axisalignedbb.minZ, axisalignedbb.maxX - (double)1.0E-5f, axisalignedbb.maxZ - (double)1.0E-5f);
    }

    private boolean isWithinBounds(double d0, double d1, double d2, double d3) {
        return this.isWithinBounds(d0, d1) && this.isWithinBounds(d2, d3);
    }

    public boolean isWithinBounds(double d0, double d1) {
        return this.isWithinBounds(d0, d1, 0.0);
    }

    public boolean isWithinBounds(double d0, double d1, double d2) {
        return d0 >= this.getMinX() - d2 && d0 < this.getMaxX() + d2 && d1 >= this.getMinZ() - d2 && d1 < this.getMaxZ() + d2;
    }

    public BlockPos clampToBounds(BlockPos blockposition) {
        return this.clampToBounds(blockposition.getX(), blockposition.getY(), blockposition.getZ());
    }

    public BlockPos clampToBounds(Vec3 vec3d) {
        return this.clampToBounds(vec3d.x(), vec3d.y(), vec3d.z());
    }

    public BlockPos clampToBounds(double d0, double d1, double d2) {
        return BlockPos.containing(this.clampVec3ToBound(d0, d1, d2));
    }

    public Vec3 clampVec3ToBound(Vec3 vec3d) {
        return this.clampVec3ToBound(vec3d.x, vec3d.y, vec3d.z);
    }

    public Vec3 clampVec3ToBound(double d0, double d1, double d2) {
        return new Vec3(Mth.clamp(d0, this.getMinX(), this.getMaxX() - (double)1.0E-5f), d1, Mth.clamp(d2, this.getMinZ(), this.getMaxZ() - (double)1.0E-5f));
    }

    public double getDistanceToBorder(Entity entity) {
        return this.getDistanceToBorder(entity.getX(), entity.getZ());
    }

    public VoxelShape getCollisionShape() {
        return this.extent.getCollisionShape();
    }

    public double getDistanceToBorder(double d0, double d1) {
        double d2 = d1 - this.getMinZ();
        double d3 = this.getMaxZ() - d1;
        double d4 = d0 - this.getMinX();
        double d5 = this.getMaxX() - d0;
        double d6 = Math.min(d4, d5);
        d6 = Math.min(d6, d2);
        return Math.min(d6, d3);
    }

    public boolean isInsideCloseToBorder(Entity entity, AABB axisalignedbb) {
        double d0 = Math.max(Mth.absMax(axisalignedbb.getXsize(), axisalignedbb.getZsize()), 1.0);
        return this.getDistanceToBorder(entity) < d0 * 2.0 && this.isWithinBounds(entity.getX(), entity.getZ(), d0);
    }

    public BorderStatus getStatus() {
        return this.extent.getStatus();
    }

    public double getMinX() {
        return this.extent.getMinX();
    }

    public double getMinZ() {
        return this.extent.getMinZ();
    }

    public double getMaxX() {
        return this.extent.getMaxX();
    }

    public double getMaxZ() {
        return this.extent.getMaxZ();
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterZ() {
        return this.centerZ;
    }

    public void setCenter(double d0, double d1) {
        this.centerX = d0;
        this.centerZ = d1;
        this.extent.onCenterChange();
        this.setDirty();
        for (BorderChangeListener iworldborderlistener : this.getListeners()) {
            iworldborderlistener.onSetCenter(this, d0, d1);
        }
    }

    public double getSize() {
        return this.extent.getSize();
    }

    public long getLerpTime() {
        return this.extent.getLerpTime();
    }

    public double getLerpTarget() {
        return this.extent.getLerpTarget();
    }

    public void setSize(double d0) {
        this.extent = new StaticBorderExtent(d0);
        this.setDirty();
        for (BorderChangeListener iworldborderlistener : this.getListeners()) {
            iworldborderlistener.onSetSize(this, d0);
        }
    }

    public void lerpSizeBetween(double d0, double d1, long i) {
        this.extent = d0 == d1 ? new StaticBorderExtent(d1) : new MovingBorderExtent(d0, d1, i);
        this.setDirty();
        for (BorderChangeListener iworldborderlistener : this.getListeners()) {
            iworldborderlistener.onLerpSize(this, d0, d1, i);
        }
    }

    protected List<BorderChangeListener> getListeners() {
        return Lists.newArrayList(this.listeners);
    }

    public void addListener(BorderChangeListener iworldborderlistener) {
        if (this.listeners.contains(iworldborderlistener)) {
            return;
        }
        this.listeners.add(iworldborderlistener);
    }

    public void removeListener(BorderChangeListener iworldborderlistener) {
        this.listeners.remove(iworldborderlistener);
    }

    public void setAbsoluteMaxSize(int i) {
        this.absoluteMaxSize = i;
        this.extent.onAbsoluteMaxSizeChange();
    }

    public int getAbsoluteMaxSize() {
        return this.absoluteMaxSize;
    }

    public double getSafeZone() {
        return this.safeZone;
    }

    public void setSafeZone(double d0) {
        this.safeZone = d0;
        this.setDirty();
        for (BorderChangeListener iworldborderlistener : this.getListeners()) {
            iworldborderlistener.onSetSafeZone(this, d0);
        }
    }

    public double getDamagePerBlock() {
        return this.damagePerBlock;
    }

    public void setDamagePerBlock(double d0) {
        this.damagePerBlock = d0;
        this.setDirty();
        for (BorderChangeListener iworldborderlistener : this.getListeners()) {
            iworldborderlistener.onSetDamagePerBlock(this, d0);
        }
    }

    public double getLerpSpeed() {
        return this.extent.getLerpSpeed();
    }

    public int getWarningTime() {
        return this.warningTime;
    }

    public void setWarningTime(int i) {
        this.warningTime = i;
        this.setDirty();
        for (BorderChangeListener iworldborderlistener : this.getListeners()) {
            iworldborderlistener.onSetWarningTime(this, i);
        }
    }

    public int getWarningBlocks() {
        return this.warningBlocks;
    }

    public void setWarningBlocks(int i) {
        this.warningBlocks = i;
        this.setDirty();
        for (BorderChangeListener iworldborderlistener : this.getListeners()) {
            iworldborderlistener.onSetWarningBlocks(this, i);
        }
    }

    public void tick() {
        this.extent = this.extent.update();
    }

    public void applySettings(Settings worldborder_c) {
        this.setCenter(worldborder_c.centerX(), worldborder_c.centerZ());
        this.setDamagePerBlock(worldborder_c.damagePerBlock());
        this.setSafeZone(worldborder_c.safeZone());
        this.setWarningBlocks(worldborder_c.warningBlocks());
        this.setWarningTime(worldborder_c.warningTime());
        if (worldborder_c.lerpTime() > 0L) {
            this.lerpSizeBetween(worldborder_c.size(), worldborder_c.lerpTarget(), worldborder_c.lerpTime());
        } else {
            this.setSize(worldborder_c.size());
        }
    }

    private class StaticBorderExtent
    implements BorderExtent {
        private final double size;
        private double minX;
        private double minZ;
        private double maxX;
        private double maxZ;
        private VoxelShape shape;

        public StaticBorderExtent(double d0) {
            this.size = d0;
            this.updateBox();
        }

        @Override
        public double getMinX() {
            return this.minX;
        }

        @Override
        public double getMaxX() {
            return this.maxX;
        }

        @Override
        public double getMinZ() {
            return this.minZ;
        }

        @Override
        public double getMaxZ() {
            return this.maxZ;
        }

        @Override
        public double getSize() {
            return this.size;
        }

        @Override
        public BorderStatus getStatus() {
            return BorderStatus.STATIONARY;
        }

        @Override
        public double getLerpSpeed() {
            return 0.0;
        }

        @Override
        public long getLerpTime() {
            return 0L;
        }

        @Override
        public double getLerpTarget() {
            return this.size;
        }

        private void updateBox() {
            this.minX = Mth.clamp(WorldBorder.this.getCenterX() - this.size / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
            this.minZ = Mth.clamp(WorldBorder.this.getCenterZ() - this.size / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
            this.maxX = Mth.clamp(WorldBorder.this.getCenterX() + this.size / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
            this.maxZ = Mth.clamp(WorldBorder.this.getCenterZ() + this.size / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
            this.shape = Shapes.join(Shapes.INFINITY, Shapes.box(Math.floor(this.getMinX()), Double.NEGATIVE_INFINITY, Math.floor(this.getMinZ()), Math.ceil(this.getMaxX()), Double.POSITIVE_INFINITY, Math.ceil(this.getMaxZ())), BooleanOp.ONLY_FIRST);
        }

        @Override
        public void onAbsoluteMaxSizeChange() {
            this.updateBox();
        }

        @Override
        public void onCenterChange() {
            this.updateBox();
        }

        @Override
        public BorderExtent update() {
            return this;
        }

        @Override
        public VoxelShape getCollisionShape() {
            return this.shape;
        }
    }

    private static interface BorderExtent {
        public double getMinX();

        public double getMaxX();

        public double getMinZ();

        public double getMaxZ();

        public double getSize();

        public double getLerpSpeed();

        public long getLerpTime();

        public double getLerpTarget();

        public BorderStatus getStatus();

        public void onAbsoluteMaxSizeChange();

        public void onCenterChange();

        public BorderExtent update();

        public VoxelShape getCollisionShape();
    }

    private class MovingBorderExtent
    implements BorderExtent {
        private final double from;
        private final double to;
        private final long lerpEnd;
        private final long lerpBegin;
        private final double lerpDuration;

        MovingBorderExtent(double d0, double d1, long i) {
            this.from = d0;
            this.to = d1;
            this.lerpDuration = i;
            this.lerpBegin = Util.getMillis();
            this.lerpEnd = this.lerpBegin + i;
        }

        @Override
        public double getMinX() {
            return Mth.clamp(WorldBorder.this.getCenterX() - this.getSize() / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
        }

        @Override
        public double getMinZ() {
            return Mth.clamp(WorldBorder.this.getCenterZ() - this.getSize() / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
        }

        @Override
        public double getMaxX() {
            return Mth.clamp(WorldBorder.this.getCenterX() + this.getSize() / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
        }

        @Override
        public double getMaxZ() {
            return Mth.clamp(WorldBorder.this.getCenterZ() + this.getSize() / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
        }

        @Override
        public double getSize() {
            double d0 = (double)(Util.getMillis() - this.lerpBegin) / this.lerpDuration;
            return d0 < 1.0 ? Mth.lerp(d0, this.from, this.to) : this.to;
        }

        @Override
        public double getLerpSpeed() {
            return Math.abs(this.from - this.to) / (double)(this.lerpEnd - this.lerpBegin);
        }

        @Override
        public long getLerpTime() {
            return this.lerpEnd - Util.getMillis();
        }

        @Override
        public double getLerpTarget() {
            return this.to;
        }

        @Override
        public BorderStatus getStatus() {
            return this.to < this.from ? BorderStatus.SHRINKING : BorderStatus.GROWING;
        }

        @Override
        public void onCenterChange() {
        }

        @Override
        public void onAbsoluteMaxSizeChange() {
        }

        @Override
        public BorderExtent update() {
            if (this.getLerpTime() <= 0L) {
                WorldBorder.this.setDirty();
                WorldBorder worldBorder = WorldBorder.this;
                Objects.requireNonNull(worldBorder);
                return worldBorder.new StaticBorderExtent(this.to);
            }
            return this;
        }

        @Override
        public VoxelShape getCollisionShape() {
            return Shapes.join(Shapes.INFINITY, Shapes.box(Math.floor(this.getMinX()), Double.NEGATIVE_INFINITY, Math.floor(this.getMinZ()), Math.ceil(this.getMaxX()), Double.POSITIVE_INFINITY, Math.ceil(this.getMaxZ())), BooleanOp.ONLY_FIRST);
        }
    }

    public record Settings(double centerX, double centerZ, double damagePerBlock, double safeZone, int warningBlocks, int warningTime, double size, long lerpTime, double lerpTarget) {
        public static final Settings DEFAULT = new Settings(0.0, 0.0, 0.2, 5.0, 5, 15, 5.9999968E7, 0L, 0.0);
        public static final Codec<Settings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.doubleRange((double)-2.9999984E7, (double)2.9999984E7).fieldOf("center_x").forGetter(Settings::centerX), (App)Codec.doubleRange((double)-2.9999984E7, (double)2.9999984E7).fieldOf("center_z").forGetter(Settings::centerZ), (App)Codec.DOUBLE.fieldOf("damage_per_block").forGetter(Settings::damagePerBlock), (App)Codec.DOUBLE.fieldOf("safe_zone").forGetter(Settings::safeZone), (App)Codec.INT.fieldOf("warning_blocks").forGetter(Settings::warningBlocks), (App)Codec.INT.fieldOf("warning_time").forGetter(Settings::warningTime), (App)Codec.DOUBLE.fieldOf("size").forGetter(Settings::size), (App)Codec.LONG.fieldOf("lerp_time").forGetter(Settings::lerpTime), (App)Codec.DOUBLE.fieldOf("lerp_target").forGetter(Settings::lerpTarget)).apply((Applicative)instance, Settings::new));

        public Settings(WorldBorder worldborder) {
            this(worldborder.centerX, worldborder.centerZ, worldborder.damagePerBlock, worldborder.safeZone, worldborder.warningBlocks, worldborder.warningTime, worldborder.extent.getSize(), worldborder.extent.getLerpTime(), worldborder.extent.getLerpTarget());
        }

        public WorldBorder toWorldBorder() {
            WorldBorder worldborder = new WorldBorder();
            worldborder.applySettings(this);
            return worldborder;
        }
    }
}

