/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.status;

import com.mojang.logging.LogUtils;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.StaticCache2D;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.slf4j.Logger;

public class ChunkStatusTasks {
    private static final Logger LOGGER = LogUtils.getLogger();

    private static boolean isLighted(ChunkAccess ichunkaccess) {
        return ichunkaccess.getPersistedStatus().isOrAfter(ChunkStatus.LIGHT) && ichunkaccess.isLightCorrect();
    }

    static CompletableFuture<ChunkAccess> passThrough(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, ChunkAccess ichunkaccess) {
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<ChunkAccess> generateStructureStarts(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, ChunkAccess ichunkaccess) {
        ServerLevel worldserver = worldgencontext.level();
        if (worldserver.J.worldGenOptions().generateStructures()) {
            worldgencontext.generator().createStructures(worldserver.registryAccess(), worldserver.getChunkSource().getGeneratorState(), worldserver.structureManager(), ichunkaccess, worldgencontext.structureManager(), worldserver.dimension());
        }
        worldserver.onStructureStartsAvailable(ichunkaccess);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<ChunkAccess> loadStructureStarts(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, ChunkAccess ichunkaccess) {
        worldgencontext.level().onStructureStartsAvailable(ichunkaccess);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<ChunkAccess> generateStructureReferences(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, ChunkAccess ichunkaccess) {
        ServerLevel worldserver = worldgencontext.level();
        WorldGenRegion regionlimitedworldaccess = new WorldGenRegion(worldserver, staticcache2d, chunkstep, ichunkaccess);
        worldgencontext.generator().createReferences(regionlimitedworldaccess, worldserver.structureManager().forWorldGenRegion(regionlimitedworldaccess), ichunkaccess);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<ChunkAccess> generateBiomes(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, ChunkAccess ichunkaccess) {
        ServerLevel worldserver = worldgencontext.level();
        WorldGenRegion regionlimitedworldaccess = new WorldGenRegion(worldserver, staticcache2d, chunkstep, ichunkaccess);
        return worldgencontext.generator().createBiomes(worldserver.getChunkSource().randomState(), Blender.of(regionlimitedworldaccess), worldserver.structureManager().forWorldGenRegion(regionlimitedworldaccess), ichunkaccess);
    }

    static CompletableFuture<ChunkAccess> generateNoise(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, ChunkAccess ichunkaccess) {
        ServerLevel worldserver = worldgencontext.level();
        WorldGenRegion regionlimitedworldaccess = new WorldGenRegion(worldserver, staticcache2d, chunkstep, ichunkaccess);
        return worldgencontext.generator().fillFromNoise(Blender.of(regionlimitedworldaccess), worldserver.getChunkSource().randomState(), worldserver.structureManager().forWorldGenRegion(regionlimitedworldaccess), ichunkaccess).thenApply(ichunkaccess1 -> {
            ProtoChunk protochunk;
            BelowZeroRetrogen belowzeroretrogen;
            if (ichunkaccess1 instanceof ProtoChunk && (belowzeroretrogen = (protochunk = (ProtoChunk)ichunkaccess1).getBelowZeroRetrogen()) != null) {
                BelowZeroRetrogen.replaceOldBedrock(protochunk);
                if (belowzeroretrogen.hasBedrockHoles()) {
                    belowzeroretrogen.applyBedrockMask(protochunk);
                }
            }
            return ichunkaccess1;
        });
    }

    static CompletableFuture<ChunkAccess> generateSurface(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, ChunkAccess ichunkaccess) {
        ServerLevel worldserver = worldgencontext.level();
        WorldGenRegion regionlimitedworldaccess = new WorldGenRegion(worldserver, staticcache2d, chunkstep, ichunkaccess);
        worldgencontext.generator().buildSurface(regionlimitedworldaccess, worldserver.structureManager().forWorldGenRegion(regionlimitedworldaccess), worldserver.getChunkSource().randomState(), ichunkaccess);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<ChunkAccess> generateCarvers(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, ChunkAccess ichunkaccess) {
        ServerLevel worldserver = worldgencontext.level();
        WorldGenRegion regionlimitedworldaccess = new WorldGenRegion(worldserver, staticcache2d, chunkstep, ichunkaccess);
        if (ichunkaccess instanceof ProtoChunk) {
            ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
            Blender.addAroundOldChunksCarvingMaskFilter(regionlimitedworldaccess, protochunk);
        }
        worldgencontext.generator().applyCarvers(regionlimitedworldaccess, worldserver.getSeed(), worldserver.getChunkSource().randomState(), worldserver.getBiomeManager(), worldserver.structureManager().forWorldGenRegion(regionlimitedworldaccess), ichunkaccess);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<ChunkAccess> generateFeatures(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, ChunkAccess ichunkaccess) {
        ServerLevel worldserver = worldgencontext.level();
        Heightmap.primeHeightmaps(ichunkaccess, EnumSet.of(Heightmap.Types.MOTION_BLOCKING, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Heightmap.Types.OCEAN_FLOOR, Heightmap.Types.WORLD_SURFACE));
        WorldGenRegion regionlimitedworldaccess = new WorldGenRegion(worldserver, staticcache2d, chunkstep, ichunkaccess);
        if (!SharedConstants.DEBUG_DISABLE_FEATURES) {
            worldgencontext.generator().applyBiomeDecoration(regionlimitedworldaccess, ichunkaccess, worldserver.structureManager().forWorldGenRegion(regionlimitedworldaccess));
        }
        Blender.generateBorderTicks(regionlimitedworldaccess, ichunkaccess);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<ChunkAccess> initializeLight(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, ChunkAccess ichunkaccess) {
        ThreadedLevelLightEngine lightenginethreaded = worldgencontext.lightEngine();
        ichunkaccess.initializeLightSources();
        ((ProtoChunk)ichunkaccess).setLightEngine(lightenginethreaded);
        boolean flag = ChunkStatusTasks.isLighted(ichunkaccess);
        return lightenginethreaded.initializeLight(ichunkaccess, flag);
    }

    static CompletableFuture<ChunkAccess> light(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, ChunkAccess ichunkaccess) {
        boolean flag = ChunkStatusTasks.isLighted(ichunkaccess);
        return worldgencontext.lightEngine().lightChunk(ichunkaccess, flag);
    }

    static CompletableFuture<ChunkAccess> generateSpawn(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, ChunkAccess ichunkaccess) {
        if (!ichunkaccess.isUpgrading()) {
            worldgencontext.generator().spawnOriginalMobs(new WorldGenRegion(worldgencontext.level(), staticcache2d, chunkstep, ichunkaccess));
        }
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<ChunkAccess> full(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, ChunkAccess ichunkaccess) {
        ChunkPos chunkcoordintpair = ichunkaccess.getPos();
        GenerationChunkHolder generationchunkholder = staticcache2d.get(chunkcoordintpair.x, chunkcoordintpair.z);
        return CompletableFuture.supplyAsync(() -> {
            LevelChunk chunk;
            ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
            ServerLevel worldserver = worldgencontext.level();
            if (protochunk instanceof ImposterProtoChunk) {
                ImposterProtoChunk protochunkextension = (ImposterProtoChunk)protochunk;
                chunk = protochunkextension.getWrapped();
            } else {
                chunk = new LevelChunk(worldserver, protochunk, chunk1 -> {
                    try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(ichunkaccess.problemPath(), LOGGER);){
                        ChunkStatusTasks.postLoadProtoChunk(worldserver, TagValueInput.create((ProblemReporter)problemreporter_j, (HolderLookup.Provider)worldserver.registryAccess(), protochunk.getEntities()));
                    }
                });
                generationchunkholder.replaceProtoChunk(new ImposterProtoChunk(chunk, false));
            }
            Objects.requireNonNull(generationchunkholder);
            chunk.setFullStatus(generationchunkholder::getFullStatus);
            chunk.runPostLoad();
            chunk.setLoaded(true);
            chunk.registerAllBlockEntitiesAfterLevelLoad();
            chunk.registerTickContainerInLevel(worldserver);
            chunk.setUnsavedListener(worldgencontext.unsavedListener());
            return chunk;
        }, worldgencontext.mainThreadExecutor());
    }

    private static void postLoadProtoChunk(ServerLevel worldserver, ValueInput.ValueInputList valueinput_b) {
        if (!valueinput_b.isEmpty()) {
            worldserver.addWorldGenChunkEntities(EntityType.loadEntitiesRecursive(valueinput_b, worldserver, EntitySpawnReason.LOAD));
        }
    }
}

