/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import net.minecraft.util.FastBufferedInputStream;
import org.slf4j.Logger;

public class RegionFileVersion {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Int2ObjectMap<RegionFileVersion> VERSIONS = new Int2ObjectOpenHashMap();
    private static final Object2ObjectMap<String, RegionFileVersion> VERSIONS_BY_NAME = new Object2ObjectOpenHashMap();
    public static final RegionFileVersion VERSION_GZIP = RegionFileVersion.register(new RegionFileVersion(1, null, var0 -> new FastBufferedInputStream(new GZIPInputStream((InputStream)var0)), var0 -> new BufferedOutputStream(new GZIPOutputStream((OutputStream)var0))));
    public static final RegionFileVersion VERSION_DEFLATE = RegionFileVersion.register(new RegionFileVersion(2, "deflate", var0 -> new FastBufferedInputStream(new InflaterInputStream((InputStream)var0)), var0 -> new BufferedOutputStream(new DeflaterOutputStream((OutputStream)var0))));
    public static final RegionFileVersion VERSION_NONE = RegionFileVersion.register(new RegionFileVersion(3, "none", FastBufferedInputStream::new, BufferedOutputStream::new));
    public static final RegionFileVersion VERSION_LZ4 = RegionFileVersion.register(new RegionFileVersion(4, "lz4", var0 -> new FastBufferedInputStream((InputStream)new LZ4BlockInputStream(var0)), var0 -> new BufferedOutputStream((OutputStream)new LZ4BlockOutputStream(var0))));
    public static final RegionFileVersion VERSION_CUSTOM = RegionFileVersion.register(new RegionFileVersion(127, null, var0 -> {
        throw new UnsupportedOperationException();
    }, var0 -> {
        throw new UnsupportedOperationException();
    }));
    public static final RegionFileVersion DEFAULT;
    private static volatile RegionFileVersion selected;
    private final int id;
    @Nullable
    private final String optionName;
    private final StreamWrapper<InputStream> inputWrapper;
    private final StreamWrapper<OutputStream> outputWrapper;

    private RegionFileVersion(int var0, @Nullable String var1, StreamWrapper<InputStream> var2, StreamWrapper<OutputStream> var3) {
        this.id = var0;
        this.optionName = var1;
        this.inputWrapper = var2;
        this.outputWrapper = var3;
    }

    private static RegionFileVersion register(RegionFileVersion var0) {
        VERSIONS.put(var0.id, (Object)var0);
        if (var0.optionName != null) {
            VERSIONS_BY_NAME.put((Object)var0.optionName, (Object)var0);
        }
        return var0;
    }

    @Nullable
    public static RegionFileVersion fromId(int var0) {
        return (RegionFileVersion)VERSIONS.get(var0);
    }

    public static void configure(String var0) {
        RegionFileVersion var1 = (RegionFileVersion)VERSIONS_BY_NAME.get((Object)var0);
        if (var1 != null) {
            selected = var1;
        } else {
            LOGGER.error("Invalid `region-file-compression` value `{}` in server.properties. Please use one of: {}", (Object)var0, (Object)String.join((CharSequence)", ", (Iterable<? extends CharSequence>)VERSIONS_BY_NAME.keySet()));
        }
    }

    public static RegionFileVersion getSelected() {
        return selected;
    }

    public static boolean isValidVersion(int var0) {
        return VERSIONS.containsKey(var0);
    }

    public int getId() {
        return this.id;
    }

    public OutputStream wrap(OutputStream var0) throws IOException {
        return this.outputWrapper.wrap(var0);
    }

    public InputStream wrap(InputStream var0) throws IOException {
        return this.inputWrapper.wrap(var0);
    }

    static {
        selected = DEFAULT = VERSION_DEFLATE;
    }

    @FunctionalInterface
    static interface StreamWrapper<O> {
        public O wrap(O var1) throws IOException;
    }
}

