/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.slf4j.Logger;

public class SectionStorage<R, P>
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final String SECTIONS_TAG = "Sections";
    private final SimpleRegionStorage simpleRegionStorage;
    private final Long2ObjectMap<Optional<R>> storage = new Long2ObjectOpenHashMap();
    private final LongLinkedOpenHashSet dirtyChunks = new LongLinkedOpenHashSet();
    private final Codec<P> codec;
    private final Function<R, P> packer;
    private final BiFunction<P, Runnable, R> unpacker;
    private final Function<Runnable, R> factory;
    private final RegistryAccess registryAccess;
    private final ChunkIOErrorReporter errorReporter;
    protected final LevelHeightAccessor levelHeightAccessor;
    private final LongSet loadedChunks = new LongOpenHashSet();
    private final Long2ObjectMap<CompletableFuture<Optional<PackedChunk<P>>>> pendingLoads = new Long2ObjectOpenHashMap();
    private final Object loadLock = new Object();

    public SectionStorage(SimpleRegionStorage var0, Codec<P> var1, Function<R, P> var2, BiFunction<P, Runnable, R> var3, Function<Runnable, R> var4, RegistryAccess var5, ChunkIOErrorReporter var6, LevelHeightAccessor var7) {
        this.simpleRegionStorage = var0;
        this.codec = var1;
        this.packer = var2;
        this.unpacker = var3;
        this.factory = var4;
        this.registryAccess = var5;
        this.errorReporter = var6;
        this.levelHeightAccessor = var7;
    }

    protected void tick(BooleanSupplier var0) {
        LongListIterator var1 = this.dirtyChunks.iterator();
        while (var1.hasNext() && var0.getAsBoolean()) {
            ChunkPos var2 = new ChunkPos(var1.nextLong());
            var1.remove();
            this.writeChunk(var2);
        }
        this.unpackPendingLoads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackPendingLoads() {
        Object object = this.loadLock;
        synchronized (object) {
            ObjectIterator var1 = Long2ObjectMaps.fastIterator(this.pendingLoads);
            while (var1.hasNext()) {
                Long2ObjectMap.Entry var2 = (Long2ObjectMap.Entry)var1.next();
                Optional var3 = ((CompletableFuture)var2.getValue()).getNow(null);
                if (var3 == null) continue;
                long var4 = var2.getLongKey();
                this.unpackChunk(new ChunkPos(var4), var3.orElse(null));
                var1.remove();
                this.loadedChunks.add(var4);
            }
        }
    }

    public void flushAll() {
        if (!this.dirtyChunks.isEmpty()) {
            this.dirtyChunks.forEach(var0 -> this.writeChunk(new ChunkPos(var0)));
            this.dirtyChunks.clear();
        }
    }

    public boolean hasWork() {
        return !this.dirtyChunks.isEmpty();
    }

    @Nullable
    protected Optional<R> get(long var0) {
        return (Optional)this.storage.get(var0);
    }

    protected Optional<R> getOrLoad(long var0) {
        if (this.outsideStoredRange(var0)) {
            return Optional.empty();
        }
        Optional<R> var2 = this.get(var0);
        if (var2 != null) {
            return var2;
        }
        this.unpackChunk(SectionPos.of(var0).chunk());
        var2 = this.get(var0);
        if (var2 == null) {
            throw Util.pauseInIde(new IllegalStateException());
        }
        return var2;
    }

    protected boolean outsideStoredRange(long var0) {
        int var2 = SectionPos.sectionToBlockCoord(SectionPos.y(var0));
        return this.levelHeightAccessor.isOutsideBuildHeight(var2);
    }

    protected R getOrCreate(long var0) {
        if (this.outsideStoredRange(var0)) {
            throw Util.pauseInIde(new IllegalArgumentException("sectionPos out of bounds"));
        }
        Optional<R> var2 = this.getOrLoad(var0);
        if (var2.isPresent()) {
            return var2.get();
        }
        R var3 = this.factory.apply(() -> this.setDirty(var0));
        this.storage.put(var0, Optional.of(var3));
        return var3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> prefetch(ChunkPos var0) {
        Object object = this.loadLock;
        synchronized (object) {
            long var2 = var0.toLong();
            if (this.loadedChunks.contains(var2)) {
                return CompletableFuture.completedFuture(null);
            }
            return (CompletableFuture)this.pendingLoads.computeIfAbsent(var2, var1 -> this.tryRead(var0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackChunk(ChunkPos var0) {
        CompletableFuture var3;
        long var12 = var0.toLong();
        Object object = this.loadLock;
        synchronized (object) {
            if (!this.loadedChunks.add(var12)) {
                return;
            }
            var3 = (CompletableFuture)this.pendingLoads.computeIfAbsent(var12, var1 -> this.tryRead(var0));
        }
        this.unpackChunk(var0, ((Optional)var3.join()).orElse(null));
        object = this.loadLock;
        synchronized (object) {
            this.pendingLoads.remove(var12);
        }
    }

    private CompletableFuture<Optional<PackedChunk<P>>> tryRead(ChunkPos var0) {
        RegistryOps<Tag> var13 = this.registryAccess.createSerializationContext(NbtOps.INSTANCE);
        return ((CompletableFuture)this.simpleRegionStorage.read(var0).thenApplyAsync(var12 -> var12.map(var1 -> PackedChunk.parse(this.codec, var13, var1, this.simpleRegionStorage, this.levelHeightAccessor)), Util.backgroundExecutor().forName("parseSection"))).exceptionally(var1 -> {
            if (var1 instanceof CompletionException) {
                var1 = var1.getCause();
            }
            if (var1 instanceof IOException) {
                IOException var2 = (IOException)var1;
                LOGGER.error("Error reading chunk {} data from disk", (Object)var0, (Object)var2);
                this.errorReporter.reportChunkLoadFailure(var2, this.simpleRegionStorage.storageInfo(), var0);
                return Optional.empty();
            }
            throw new CompletionException((Throwable)var1);
        });
    }

    private void unpackChunk(ChunkPos var0, @Nullable PackedChunk<P> var1) {
        if (var1 == null) {
            for (int var22 = this.levelHeightAccessor.getMinSectionY(); var22 <= this.levelHeightAccessor.getMaxSectionY(); ++var22) {
                this.storage.put(SectionStorage.getKey(var0, var22), Optional.empty());
            }
        } else {
            boolean var23 = var1.versionChanged();
            for (int var32 = this.levelHeightAccessor.getMinSectionY(); var32 <= this.levelHeightAccessor.getMaxSectionY(); ++var32) {
                long var4 = SectionStorage.getKey(var0, var32);
                Optional<Object> var6 = Optional.ofNullable(var1.sectionsByY.get(var32)).map(var2 -> this.unpacker.apply(var2, () -> this.setDirty(var4)));
                this.storage.put(var4, var6);
                var6.ifPresent(var3 -> {
                    this.onSectionLoad(var4);
                    if (var23) {
                        this.setDirty(var4);
                    }
                });
            }
        }
    }

    private void writeChunk(ChunkPos var0) {
        RegistryOps<Tag> var12 = this.registryAccess.createSerializationContext(NbtOps.INSTANCE);
        Dynamic<Tag> var2 = this.writeChunk(var0, var12);
        Tag var3 = (Tag)var2.getValue();
        if (var3 instanceof CompoundTag) {
            this.simpleRegionStorage.write(var0, (CompoundTag)var3).exceptionally(var1 -> {
                this.errorReporter.reportChunkSaveFailure((Throwable)var1, this.simpleRegionStorage.storageInfo(), var0);
                return null;
            });
        } else {
            LOGGER.error("Expected compound tag, got {}", (Object)var3);
        }
    }

    private <T> Dynamic<T> writeChunk(ChunkPos var0, DynamicOps<T> var1) {
        HashMap var2 = Maps.newHashMap();
        for (int var32 = this.levelHeightAccessor.getMinSectionY(); var32 <= this.levelHeightAccessor.getMaxSectionY(); ++var32) {
            long var4 = SectionStorage.getKey(var0, var32);
            Optional var6 = (Optional)this.storage.get(var4);
            if (var6 == null || var6.isEmpty()) continue;
            DataResult var7 = this.codec.encodeStart(var1, this.packer.apply(var6.get()));
            String var8 = Integer.toString(var32);
            var7.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var3 -> var2.put(var1.createString(var8), var3));
        }
        return new Dynamic(var1, var1.createMap((Map)ImmutableMap.of((Object)var1.createString(SECTIONS_TAG), (Object)var1.createMap((Map)var2), (Object)var1.createString("DataVersion"), (Object)var1.createInt(SharedConstants.getCurrentVersion().dataVersion().version()))));
    }

    private static long getKey(ChunkPos var0, int var1) {
        return SectionPos.asLong(var0.x, var1, var0.z);
    }

    protected void onSectionLoad(long var0) {
    }

    protected void setDirty(long var0) {
        Optional var2 = (Optional)this.storage.get(var0);
        if (var2 == null || var2.isEmpty()) {
            LOGGER.warn("No data for position: {}", (Object)SectionPos.of(var0));
            return;
        }
        this.dirtyChunks.add(ChunkPos.asLong(SectionPos.x(var0), SectionPos.z(var0)));
    }

    public void flush(ChunkPos var0) {
        if (this.dirtyChunks.remove(var0.toLong())) {
            this.writeChunk(var0);
        }
    }

    @Override
    public void close() throws IOException {
        this.simpleRegionStorage.close();
    }

    static final class PackedChunk<T>
    extends Record {
        final Int2ObjectMap<T> sectionsByY;
        private final boolean versionChanged;

        private PackedChunk(Int2ObjectMap<T> var0, boolean var1) {
            this.sectionsByY = var0;
            this.versionChanged = var1;
        }

        public static <T> PackedChunk<T> parse(Codec<T> var0, DynamicOps<Tag> var12, Tag var2, SimpleRegionStorage var3, LevelHeightAccessor var4) {
            Dynamic var5 = new Dynamic(var12, (Object)var2);
            Dynamic<Tag> var6 = var3.upgradeChunkTag((Dynamic<Tag>)var5, 1945);
            boolean var7 = var5 != var6;
            OptionalDynamic var8 = var6.get(SectionStorage.SECTIONS_TAG);
            Int2ObjectOpenHashMap var9 = new Int2ObjectOpenHashMap();
            for (int var10 = var4.getMinSectionY(); var10 <= var4.getMaxSectionY(); ++var10) {
                Optional var11 = var8.get(Integer.toString(var10)).result().flatMap(var1 -> var0.parse(var1).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)));
                if (!var11.isPresent()) continue;
                var9.put(var10, var11.get());
            }
            return new PackedChunk<T>(var9, var7);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PackedChunk.class, "sectionsByY;versionChanged", "sectionsByY", "versionChanged"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PackedChunk.class, "sectionsByY;versionChanged", "sectionsByY", "versionChanged"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PackedChunk.class, "sectionsByY;versionChanged", "sectionsByY", "versionChanged"}, this, var0);
        }

        public Int2ObjectMap<T> sectionsByY() {
            return this.sectionsByY;
        }

        public boolean versionChanged() {
            return this.versionChanged;
        }
    }
}

