/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.debug.DebugGameEventListenerInfo;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;

public class EuclideanGameEventListenerRegistry
implements GameEventListenerRegistry {
    private final List<GameEventListener> listeners = Lists.newArrayList();
    private final Set<GameEventListener> listenersToRemove = Sets.newHashSet();
    private final List<GameEventListener> listenersToAdd = Lists.newArrayList();
    private boolean processing;
    private final ServerLevel level;
    private final int sectionY;
    private final OnEmptyAction onEmptyAction;

    public EuclideanGameEventListenerRegistry(ServerLevel var0, int var1, OnEmptyAction var2) {
        this.level = var0;
        this.sectionY = var1;
        this.onEmptyAction = var2;
    }

    @Override
    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    @Override
    public void register(GameEventListener var0) {
        if (this.processing) {
            this.listenersToAdd.add(var0);
        } else {
            this.listeners.add(var0);
        }
        EuclideanGameEventListenerRegistry.sendDebugInfo(this.level, var0);
    }

    private static void sendDebugInfo(ServerLevel var0, GameEventListener var1) {
        EntityPositionSource var5;
        Entity var6;
        if (!var0.debugSynchronizers().hasAnySubscriberFor(DebugSubscriptions.GAME_EVENT_LISTENERS)) {
            return;
        }
        DebugGameEventListenerInfo var2 = new DebugGameEventListenerInfo(var1.getListenerRadius());
        PositionSource var3 = var1.getListenerSource();
        if (var3 instanceof BlockPositionSource) {
            BlockPositionSource var4 = (BlockPositionSource)var3;
            var0.debugSynchronizers().sendBlockValue(var4.pos(), DebugSubscriptions.GAME_EVENT_LISTENERS, var2);
        } else if (var3 instanceof EntityPositionSource && (var6 = var0.getEntity((var5 = (EntityPositionSource)var3).getUuid())) != null) {
            var0.debugSynchronizers().sendEntityValue(var6, DebugSubscriptions.GAME_EVENT_LISTENERS, var2);
        }
    }

    @Override
    public void unregister(GameEventListener var0) {
        if (this.processing) {
            this.listenersToRemove.add(var0);
        } else {
            this.listeners.remove(var0);
        }
        if (this.listeners.isEmpty()) {
            this.onEmptyAction.apply(this.sectionY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visitInRangeListeners(Holder<GameEvent> var0, Vec3 var1, GameEvent.Context var2, GameEventListenerRegistry.ListenerVisitor var3) {
        this.processing = true;
        boolean var4 = false;
        try {
            Iterator<GameEventListener> var5 = this.listeners.iterator();
            while (var5.hasNext()) {
                GameEventListener var6 = var5.next();
                if (this.listenersToRemove.remove(var6)) {
                    var5.remove();
                    continue;
                }
                Optional<Vec3> var7 = EuclideanGameEventListenerRegistry.getPostableListenerPosition(this.level, var1, var6);
                if (!var7.isPresent()) continue;
                var3.visit(var6, var7.get());
                var4 = true;
            }
        }
        finally {
            this.processing = false;
        }
        if (!this.listenersToAdd.isEmpty()) {
            this.listeners.addAll(this.listenersToAdd);
            this.listenersToAdd.clear();
        }
        if (!this.listenersToRemove.isEmpty()) {
            this.listeners.removeAll(this.listenersToRemove);
            this.listenersToRemove.clear();
        }
        return var4;
    }

    private static Optional<Vec3> getPostableListenerPosition(ServerLevel var0, Vec3 var1, GameEventListener var2) {
        int var6;
        Optional<Vec3> var3 = var2.getListenerSource().getPosition(var0);
        if (var3.isEmpty()) {
            return Optional.empty();
        }
        double var4 = BlockPos.containing(var3.get()).distSqr(BlockPos.containing(var1));
        if (var4 > (double)(var6 = var2.getListenerRadius() * var2.getListenerRadius())) {
            return Optional.empty();
        }
        return var3;
    }

    @FunctionalInterface
    public static interface OnEmptyAction {
        public void apply(int var1);
    }
}

