/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.storage.PrimaryLevelData;

public record WorldDimensions(Map<ResourceKey<LevelStem>, LevelStem> dimensions) {
    public static final MapCodec<WorldDimensions> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.unboundedMap(ResourceKey.codec(Registries.LEVEL_STEM), LevelStem.CODEC).fieldOf("dimensions").forGetter(WorldDimensions::dimensions)).apply((Applicative)var0, var0.stable(WorldDimensions::new)));
    private static final Set<ResourceKey<LevelStem>> BUILTIN_ORDER = ImmutableSet.of(LevelStem.OVERWORLD, LevelStem.NETHER, LevelStem.END);
    private static final int VANILLA_DIMENSION_COUNT = BUILTIN_ORDER.size();

    public WorldDimensions {
        LevelStem var1 = var0.get(LevelStem.OVERWORLD);
        if (var1 == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
    }

    public WorldDimensions(Registry<LevelStem> var0) {
        this(var0.listElements().collect(Collectors.toMap(Holder.Reference::key, Holder.Reference::value)));
    }

    public static Stream<ResourceKey<LevelStem>> keysInOrder(Stream<ResourceKey<LevelStem>> var02) {
        return Stream.concat(BUILTIN_ORDER.stream(), var02.filter(var0 -> !BUILTIN_ORDER.contains(var0)));
    }

    public WorldDimensions replaceOverworldGenerator(HolderLookup.Provider var0, ChunkGenerator var1) {
        HolderGetter var2 = var0.lookupOrThrow(Registries.DIMENSION_TYPE);
        Map<ResourceKey<LevelStem>, LevelStem> var3 = WorldDimensions.withOverworld((HolderLookup<DimensionType>)var2, this.dimensions, var1);
        return new WorldDimensions(var3);
    }

    public static Map<ResourceKey<LevelStem>, LevelStem> withOverworld(HolderLookup<DimensionType> var0, Map<ResourceKey<LevelStem>, LevelStem> var1, ChunkGenerator var2) {
        LevelStem var3 = var1.get(LevelStem.OVERWORLD);
        Holder<DimensionType> var4 = var3 == null ? var0.getOrThrow(BuiltinDimensionTypes.OVERWORLD) : var3.type();
        return WorldDimensions.withOverworld(var1, var4, var2);
    }

    public static Map<ResourceKey<LevelStem>, LevelStem> withOverworld(Map<ResourceKey<LevelStem>, LevelStem> var0, Holder<DimensionType> var1, ChunkGenerator var2) {
        ImmutableMap.Builder var3 = ImmutableMap.builder();
        var3.putAll(var0);
        var3.put(LevelStem.OVERWORLD, (Object)new LevelStem(var1, var2));
        return var3.buildKeepingLast();
    }

    public ChunkGenerator overworld() {
        LevelStem var0 = this.dimensions.get(LevelStem.OVERWORLD);
        if (var0 == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
        return var0.generator();
    }

    public Optional<LevelStem> get(ResourceKey<LevelStem> var0) {
        return Optional.ofNullable(this.dimensions.get(var0));
    }

    public ImmutableSet<ResourceKey<Level>> levels() {
        return (ImmutableSet)this.dimensions().keySet().stream().map(Registries::levelStemToLevel).collect(ImmutableSet.toImmutableSet());
    }

    public boolean isDebug() {
        return this.overworld() instanceof DebugLevelSource;
    }

    private static PrimaryLevelData.SpecialWorldProperty specialWorldProperty(Registry<LevelStem> var02) {
        return var02.getOptional(LevelStem.OVERWORLD).map(var0 -> {
            ChunkGenerator var1 = var0.generator();
            if (var1 instanceof DebugLevelSource) {
                return PrimaryLevelData.SpecialWorldProperty.DEBUG;
            }
            if (var1 instanceof FlatLevelSource) {
                return PrimaryLevelData.SpecialWorldProperty.FLAT;
            }
            return PrimaryLevelData.SpecialWorldProperty.NONE;
        }).orElse(PrimaryLevelData.SpecialWorldProperty.NONE);
    }

    static Lifecycle checkStability(ResourceKey<LevelStem> var0, LevelStem var1) {
        return WorldDimensions.isVanillaLike(var0, var1) ? Lifecycle.stable() : Lifecycle.experimental();
    }

    private static boolean isVanillaLike(ResourceKey<LevelStem> var0, LevelStem var1) {
        if (var0 == LevelStem.OVERWORLD) {
            return WorldDimensions.isStableOverworld(var1);
        }
        if (var0 == LevelStem.NETHER) {
            return WorldDimensions.isStableNether(var1);
        }
        if (var0 == LevelStem.END) {
            return WorldDimensions.isStableEnd(var1);
        }
        return false;
    }

    private static boolean isStableOverworld(LevelStem var0) {
        MultiNoiseBiomeSource var2;
        Holder<DimensionType> var1 = var0.type();
        if (!var1.is(BuiltinDimensionTypes.OVERWORLD) && !var1.is(BuiltinDimensionTypes.OVERWORLD_CAVES)) {
            return false;
        }
        BiomeSource biomeSource = var0.generator().getBiomeSource();
        return !(biomeSource instanceof MultiNoiseBiomeSource) || (var2 = (MultiNoiseBiomeSource)biomeSource).stable(MultiNoiseBiomeSourceParameterLists.OVERWORLD);
    }

    private static boolean isStableNether(LevelStem var0) {
        MultiNoiseBiomeSource var1;
        NoiseBasedChunkGenerator var2;
        Object object;
        return var0.type().is(BuiltinDimensionTypes.NETHER) && (object = var0.generator()) instanceof NoiseBasedChunkGenerator && (var2 = (NoiseBasedChunkGenerator)object).stable(NoiseGeneratorSettings.NETHER) && (object = var2.getBiomeSource()) instanceof MultiNoiseBiomeSource && (var1 = (MultiNoiseBiomeSource)object).stable(MultiNoiseBiomeSourceParameterLists.NETHER);
    }

    private static boolean isStableEnd(LevelStem var0) {
        NoiseBasedChunkGenerator var1;
        ChunkGenerator chunkGenerator;
        return var0.type().is(BuiltinDimensionTypes.END) && (chunkGenerator = var0.generator()) instanceof NoiseBasedChunkGenerator && (var1 = (NoiseBasedChunkGenerator)chunkGenerator).stable(NoiseGeneratorSettings.END) && var1.getBiomeSource() instanceof TheEndBiomeSource;
    }

    public Complete bake(Registry<LevelStem> var0) {
        final class Entry
        extends Record {
            final ResourceKey<LevelStem> key;
            final LevelStem value;

            Entry(ResourceKey<LevelStem> var0, LevelStem var1) {
                this.key = var0;
                this.value = var1;
            }

            RegistrationInfo registrationInfo() {
                return new RegistrationInfo(Optional.empty(), WorldDimensions.checkStability(this.key, this.value));
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Entry.class, "key;value", "key", "value"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Entry.class, "key;value", "key", "value"}, this);
            }

            @Override
            public final boolean equals(Object var0) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Entry.class, "key;value", "key", "value"}, this, var0);
            }

            public ResourceKey<LevelStem> key() {
                return this.key;
            }

            public LevelStem value() {
                return this.value;
            }
        }
        Stream<ResourceKey<LevelStem>> var12 = Stream.concat(var0.registryKeySet().stream(), this.dimensions.keySet().stream()).distinct();
        ArrayList var2 = new ArrayList();
        WorldDimensions.keysInOrder(var12).forEach(var22 -> var0.getOptional((ResourceKey<LevelStem>)var22).or(() -> Optional.ofNullable(this.dimensions.get(var22))).ifPresent(var2 -> var2.add(new Entry((ResourceKey<LevelStem>)var22, (LevelStem)var2))));
        Lifecycle var3 = var2.size() == VANILLA_DIMENSION_COUNT ? Lifecycle.stable() : Lifecycle.experimental();
        MappedRegistry<LevelStem> var4 = new MappedRegistry<LevelStem>(Registries.LEVEL_STEM, var3);
        var2.forEach(var1 -> var4.register(var1.key, var1.value, var1.registrationInfo()));
        Registry<LevelStem> var5 = var4.freeze();
        PrimaryLevelData.SpecialWorldProperty var6 = WorldDimensions.specialWorldProperty(var5);
        return new Complete(var5.freeze(), var6);
    }

    public record Complete(Registry<LevelStem> dimensions, PrimaryLevelData.SpecialWorldProperty specialWorldProperty) {
        public Lifecycle lifecycle() {
            return this.dimensions.registryLifecycle();
        }

        public RegistryAccess.Frozen dimensionsRegistryAccess() {
            return new RegistryAccess.ImmutableRegistryAccess(List.of(this.dimensions)).freeze();
        }
    }
}

