/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;

public abstract class AbstractHugeMushroomFeature
extends Feature<HugeMushroomFeatureConfiguration> {
    public AbstractHugeMushroomFeature(Codec<HugeMushroomFeatureConfiguration> var0) {
        super(var0);
    }

    protected void placeTrunk(LevelAccessor var0, RandomSource var1, BlockPos var2, HugeMushroomFeatureConfiguration var3, int var4, BlockPos.MutableBlockPos var5) {
        for (int var6 = 0; var6 < var4; ++var6) {
            var5.set(var2).move(Direction.UP, var6);
            this.placeMushroomBlock(var0, var5, var3.stemProvider.getState(var1, var2));
        }
    }

    protected void placeMushroomBlock(LevelAccessor var0, BlockPos.MutableBlockPos var1, BlockState var2) {
        BlockState var3 = var0.getBlockState(var1);
        if (var3.isAir() || var3.is(BlockTags.REPLACEABLE_BY_MUSHROOMS)) {
            this.setBlock(var0, var1, var2);
        }
    }

    protected int getTreeHeight(RandomSource var0) {
        int var1 = var0.nextInt(3) + 4;
        if (var0.nextInt(12) == 0) {
            var1 *= 2;
        }
        return var1;
    }

    protected boolean isValidPosition(LevelAccessor var0, BlockPos var1, int var2, BlockPos.MutableBlockPos var3, HugeMushroomFeatureConfiguration var4) {
        int var5 = var1.getY();
        if (var5 < var0.getMinY() + 1 || var5 + var2 + 1 > var0.getMaxY()) {
            return false;
        }
        BlockState var6 = var0.getBlockState(var1.below());
        if (!AbstractHugeMushroomFeature.isDirt(var6) && !var6.is(BlockTags.MUSHROOM_GROW_BLOCK)) {
            return false;
        }
        for (int var7 = 0; var7 <= var2; ++var7) {
            int var8 = this.getTreeRadiusForHeight(-1, -1, var4.foliageRadius, var7);
            for (int var9 = -var8; var9 <= var8; ++var9) {
                for (int var10 = -var8; var10 <= var8; ++var10) {
                    BlockState var11 = var0.getBlockState(var3.setWithOffset(var1, var9, var7, var10));
                    if (var11.isAir() || var11.is(BlockTags.LEAVES)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean place(FeaturePlaceContext<HugeMushroomFeatureConfiguration> var0) {
        BlockPos.MutableBlockPos var6;
        WorldGenLevel var1 = var0.level();
        BlockPos var2 = var0.origin();
        RandomSource var3 = var0.random();
        HugeMushroomFeatureConfiguration var4 = var0.config();
        int var5 = this.getTreeHeight(var3);
        if (!this.isValidPosition(var1, var2, var5, var6 = new BlockPos.MutableBlockPos(), var4)) {
            return false;
        }
        this.makeCap(var1, var3, var2, var5, var6, var4);
        this.placeTrunk(var1, var3, var2, var4, var5, var6);
        return true;
    }

    protected abstract int getTreeRadiusForHeight(int var1, int var2, int var3, int var4);

    protected abstract void makeCap(LevelAccessor var1, RandomSource var2, BlockPos var3, int var4, BlockPos.MutableBlockPos var5, HugeMushroomFeatureConfiguration var6);
}

