/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TwistingVinesConfig;

public class TwistingVinesFeature
extends Feature<TwistingVinesConfig> {
    public TwistingVinesFeature(Codec<TwistingVinesConfig> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<TwistingVinesConfig> var0) {
        BlockPos var2;
        WorldGenLevel var1 = var0.level();
        if (TwistingVinesFeature.isInvalidPlacementLocation(var1, var2 = var0.origin())) {
            return false;
        }
        RandomSource var3 = var0.random();
        TwistingVinesConfig var4 = var0.config();
        int var5 = var4.spreadWidth();
        int var6 = var4.spreadHeight();
        int var7 = var4.maxHeight();
        BlockPos.MutableBlockPos var8 = new BlockPos.MutableBlockPos();
        for (int var9 = 0; var9 < var5 * var5; ++var9) {
            var8.set(var2).move(Mth.nextInt(var3, -var5, var5), Mth.nextInt(var3, -var6, var6), Mth.nextInt(var3, -var5, var5));
            if (!TwistingVinesFeature.findFirstAirBlockAboveGround(var1, var8) || TwistingVinesFeature.isInvalidPlacementLocation(var1, var8)) continue;
            int var10 = Mth.nextInt(var3, 1, var7);
            if (var3.nextInt(6) == 0) {
                var10 *= 2;
            }
            if (var3.nextInt(5) == 0) {
                var10 = 1;
            }
            int var11 = 17;
            int var12 = 25;
            TwistingVinesFeature.placeWeepingVinesColumn(var1, var3, var8, var10, 17, 25);
        }
        return true;
    }

    private static boolean findFirstAirBlockAboveGround(LevelAccessor var0, BlockPos.MutableBlockPos var1) {
        do {
            var1.move(0, -1, 0);
            if (!var0.isOutsideBuildHeight(var1)) continue;
            return false;
        } while (var0.getBlockState(var1).isAir());
        var1.move(0, 1, 0);
        return true;
    }

    public static void placeWeepingVinesColumn(LevelAccessor var0, RandomSource var1, BlockPos.MutableBlockPos var2, int var3, int var4, int var5) {
        for (int var6 = 1; var6 <= var3; ++var6) {
            if (var0.isEmptyBlock(var2)) {
                if (var6 == var3 || !var0.isEmptyBlock((BlockPos)var2.above())) {
                    var0.setBlock(var2, (BlockState)Blocks.TWISTING_VINES.defaultBlockState().setValue(GrowingPlantHeadBlock.AGE, Mth.nextInt(var1, var4, var5)), 2);
                    break;
                }
                var0.setBlock(var2, Blocks.TWISTING_VINES_PLANT.defaultBlockState(), 2);
            }
            var2.move(Direction.UP);
        }
    }

    private static boolean isInvalidPlacementLocation(LevelAccessor var0, BlockPos var1) {
        if (!var0.isEmptyBlock(var1)) {
            return true;
        }
        BlockState var2 = var0.getBlockState(var1.below());
        return !var2.is(Blocks.NETHERRACK) && !var2.is(Blocks.WARPED_NYLIUM) && !var2.is(Blocks.WARPED_WART_BLOCK);
    }
}

