/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;

public class VegetationPatchFeature
extends Feature<VegetationPatchConfiguration> {
    public VegetationPatchFeature(Codec<VegetationPatchConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<VegetationPatchConfiguration> var0) {
        WorldGenLevel var12 = var0.level();
        VegetationPatchConfiguration var2 = var0.config();
        RandomSource var3 = var0.random();
        BlockPos var4 = var0.origin();
        Predicate<BlockState> var5 = var1 -> var1.is(var0.replaceable);
        int var6 = var2.xzRadius.sample(var3) + 1;
        int var7 = var2.xzRadius.sample(var3) + 1;
        Set<BlockPos> var8 = this.placeGroundPatch(var12, var2, var3, var4, var5, var6, var7);
        this.distributeVegetation(var0, var12, var2, var3, var8, var6, var7);
        return !var8.isEmpty();
    }

    protected Set<BlockPos> placeGroundPatch(WorldGenLevel var02, VegetationPatchConfiguration var1, RandomSource var2, BlockPos var3, Predicate<BlockState> var4, int var5, int var6) {
        BlockPos.MutableBlockPos var7 = var3.mutable();
        BlockPos.MutableBlockPos var8 = var7.mutable();
        Direction var9 = var1.surface.getDirection();
        Direction var10 = var9.getOpposite();
        HashSet<BlockPos> var11 = new HashSet<BlockPos>();
        for (int var12 = -var5; var12 <= var5; ++var12) {
            boolean var13 = var12 == -var5 || var12 == var5;
            for (int var14 = -var6; var14 <= var6; ++var14) {
                int var19;
                boolean var18;
                boolean var15 = var14 == -var6 || var14 == var6;
                boolean var16 = var13 || var15;
                boolean var17 = var13 && var15;
                boolean bl = var18 = var16 && !var17;
                if (var17 || var18 && (var1.extraEdgeColumnChance == 0.0f || var2.nextFloat() > var1.extraEdgeColumnChance)) continue;
                var7.setWithOffset(var3, var12, 0, var14);
                for (var19 = 0; var02.isStateAtPosition(var7, BlockBehaviour.BlockStateBase::isAir) && var19 < var1.verticalRange; ++var19) {
                    var7.move(var9);
                }
                for (var19 = 0; var02.isStateAtPosition(var7, var0 -> !var0.isAir()) && var19 < var1.verticalRange; ++var19) {
                    var7.move(var10);
                }
                var8.setWithOffset((Vec3i)var7, var1.surface.getDirection());
                BlockState var20 = var02.getBlockState(var8);
                if (!var02.isEmptyBlock(var7) || !var20.isFaceSturdy(var02, var8, var1.surface.getDirection().getOpposite())) continue;
                int var21 = var1.depth.sample(var2) + (var1.extraBottomBlockChance > 0.0f && var2.nextFloat() < var1.extraBottomBlockChance ? 1 : 0);
                BlockPos var22 = var8.immutable();
                boolean var23 = this.placeGround(var02, var1, var4, var2, var8, var21);
                if (!var23) continue;
                var11.add(var22);
            }
        }
        return var11;
    }

    protected void distributeVegetation(FeaturePlaceContext<VegetationPatchConfiguration> var0, WorldGenLevel var1, VegetationPatchConfiguration var2, RandomSource var3, Set<BlockPos> var4, int var5, int var6) {
        for (BlockPos var8 : var4) {
            if (!(var2.vegetationChance > 0.0f) || !(var3.nextFloat() < var2.vegetationChance)) continue;
            this.placeVegetation(var1, var2, var0.chunkGenerator(), var3, var8);
        }
    }

    protected boolean placeVegetation(WorldGenLevel var0, VegetationPatchConfiguration var1, ChunkGenerator var2, RandomSource var3, BlockPos var4) {
        return var1.vegetationFeature.value().place(var0, var2, var3, var4.relative(var1.surface.getDirection().getOpposite()));
    }

    protected boolean placeGround(WorldGenLevel var0, VegetationPatchConfiguration var1, Predicate<BlockState> var2, RandomSource var3, BlockPos.MutableBlockPos var4, int var5) {
        for (int var6 = 0; var6 < var5; ++var6) {
            BlockState var8;
            BlockState var7 = var1.groundState.getState(var3, var4);
            if (var7.is((var8 = var0.getBlockState(var4)).getBlock())) continue;
            if (!var2.test(var8)) {
                return var6 != 0;
            }
            var0.setBlock(var4, var7, 2);
            var4.move(var1.surface.getDirection());
        }
        return true;
    }
}

