/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class LeaveVineDecorator
extends TreeDecorator {
    public static final MapCodec<LeaveVineDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(LeaveVineDecorator::new, var0 -> Float.valueOf(var0.probability));
    private final float probability;

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.LEAVE_VINE;
    }

    public LeaveVineDecorator(float var0) {
        this.probability = var0;
    }

    @Override
    public void place(TreeDecorator.Context var0) {
        RandomSource var1 = var0.random();
        var0.leaves().forEach(var2 -> {
            BlockPos var3;
            if (var1.nextFloat() < this.probability && var0.isAir(var3 = var2.west())) {
                LeaveVineDecorator.addHangingVine(var3, VineBlock.EAST, var0);
            }
            if (var1.nextFloat() < this.probability && var0.isAir(var3 = var2.east())) {
                LeaveVineDecorator.addHangingVine(var3, VineBlock.WEST, var0);
            }
            if (var1.nextFloat() < this.probability && var0.isAir(var3 = var2.north())) {
                LeaveVineDecorator.addHangingVine(var3, VineBlock.SOUTH, var0);
            }
            if (var1.nextFloat() < this.probability && var0.isAir(var3 = var2.south())) {
                LeaveVineDecorator.addHangingVine(var3, VineBlock.NORTH, var0);
            }
        });
    }

    private static void addHangingVine(BlockPos var0, BooleanProperty var1, TreeDecorator.Context var2) {
        var2.placeVine(var0, var1);
        var0 = var0.below();
        for (int var3 = 4; var2.isAir(var0) && var3 > 0; --var3) {
            var2.placeVine(var0, var1);
            var0 = var0.below();
        }
    }
}

