/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class PlacementContext
extends WorldGenerationContext {
    private final WorldGenLevel level;
    private final ChunkGenerator generator;
    private final Optional<PlacedFeature> topFeature;

    public PlacementContext(WorldGenLevel var0, ChunkGenerator var1, Optional<PlacedFeature> var2) {
        super(var1, var0);
        this.level = var0;
        this.generator = var1;
        this.topFeature = var2;
    }

    public int getHeight(Heightmap.Types var0, int var1, int var2) {
        return this.level.getHeight(var0, var1, var2);
    }

    public CarvingMask getCarvingMask(ChunkPos var0) {
        return ((ProtoChunk)this.level.getChunk(var0.x, var0.z)).getOrCreateCarvingMask();
    }

    public BlockState getBlockState(BlockPos var0) {
        return this.level.getBlockState(var0);
    }

    public int getMinY() {
        return this.level.getMinY();
    }

    public WorldGenLevel getLevel() {
        return this.level;
    }

    public Optional<PlacedFeature> topFeature() {
        return this.topFeature;
    }

    public ChunkGenerator generator() {
        return this.generator;
    }
}

