/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.EndCityPieces;

public class EndCityStructure
extends Structure {
    public static final MapCodec<EndCityStructure> CODEC = EndCityStructure.simpleCodec(EndCityStructure::new);

    public EndCityStructure(Structure.StructureSettings var0) {
        super(var0);
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext var0) {
        Rotation var1 = Rotation.getRandom(var0.random());
        BlockPos var2 = this.getLowestYIn5by5BoxOffset7Blocks(var0, var1);
        if (var2.getY() < 60) {
            return Optional.empty();
        }
        return Optional.of(new Structure.GenerationStub(var2, var3 -> this.generatePieces((StructurePiecesBuilder)var3, var2, var1, var0)));
    }

    private void generatePieces(StructurePiecesBuilder var0, BlockPos var1, Rotation var2, Structure.GenerationContext var3) {
        ArrayList var4 = Lists.newArrayList();
        EndCityPieces.startHouseTower(var3.structureTemplateManager(), var1, var2, var4, var3.random());
        var4.forEach(var0::addPiece);
    }

    @Override
    public StructureType<?> type() {
        return StructureType.END_CITY;
    }
}

