/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.ShipwreckPieces;

public class ShipwreckStructure
extends Structure {
    public static final MapCodec<ShipwreckStructure> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group(ShipwreckStructure.settingsCodec(var02), (App)Codec.BOOL.fieldOf("is_beached").forGetter(var0 -> var0.isBeached)).apply((Applicative)var02, ShipwreckStructure::new));
    public final boolean isBeached;

    public ShipwreckStructure(Structure.StructureSettings var0, boolean var1) {
        super(var0);
        this.isBeached = var1;
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext var0) {
        Heightmap.Types var12 = this.isBeached ? Heightmap.Types.WORLD_SURFACE_WG : Heightmap.Types.OCEAN_FLOOR_WG;
        return ShipwreckStructure.onTopOfChunkCenter(var0, var12, var1 -> this.generatePieces((StructurePiecesBuilder)var1, var0));
    }

    private void generatePieces(StructurePiecesBuilder var0, Structure.GenerationContext var1) {
        Rotation var2 = Rotation.getRandom(var1.random());
        BlockPos var3 = new BlockPos(var1.chunkPos().getMinBlockX(), 90, var1.chunkPos().getMinBlockZ());
        ShipwreckPieces.ShipwreckPiece var4 = ShipwreckPieces.addRandomPiece(var1.structureTemplateManager(), var3, var2, var0, var1.random(), this.isBeached);
        if (var4.isTooBigToFitInWorldGenRegion()) {
            int var6;
            BoundingBox var5 = var4.getBoundingBox();
            if (this.isBeached) {
                int var7 = Structure.getLowestY(var1, var5.minX(), var5.getXSpan(), var5.minZ(), var5.getZSpan());
                var6 = var4.calculateBeachedPosition(var7, var1.random());
            } else {
                var6 = Structure.getMeanFirstOccupiedHeight(var1, var5.minX(), var5.getXSpan(), var5.minZ(), var5.getZSpan());
            }
            var4.adjustPositionHeight(var6);
        }
    }

    @Override
    public StructureType<?> type() {
        return StructureType.SHIPWRECK;
    }
}

