/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class FluidState
extends StateHolder<Fluid, FluidState> {
    public static final Codec<FluidState> CODEC = FluidState.codec(BuiltInRegistries.FLUID.byNameCodec(), Fluid::defaultFluidState).stable();
    public static final int AMOUNT_MAX = 9;
    public static final int AMOUNT_FULL = 8;

    public FluidState(Fluid var0, Reference2ObjectArrayMap<Property<?>, Comparable<?>> var1, MapCodec<FluidState> var2) {
        super(var0, var1, var2);
    }

    public Fluid getType() {
        return (Fluid)this.owner;
    }

    public boolean isSource() {
        return this.getType().isSource(this);
    }

    public boolean isSourceOfType(Fluid var0) {
        return this.owner == var0 && ((Fluid)this.owner).isSource(this);
    }

    public boolean isEmpty() {
        return this.getType().isEmpty();
    }

    public float getHeight(BlockGetter var0, BlockPos var1) {
        return this.getType().getHeight(this, var0, var1);
    }

    public float getOwnHeight() {
        return this.getType().getOwnHeight(this);
    }

    public int getAmount() {
        return this.getType().getAmount(this);
    }

    public boolean shouldRenderBackwardUpFace(BlockGetter var0, BlockPos var1) {
        for (int var2 = -1; var2 <= 1; ++var2) {
            for (int var3 = -1; var3 <= 1; ++var3) {
                BlockPos var4 = var1.offset(var2, 0, var3);
                FluidState var5 = var0.getFluidState(var4);
                if (var5.getType().isSame(this.getType()) || var0.getBlockState(var4).isSolidRender()) continue;
                return true;
            }
        }
        return false;
    }

    public void tick(ServerLevel var0, BlockPos var1, BlockState var2) {
        this.getType().tick(var0, var1, var2, this);
    }

    public void animateTick(Level var0, BlockPos var1, RandomSource var2) {
        this.getType().animateTick(var0, var1, this, var2);
    }

    public boolean isRandomlyTicking() {
        return this.getType().isRandomlyTicking();
    }

    public void randomTick(ServerLevel var0, BlockPos var1, RandomSource var2) {
        this.getType().randomTick(var0, var1, this, var2);
    }

    public Vec3 getFlow(BlockGetter var0, BlockPos var1) {
        return this.getType().getFlow(var0, var1, this);
    }

    public BlockState createLegacyBlock() {
        return this.getType().createLegacyBlock(this);
    }

    @Nullable
    public ParticleOptions getDripParticle() {
        return this.getType().getDripParticle();
    }

    public boolean is(TagKey<Fluid> var0) {
        return this.getType().builtInRegistryHolder().is(var0);
    }

    public boolean is(HolderSet<Fluid> var0) {
        return var0.contains(this.getType().builtInRegistryHolder());
    }

    public boolean is(Fluid var0) {
        return this.getType() == var0;
    }

    public float getExplosionResistance() {
        return this.getType().getExplosionResistance();
    }

    public boolean canBeReplacedWith(BlockGetter var0, BlockPos var1, Fluid var2, Direction var3) {
        return this.getType().canBeReplacedWith(this, var0, var1, var2, var3);
    }

    public VoxelShape getShape(BlockGetter var0, BlockPos var1) {
        return this.getType().getShape(this, var0, var1);
    }

    @Nullable
    public AABB getAABB(BlockGetter var0, BlockPos var1) {
        return this.getType().getAABB(this, var0, var1);
    }

    public Holder<Fluid> holder() {
        return ((Fluid)this.owner).builtInRegistryHolder();
    }

    public Stream<TagKey<Fluid>> getTags() {
        return ((Fluid)this.owner).builtInRegistryHolder().tags();
    }

    public void entityInside(Level var0, BlockPos var1, Entity var2, InsideBlockEffectApplier var3) {
        this.getType().entityInside(var0, var1, var2, var3);
    }
}

