/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.ComposableEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public abstract class CompositeEntryBase
extends LootPoolEntryContainer {
    public static final ProblemReporter.Problem NO_CHILDREN_PROBLEM = new ProblemReporter.Problem(){

        @Override
        public String description() {
            return "Empty children list";
        }
    };
    protected final List<LootPoolEntryContainer> children;
    private final ComposableEntryContainer composedChildren;

    protected CompositeEntryBase(List<LootPoolEntryContainer> var0, List<LootItemCondition> var1) {
        super(var1);
        this.children = var0;
        this.composedChildren = this.compose(var0);
    }

    @Override
    public void validate(ValidationContext var0) {
        super.validate(var0);
        if (this.children.isEmpty()) {
            var0.reportProblem(NO_CHILDREN_PROBLEM);
        }
        for (int var1 = 0; var1 < this.children.size(); ++var1) {
            this.children.get(var1).validate(var0.forChild(new ProblemReporter.IndexedFieldPathElement("children", var1)));
        }
    }

    protected abstract ComposableEntryContainer compose(List<? extends ComposableEntryContainer> var1);

    @Override
    public final boolean expand(LootContext var0, Consumer<LootPoolEntry> var1) {
        if (!this.canRun(var0)) {
            return false;
        }
        return this.composedChildren.expand(var0, var1);
    }

    public static <T extends CompositeEntryBase> MapCodec<T> createCodec(CompositeEntryConstructor<T> var0) {
        return RecordCodecBuilder.mapCodec(var1 -> var1.group((App)LootPoolEntries.CODEC.listOf().optionalFieldOf("children", List.of()).forGetter(var0 -> var0.children)).and(CompositeEntryBase.commonFields(var1).t1()).apply((Applicative)var1, var0::create));
    }

    @FunctionalInterface
    public static interface CompositeEntryConstructor<T extends CompositeEntryBase> {
        public T create(List<LootPoolEntryContainer> var1, List<LootItemCondition> var2);
    }
}

