/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;

public record ConditionReference(ResourceKey<LootItemCondition> name) implements LootItemCondition
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<ConditionReference> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ResourceKey.codec(Registries.PREDICATE).fieldOf("name").forGetter(ConditionReference::name)).apply((Applicative)var0, ConditionReference::new));

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.REFERENCE;
    }

    @Override
    public void validate(ValidationContext var0) {
        if (!var0.allowsReferences()) {
            var0.reportProblem(new ValidationContext.ReferenceNotAllowedProblem(this.name));
            return;
        }
        if (var0.hasVisitedElement(this.name)) {
            var0.reportProblem(new ValidationContext.RecursiveReferenceProblem(this.name));
            return;
        }
        LootItemCondition.super.validate(var0);
        var0.resolver().get(this.name).ifPresentOrElse(var1 -> ((LootItemCondition)var1.value()).validate(var0.enterElement(new ProblemReporter.ElementReferencePathElement(this.name), this.name)), () -> var0.reportProblem(new ValidationContext.MissingReferenceProblem(this.name)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test(LootContext var0) {
        LootItemCondition var1 = var0.getResolver().get(this.name).map(Holder.Reference::value).orElse(null);
        if (var1 == null) {
            LOGGER.warn("Tried using unknown condition table called {}", (Object)this.name.location());
            return false;
        }
        LootContext.VisitedEntry<LootItemCondition> var2 = LootContext.createVisitedEntry(var1);
        if (var0.pushVisitedElement(var2)) {
            try {
                boolean bl = var1.test(var0);
                return bl;
            }
            finally {
                var0.popVisitedElement(var2);
            }
        }
        LOGGER.warn("Detected infinite loop in loot tables");
        return false;
    }

    public static LootItemCondition.Builder conditionReference(ResourceKey<LootItemCondition> var0) {
        return () -> new ConditionReference(var0);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootContext)object);
    }
}

