/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.ticks.SavedTick;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.SerializableTickContainer;
import net.minecraft.world.ticks.TickContainerAccess;

public class LevelChunkTicks<T>
implements SerializableTickContainer<T>,
TickContainerAccess<T> {
    private final Queue<ScheduledTick<T>> tickQueue = new PriorityQueue(ScheduledTick.DRAIN_ORDER);
    @Nullable
    private List<SavedTick<T>> pendingTicks;
    private final Set<ScheduledTick<?>> ticksPerPosition = new ObjectOpenCustomHashSet(ScheduledTick.UNIQUE_TICK_HASH);
    @Nullable
    private BiConsumer<LevelChunkTicks<T>, ScheduledTick<T>> onTickAdded;

    public LevelChunkTicks() {
    }

    public LevelChunkTicks(List<SavedTick<T>> var0) {
        this.pendingTicks = var0;
        for (SavedTick<T> var2 : var0) {
            this.ticksPerPosition.add(ScheduledTick.probe(var2.type(), var2.pos()));
        }
    }

    public void setOnTickAdded(@Nullable BiConsumer<LevelChunkTicks<T>, ScheduledTick<T>> var0) {
        this.onTickAdded = var0;
    }

    @Nullable
    public ScheduledTick<T> peek() {
        return this.tickQueue.peek();
    }

    @Nullable
    public ScheduledTick<T> poll() {
        ScheduledTick<T> var0 = this.tickQueue.poll();
        if (var0 != null) {
            this.ticksPerPosition.remove(var0);
        }
        return var0;
    }

    @Override
    public void schedule(ScheduledTick<T> var0) {
        if (this.ticksPerPosition.add(var0)) {
            this.scheduleUnchecked(var0);
        }
    }

    private void scheduleUnchecked(ScheduledTick<T> var0) {
        this.tickQueue.add(var0);
        if (this.onTickAdded != null) {
            this.onTickAdded.accept(this, var0);
        }
    }

    @Override
    public boolean hasScheduledTick(BlockPos var0, T var1) {
        return this.ticksPerPosition.contains(ScheduledTick.probe(var1, var0));
    }

    public void removeIf(Predicate<ScheduledTick<T>> var0) {
        Iterator var1 = this.tickQueue.iterator();
        while (var1.hasNext()) {
            ScheduledTick var2 = (ScheduledTick)var1.next();
            if (!var0.test(var2)) continue;
            var1.remove();
            this.ticksPerPosition.remove(var2);
        }
    }

    public Stream<ScheduledTick<T>> getAll() {
        return this.tickQueue.stream();
    }

    @Override
    public int count() {
        return this.tickQueue.size() + (this.pendingTicks != null ? this.pendingTicks.size() : 0);
    }

    @Override
    public List<SavedTick<T>> pack(long var0) {
        ArrayList<SavedTick<T>> var2 = new ArrayList<SavedTick<T>>(this.tickQueue.size());
        if (this.pendingTicks != null) {
            var2.addAll(this.pendingTicks);
        }
        for (ScheduledTick scheduledTick : this.tickQueue) {
            var2.add(scheduledTick.toSavedTick(var0));
        }
        return var2;
    }

    public void unpack(long var0) {
        if (this.pendingTicks != null) {
            int var2 = -this.pendingTicks.size();
            for (SavedTick<T> var4 : this.pendingTicks) {
                this.scheduleUnchecked(var4.unpack(var0, var2++));
            }
        }
        this.pendingTicks = null;
    }
}

