/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftProjectile;
import org.bukkit.entity.Fireball;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class CraftFireball
extends CraftProjectile
implements Fireball {
    public CraftFireball(CraftServer server, AbstractHurtingProjectile entity) {
        super(server, entity);
    }

    public float getYield() {
        return this.getHandle().bukkitYield;
    }

    public boolean isIncendiary() {
        return this.getHandle().isIncendiary;
    }

    public void setIsIncendiary(boolean isIncendiary) {
        this.getHandle().isIncendiary = isIncendiary;
    }

    public void setYield(float yield) {
        this.getHandle().bukkitYield = yield;
    }

    @Override
    public ProjectileSource getShooter() {
        return this.getHandle().projectileSource;
    }

    @Override
    public void setShooter(ProjectileSource shooter) {
        if (shooter instanceof CraftLivingEntity) {
            this.getHandle().setOwner(((CraftLivingEntity)shooter).getHandle());
        } else {
            this.getHandle().setOwner((Entity)null);
        }
        this.getHandle().projectileSource = shooter;
    }

    public Vector getDirection() {
        return this.getAcceleration();
    }

    public void setDirection(Vector direction) {
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector direction cannot be null");
        if (direction.isZero()) {
            this.setVelocity(direction);
            this.setAcceleration(direction);
            return;
        }
        direction = direction.clone().normalize();
        this.setVelocity(direction.clone().multiply(this.getVelocity().length()));
        this.setAcceleration(direction.multiply(this.getAcceleration().length()));
    }

    public void setAcceleration(@NotNull Vector acceleration) {
        Preconditions.checkArgument((acceleration != null ? 1 : 0) != 0, (Object)"Vector acceleration cannot be null");
        this.getHandle().assignDirectionalMovement(new Vec3(acceleration.getX(), acceleration.getY(), acceleration.getZ()), acceleration.length());
        this.update();
    }

    @NotNull
    public Vector getAcceleration() {
        Vec3 delta = this.getHandle().getDeltaMovement();
        return new Vector(delta.x, delta.y, delta.z);
    }

    @Override
    public AbstractHurtingProjectile getHandle() {
        return (AbstractHurtingProjectile)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFireball";
    }
}

