/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import net.minecraft.core.Holder;
import net.minecraft.world.entity.decoration.PaintingVariant;
import org.bukkit.Art;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R6.CraftArt;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHanging;
import org.bukkit.entity.Painting;

public class CraftPainting
extends CraftHanging
implements Painting {
    public CraftPainting(CraftServer server, net.minecraft.world.entity.decoration.Painting entity) {
        super(server, entity);
    }

    public Art getArt() {
        return CraftArt.minecraftHolderToBukkit(this.getHandle().getVariant());
    }

    public boolean setArt(Art art) {
        return this.setArt(art, false);
    }

    public boolean setArt(Art art, boolean force) {
        net.minecraft.world.entity.decoration.Painting painting = this.getHandle();
        Holder<PaintingVariant> oldArt = painting.getVariant();
        painting.setVariant(CraftArt.bukkitToMinecraftHolder(art));
        painting.setDirection(painting.getDirection());
        if (!(force || this.getHandle().generation || painting.survives())) {
            painting.setVariant(oldArt);
            painting.setDirection(painting.getDirection());
            return false;
        }
        this.update();
        return true;
    }

    @Override
    public boolean setFacingDirection(BlockFace face, boolean force) {
        if (super.setFacingDirection(face, force)) {
            this.update();
            return true;
        }
        return false;
    }

    @Override
    public net.minecraft.world.entity.decoration.Painting getHandle() {
        return (net.minecraft.world.entity.decoration.Painting)this.entity;
    }

    @Override
    public String toString() {
        return "CraftPainting{art=" + String.valueOf(this.getArt()) + "}";
    }
}

