/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.LevelData;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R6.util.DummyGeneratorAccess;

public class BlockStateListPopulator
extends DummyGeneratorAccess {
    private final LevelAccessor world;
    private final Map<BlockPos, net.minecraft.world.level.block.state.BlockState> dataMap = new HashMap<BlockPos, net.minecraft.world.level.block.state.BlockState>();
    private final Map<BlockPos, BlockEntity> entityMap = new HashMap<BlockPos, BlockEntity>();
    private final LinkedHashMap<BlockPos, CraftBlockState> list;

    public BlockStateListPopulator(LevelAccessor world) {
        this(world, new LinkedHashMap<BlockPos, CraftBlockState>());
    }

    private BlockStateListPopulator(LevelAccessor world, LinkedHashMap<BlockPos, CraftBlockState> list) {
        this.world = world;
        this.list = list;
    }

    @Override
    public net.minecraft.world.level.block.state.BlockState getBlockState(BlockPos bp) {
        net.minecraft.world.level.block.state.BlockState blockData = this.dataMap.get(bp);
        return blockData != null ? blockData : this.world.getBlockState(bp);
    }

    @Override
    public FluidState getFluidState(BlockPos bp) {
        net.minecraft.world.level.block.state.BlockState blockData = this.dataMap.get(bp);
        return blockData != null ? blockData.getFluidState() : this.world.getFluidState(bp);
    }

    @Override
    public BlockEntity getBlockEntity(BlockPos blockposition) {
        if (this.entityMap.containsKey(blockposition)) {
            return this.entityMap.get(blockposition);
        }
        return this.world.getBlockEntity(blockposition);
    }

    @Override
    public boolean setBlock(BlockPos position, net.minecraft.world.level.block.state.BlockState data, int flag) {
        position = position.immutable();
        this.list.remove(position);
        this.dataMap.put(position, data);
        if (data.hasBlockEntity()) {
            this.entityMap.put(position, ((EntityBlock)((Object)data.getBlock())).newBlockEntity(position, data));
        } else {
            this.entityMap.put(position, null);
        }
        CraftBlockState state = (CraftBlockState)CraftBlock.at(this, position).getState();
        state.setFlag(flag);
        state.setWorldHandle(this.world);
        this.list.put(position, state);
        return true;
    }

    @Override
    public ServerLevel getMinecraftWorld() {
        return this.world.getMinecraftWorld();
    }

    public void refreshTiles() {
        for (CraftBlockState state : this.list.values()) {
            if (!(state instanceof CraftBlockEntityState)) continue;
            ((CraftBlockEntityState)state).refreshSnapshot();
        }
    }

    public void updateList() {
        for (BlockState blockState : this.list.values()) {
            blockState.update(true);
        }
    }

    public Set<BlockPos> getBlocks() {
        return this.list.keySet();
    }

    public List<CraftBlockState> getList() {
        return new ArrayList<CraftBlockState>(this.list.values());
    }

    public LevelAccessor getWorld() {
        return this.world;
    }

    @Override
    public int getMinY() {
        return this.getWorld().getMinY();
    }

    @Override
    public int getHeight() {
        return this.getWorld().getHeight();
    }

    @Override
    public boolean isStateAtPosition(BlockPos blockposition, Predicate<net.minecraft.world.level.block.state.BlockState> predicate) {
        return predicate.test(this.getBlockState(blockposition));
    }

    @Override
    public boolean isFluidAtPosition(BlockPos bp, Predicate<FluidState> prdct) {
        return this.world.isFluidAtPosition(bp, prdct);
    }

    @Override
    public DimensionType dimensionType() {
        return this.world.dimensionType();
    }

    @Override
    public RegistryAccess registryAccess() {
        return this.world.registryAccess();
    }

    @Override
    public LevelData getLevelData() {
        return this.world.getLevelData();
    }

    @Override
    public long nextSubTickCount() {
        return this.world.nextSubTickCount();
    }

    @Override
    public RandomSource getRandom() {
        return this.world.getRandom();
    }

    @Override
    public ChunkSource getChunkSource() {
        return this.world.getChunkSource();
    }
}

