/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R6.CraftChunkSnapshot;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;

public class CraftChunk
implements Chunk {
    private final awx worldServer;
    private final int x;
    private final int z;
    private static final emd<ejm> emptyBlockIDs = new emd<ejm>(dux.a.m(), emi.a(duv.k));
    private static final byte[] FULL_LIGHT = new byte[2048];
    private static final byte[] EMPTY_LIGHT = new byte[2048];

    public CraftChunk(elv chunk) {
        this.worldServer = chunk.q;
        this.x = chunk.f().h;
        this.z = chunk.f().i;
    }

    public CraftChunk(awx worldServer, int x2, int z2) {
        this.worldServer = worldServer;
        this.x = x2;
        this.z = z2;
    }

    public World getWorld() {
        return this.worldServer.getWorld();
    }

    public CraftWorld getCraftWorld() {
        return (CraftWorld)this.getWorld();
    }

    public elk getHandle(emo chunkStatus) {
        elk chunkAccess = this.worldServer.a(this.x, this.z, chunkStatus);
        if (chunkAccess instanceof elu) {
            elu extension = (elu)chunkAccess;
            return extension.H();
        }
        return chunkAccess;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public String toString() {
        return "CraftChunk{x=" + this.getX() + "z=" + this.getZ() + "}";
    }

    public Block getBlock(int x2, int y2, int z2) {
        CraftChunk.validateChunkCoordinates(this.worldServer.M_(), this.worldServer.ar(), x2, y2, z2);
        return new CraftBlock(this.worldServer, new ja(this.x << 4 | x2, y2, this.z << 4 | z2));
    }

    public boolean isEntitiesLoaded() {
        return this.getCraftWorld().getHandle().M.a(dqv.c(this.x, this.z));
    }

    public Entity[] getEntities() {
        long pair;
        eog<cdv> entityManager;
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        if ((entityManager = this.getCraftWorld().getHandle().M).a(pair = dqv.c(this.x, this.z))) {
            return (Entity[])entityManager.getEntities(new dqv(this.x, this.z)).stream().map(cdv::getBukkitEntity).filter(Objects::nonNull).toArray(Entity[]::new);
        }
        entityManager.b(pair);
        caf mailbox = ((emy)entityManager.d).g;
        BooleanSupplier supplier = () -> {
            if (entityManager.a(pair)) {
                return true;
            }
            if (!entityManager.isPending(pair)) {
                entityManager.b(pair);
            }
            entityManager.b();
            return entityManager.a(pair);
        };
        while (!supplier.getAsBoolean()) {
            if (mailbox.b() != 0) {
                mailbox.run();
                continue;
            }
            Thread.yield();
            LockSupport.parkNanos("waiting for entity loading", 100000L);
        }
        return (Entity[])entityManager.getEntities(new dqv(this.x, this.z)).stream().map(cdv::getBukkitEntity).filter(Objects::nonNull).toArray(Entity[]::new);
    }

    public BlockState[] getTileEntities() {
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        int index = 0;
        elk chunk = this.getHandle(emo.n);
        BlockState[] entities = new BlockState[chunk.j.size()];
        for (ja position : chunk.j.keySet()) {
            entities[index++] = this.worldServer.getWorld().getBlockAt(position.u(), position.v(), position.w()).getState();
        }
        return entities;
    }

    public boolean isGenerated() {
        elk chunk = this.getHandle(emo.c);
        return chunk.n().a(emo.n);
    }

    public boolean isLoaded() {
        return this.getWorld().isChunkLoaded((Chunk)this);
    }

    public boolean load() {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), true);
    }

    public boolean load(boolean generate) {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), generate);
    }

    public boolean unload() {
        return this.getWorld().unloadChunk(this.getX(), this.getZ());
    }

    public boolean isSlimeChunk() {
        return eqo.a(this.getX(), this.getZ(), this.getWorld().getSeed(), this.worldServer.spigotConfig.slimeSeed).a(10) == 0;
    }

    public boolean unload(boolean save) {
        return this.getWorld().unloadChunk(this.getX(), this.getZ(), save);
    }

    public boolean isForceLoaded() {
        return this.getWorld().isChunkForceLoaded(this.getX(), this.getZ());
    }

    public void setForceLoaded(boolean forced) {
        this.getWorld().setChunkForceLoaded(this.getX(), this.getZ(), forced);
    }

    public boolean addPluginChunkTicket(Plugin plugin) {
        return this.getWorld().addPluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    public boolean removePluginChunkTicket(Plugin plugin) {
        return this.getWorld().removePluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    public Collection<Plugin> getPluginChunkTickets() {
        return this.getWorld().getPluginChunkTickets(this.getX(), this.getZ());
    }

    public long getInhabitedTime() {
        return this.getHandle(emo.c).w();
    }

    public void setInhabitedTime(long ticks) {
        Preconditions.checkArgument((ticks >= 0L ? 1 : 0) != 0, (Object)"ticks cannot be negative");
        this.getHandle(emo.d).c(ticks);
    }

    public boolean contains(BlockData block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        com.google.common.base.Predicate nms = Predicates.equalTo((Object)((CraftBlockData)block).getState());
        for (elw section : this.getHandle(emo.n).d()) {
            if (section == null || !section.h().a((Predicate<ejm>)nms)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Biome biome) {
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome cannot be null");
        elk chunk = this.getHandle(emo.f);
        com.google.common.base.Predicate nms = Predicates.equalTo(CraftBiome.bukkitToMinecraftHolder(biome));
        for (elw section : chunk.d()) {
            if (section == null || !section.i().a((Predicate<jk<dst>>)nms)) continue;
            return true;
        }
        return false;
    }

    public ChunkSnapshot getChunkSnapshot() {
        return this.getChunkSnapshot(true, false, false);
    }

    public ChunkSnapshot getChunkSnapshot(boolean includeMaxBlockY, boolean includeBiome, boolean includeBiomeTempRain) {
        elk chunk = this.getHandle(emo.n);
        elw[] cs2 = chunk.d();
        emd[] sectionBlockIDs = new emd[cs2.length];
        byte[][] sectionSkyLights = new byte[cs2.length][];
        byte[][] sectionEmitLights = new byte[cs2.length][];
        boolean[] sectionEmpty = new boolean[cs2.length];
        emd[] biome = includeBiome || includeBiomeTempRain ? new emd[cs2.length] : null;
        eme palettedcontainerfactory = this.worldServer.ao();
        Codec<emf<jk<dst>>> biomeCodec = palettedcontainerfactory.h();
        for (int i2 = 0; i2 < cs2.length; ++i2) {
            up data = new up();
            data.a("block_states", (vp)palettedcontainerfactory.e().encodeStart((DynamicOps)vd.a, cs2[i2].h()).getOrThrow());
            sectionBlockIDs[i2] = (emd)palettedcontainerfactory.e().parse((DynamicOps)vd.a, (Object)data.n("block_states")).getOrThrow(eni.a::new);
            sectionEmpty[i2] = cs2[i2].c();
            ffp lightengine = this.worldServer.E_();
            elq skyLightArray = lightengine.a(drz.a).a(kd.a(this.x, chunk.h(i2), this.z));
            if (skyLightArray == null) {
                sectionSkyLights[i2] = this.worldServer.H_().g() ? FULL_LIGHT : EMPTY_LIGHT;
            } else {
                sectionSkyLights[i2] = new byte[2048];
                System.arraycopy(skyLightArray.a(), 0, sectionSkyLights[i2], 0, 2048);
            }
            elq emitLightArray = lightengine.a(drz.b).a(kd.a(this.x, chunk.h(i2), this.z));
            if (emitLightArray == null) {
                sectionEmitLights[i2] = EMPTY_LIGHT;
            } else {
                sectionEmitLights[i2] = new byte[2048];
                System.arraycopy(emitLightArray.a(), 0, sectionEmitLights[i2], 0, 2048);
            }
            if (biome == null) continue;
            data.a("biomes", (vp)biomeCodec.encodeStart((DynamicOps)vd.a, cs2[i2].i()).getOrThrow());
            biome[i2] = (emf)biomeCodec.parse((DynamicOps)vd.a, (Object)data.n("biomes")).getOrThrow(eni.a::new);
        }
        epp hmap = null;
        if (includeMaxBlockY) {
            hmap = new epp(chunk, epp.a.e);
            hmap.a(chunk, epp.a.e, chunk.g.get(epp.a.e).a());
        }
        World world = this.getWorld();
        return new CraftChunkSnapshot(this.getX(), this.getZ(), chunk.M_(), chunk.ar(), world.getSeaLevel(), world.getName(), world.getFullTime(), sectionBlockIDs, sectionSkyLights, sectionEmitLights, sectionEmpty, hmap, biome);
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.getHandle((emo)emo.d).persistentDataContainer;
    }

    public Chunk.LoadLevel getLoadLevel() {
        elv chunk = this.worldServer.getChunkIfLoaded(this.getX(), this.getZ());
        if (chunk == null) {
            return Chunk.LoadLevel.UNLOADED;
        }
        return Chunk.LoadLevel.values()[chunk.G().ordinal()];
    }

    public Collection<GeneratedStructure> getStructures() {
        return this.getCraftWorld().getStructures(this.getX(), this.getZ());
    }

    public Collection<GeneratedStructure> getStructures(Structure structure) {
        return this.getCraftWorld().getStructures(this.getX(), this.getZ(), structure);
    }

    public Collection<Player> getPlayersSeeingChunk() {
        return this.getWorld().getPlayersSeeingChunk((Chunk)this);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        CraftChunk that = (CraftChunk)o2;
        if (this.x != that.x) {
            return false;
        }
        if (this.z != that.z) {
            return false;
        }
        return this.worldServer.equals(that.worldServer);
    }

    public int hashCode() {
        int result = this.worldServer.hashCode();
        result = 31 * result + this.x;
        result = 31 * result + this.z;
        return result;
    }

    public static ChunkSnapshot getEmptyChunkSnapshot(int x2, int z2, CraftWorld world, boolean includeBiome, boolean includeBiomeTempRain) {
        elk actual = world.getHandle().a(x2, z2, includeBiome || includeBiomeTempRain ? emo.f : emo.c);
        int hSection = actual.as();
        emd[] blockIDs = new emd[hSection];
        byte[][] skyLight = new byte[hSection][];
        byte[][] emitLight = new byte[hSection][];
        boolean[] empty = new boolean[hSection];
        emd[] biome = includeBiome || includeBiomeTempRain ? new emd[hSection] : null;
        Codec<emf<jk<dst>>> biomeCodec = world.getHandle().ao().h();
        for (int i2 = 0; i2 < hSection; ++i2) {
            blockIDs[i2] = emptyBlockIDs;
            skyLight[i2] = world.getHandle().H_().g() ? FULL_LIGHT : EMPTY_LIGHT;
            emitLight[i2] = EMPTY_LIGHT;
            empty[i2] = true;
            if (biome == null) continue;
            biome[i2] = (emd)biomeCodec.parse((DynamicOps)vd.a, (Object)((vp)biomeCodec.encodeStart((DynamicOps)vd.a, actual.b(i2).i()).getOrThrow())).getOrThrow(eni.a::new);
        }
        return new CraftChunkSnapshot(x2, z2, world.getMinHeight(), world.getMaxHeight(), world.getSeaLevel(), world.getName(), world.getFullTime(), blockIDs, skyLight, emitLight, empty, new epp(actual, epp.a.e), biome);
    }

    static void validateChunkCoordinates(int minY, int maxY, int x2, int y2, int z2) {
        Preconditions.checkArgument((0 <= x2 && x2 <= 15 ? 1 : 0) != 0, (String)"x out of range (expected 0-15, got %s)", (int)x2);
        Preconditions.checkArgument((minY <= y2 && y2 <= maxY ? 1 : 0) != 0, (String)"y out of range (expected %s-%s, got %s)", (Object)minY, (Object)maxY, (Object)y2);
        Preconditions.checkArgument((0 <= z2 && z2 <= 15 ? 1 : 0) != 0, (String)"z out of range (expected 0-15, got %s)", (int)z2);
    }

    static {
        Arrays.fill(FULL_LIGHT, (byte)-1);
    }
}

