/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import java.util.function.Predicate;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R6.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftMagicNumbers;

public class CraftChunkSnapshot
implements ChunkSnapshot {
    private final int x;
    private final int z;
    private final int minHeight;
    private final int maxHeight;
    private final int seaLevel;
    private final String worldname;
    private final emd<ejm>[] blockids;
    private final byte[][] skylight;
    private final byte[][] emitlight;
    private final boolean[] empty;
    private final epp hmap;
    private final long captureFulltime;
    private final emf<jk<dst>>[] biome;

    CraftChunkSnapshot(int x2, int z2, int minHeight, int maxHeight, int seaLevel, String wname, long wtime, emd<ejm>[] sectionBlockIDs, byte[][] sectionSkyLights, byte[][] sectionEmitLights, boolean[] sectionEmpty, epp hmap, emf<jk<dst>>[] biome) {
        this.x = x2;
        this.z = z2;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.seaLevel = seaLevel;
        this.worldname = wname;
        this.captureFulltime = wtime;
        this.blockids = sectionBlockIDs;
        this.skylight = sectionSkyLights;
        this.emitlight = sectionEmitLights;
        this.empty = sectionEmpty;
        this.hmap = hmap;
        this.biome = biome;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public String getWorldName() {
        return this.worldname;
    }

    public boolean contains(BlockData block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        com.google.common.base.Predicate nms = Predicates.equalTo((Object)((CraftBlockData)block).getState());
        for (emd<ejm> palette : this.blockids) {
            if (!palette.a((Predicate<ejm>)nms)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Biome biome) {
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome cannot be null");
        com.google.common.base.Predicate nms = Predicates.equalTo(CraftBiome.bukkitToMinecraftHolder(biome));
        for (emf<jk<dst>> palette : this.biome) {
            if (!palette.a((Predicate<jk<dst>>)nms)) continue;
            return true;
        }
        return false;
    }

    public Material getBlockType(int x2, int y2, int z2) {
        this.validateChunkCoordinates(x2, y2, z2);
        return CraftBlockType.minecraftToBukkit(this.blockids[this.getSectionIndex(y2)].a(x2, y2 & 0xF, z2).b());
    }

    public final BlockData getBlockData(int x2, int y2, int z2) {
        this.validateChunkCoordinates(x2, y2, z2);
        return CraftBlockData.fromData(this.blockids[this.getSectionIndex(y2)].a(x2, y2 & 0xF, z2));
    }

    public final int getData(int x2, int y2, int z2) {
        this.validateChunkCoordinates(x2, y2, z2);
        return CraftMagicNumbers.toLegacyData(this.blockids[this.getSectionIndex(y2)].a(x2, y2 & 0xF, z2));
    }

    public final int getBlockSkyLight(int x2, int y2, int z2) {
        this.validateChunkCoordinates(x2, y2, z2);
        int off = (y2 & 0xF) << 7 | z2 << 3 | x2 >> 1;
        return this.skylight[this.getSectionIndex(y2)][off] >> ((x2 & 1) << 2) & 0xF;
    }

    public final int getBlockEmittedLight(int x2, int y2, int z2) {
        this.validateChunkCoordinates(x2, y2, z2);
        int off = (y2 & 0xF) << 7 | z2 << 3 | x2 >> 1;
        return this.emitlight[this.getSectionIndex(y2)][off] >> ((x2 & 1) << 2) & 0xF;
    }

    public final int getHighestBlockYAt(int x2, int z2) {
        Preconditions.checkState((this.hmap != null ? 1 : 0) != 0, (Object)"ChunkSnapshot created without height map. Please call getSnapshot with includeMaxblocky=true");
        this.validateChunkCoordinates(x2, 0, z2);
        return this.hmap.b(x2, z2);
    }

    public final Biome getBiome(int x2, int z2) {
        return this.getBiome(x2, 0, z2);
    }

    public final Biome getBiome(int x2, int y2, int z2) {
        Preconditions.checkState((this.biome != null ? 1 : 0) != 0, (Object)"ChunkSnapshot created without biome. Please call getSnapshot with includeBiome=true");
        this.validateChunkCoordinates(x2, y2, z2);
        emf<jk<dst>> biome = this.biome[this.getSectionIndex(y2)];
        return CraftBiome.minecraftHolderToBukkit(biome.a(x2 >> 2, (y2 & 0xF) >> 2, z2 >> 2));
    }

    public final double getRawBiomeTemperature(int x2, int z2) {
        return this.getRawBiomeTemperature(x2, 0, z2);
    }

    public final double getRawBiomeTemperature(int x2, int y2, int z2) {
        Preconditions.checkState((this.biome != null ? 1 : 0) != 0, (Object)"ChunkSnapshot created without biome. Please call getSnapshot with includeBiome=true");
        this.validateChunkCoordinates(x2, y2, z2);
        emf<jk<dst>> biome = this.biome[this.getSectionIndex(y2)];
        return biome.a(x2 >> 2, (y2 & 0xF) >> 2, z2 >> 2).a().f(new ja(this.x << 4 | x2, y2, this.z << 4 | z2), this.seaLevel);
    }

    public final long getCaptureFullTime() {
        return this.captureFulltime;
    }

    public final boolean isSectionEmpty(int sy2) {
        return this.empty[sy2];
    }

    private int getSectionIndex(int y2) {
        return y2 - this.minHeight >> 4;
    }

    private void validateChunkCoordinates(int x2, int y2, int z2) {
        CraftChunk.validateChunkCoordinates(this.minHeight, this.maxHeight, x2, y2, z2);
    }
}

