/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6;

import com.mojang.serialization.Codec;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.ban.ProfileBanList;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftStatistic;
import org.bukkit.craftbukkit.v1_21_R6.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.v1_21_R6.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.profile.PlayerProfile;

@SerializableAs(value="Player")
public class CraftOfflinePlayer
implements OfflinePlayer,
ConfigurationSerializable {
    private final bbb profile;
    private final CraftServer server;
    private final fik storage;

    protected CraftOfflinePlayer(CraftServer server, bbb profile) {
        this.server = server;
        this.profile = profile;
        this.storage = server.console.h;
    }

    public boolean isOnline() {
        return this.getPlayer() != null;
    }

    public String getName() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getName();
        }
        if (!this.profile.b().isEmpty()) {
            return this.profile.b();
        }
        fip data = this.getBukkitData();
        if (data != null) {
            return data.a("lastKnownName", (String)null);
        }
        return null;
    }

    public UUID getUniqueId() {
        return this.profile.a();
    }

    public PlayerProfile getPlayerProfile() {
        return new CraftPlayerProfile(this.profile);
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isOp() {
        return this.server.getHandle().f(this.profile);
    }

    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().d(this.profile);
        } else {
            this.server.getHandle().e(this.profile);
        }
    }

    public boolean isBanned() {
        return ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).isBanned((Object)this.getPlayerProfile());
    }

    public BanEntry<PlayerProfile> ban(String reason, Date expires, String source) {
        return ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).addBan(this.getPlayerProfile(), reason, expires, source);
    }

    public BanEntry<PlayerProfile> ban(String reason, Instant expires, String source) {
        return ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).addBan((Object)this.getPlayerProfile(), reason, expires, source);
    }

    public BanEntry<PlayerProfile> ban(String reason, Duration duration, String source) {
        return ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).addBan((Object)this.getPlayerProfile(), reason, duration, source);
    }

    public void setBanned(boolean value) {
        if (value) {
            ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).addBan(this.getPlayerProfile(), null, (Date)null, null);
        } else {
            ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).pardon((Object)this.getPlayerProfile());
        }
    }

    public boolean isWhitelisted() {
        return this.server.getHandle().i().a(this.profile);
    }

    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().i().a(new bbo(this.profile));
        } else {
            this.server.getHandle().i().b(this.profile);
        }
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("UUID", this.profile.a().toString());
        return result;
    }

    public static OfflinePlayer deserialize(Map<String, Object> args) {
        if (args.get("name") != null) {
            return Bukkit.getServer().getOfflinePlayer((String)args.get("name"));
        }
        return Bukkit.getServer().getOfflinePlayer(UUID.fromString((String)args.get("UUID")));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[UUID=" + String.valueOf(this.profile.a()) + "]";
    }

    public Player getPlayer() {
        return this.server.getPlayer(this.getUniqueId());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        if (this.getUniqueId() == null || other.getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(other.getUniqueId());
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.getUniqueId() != null ? this.getUniqueId().hashCode() : 0);
        return hash;
    }

    private fip getData() {
        return this.storage.a(this.profile).map(nbttagcompound -> fin.a(bfo.a, (jm.a)this.server.console.bg(), nbttagcompound)).get();
    }

    private fip getBukkitData() {
        fip result = this.getData();
        if (result != null) {
            result = result.b("bukkit");
        }
        return result;
    }

    private File getDataFile() {
        return new File(this.storage.getPlayerDir(), String.valueOf(this.getUniqueId()) + ".dat");
    }

    public long getFirstPlayed() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getFirstPlayed();
        }
        fip data = this.getBukkitData();
        if (data != null) {
            Optional<Long> firstPlayed = data.f("firstPlayed");
            if (firstPlayed.isPresent()) {
                return firstPlayed.get();
            }
            File file = this.getDataFile();
            return file.lastModified();
        }
        return 0L;
    }

    public long getLastPlayed() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLastPlayed();
        }
        fip data = this.getBukkitData();
        if (data != null) {
            Optional<Long> lastPlayed = data.f("lastPlayed");
            if (lastPlayed.isPresent()) {
                return lastPlayed.get();
            }
            File file = this.getDataFile();
            return file.lastModified();
        }
        return 0L;
    }

    public boolean hasPlayedBefore() {
        return this.getData() != null;
    }

    public Location getLastDeathLocation() {
        return this.getData().a("LastDeathLocation", jj.b).map(CraftMemoryMapper::fromNms).orElse(null);
    }

    public Location getLocation() {
        fip data = this.getData();
        if (data == null) {
            return null;
        }
        foh position = data.a("Pos", foh.a).orElse(null);
        fog rotation = data.a("Rotation", fog.i).orElse(null);
        if (position != null && rotation != null) {
            UUID uuid = new UUID(data.a("WorldUUIDMost", 0L), data.a("WorldUUIDLeast", 0L));
            return CraftLocation.toBukkit(position, this.server.getWorld(uuid), rotation.j, rotation.k);
        }
        return null;
    }

    public Location getBedSpawnLocation() {
        return this.getRespawnLocation();
    }

    public Location getRespawnLocation() {
        fip data = this.getData();
        if (data == null) {
            return null;
        }
        awy.a respawnConfig = data.a("respawn", awy.a.a).orElse(null);
        if (respawnConfig != null) {
            fid.a respawn = respawnConfig.a();
            awx world = this.server.getServer().a(respawn.a());
            if (world == null) {
                world = this.server.getServer().O();
            }
            return CraftLocation.toBukkit(respawn.b(), (World)world.getWorld(), respawn.d(), respawn.e());
        }
        if (data.a("SpawnX", Codec.INT).isPresent() && data.a("SpawnY", Codec.INT).isPresent() && data.a("SpawnZ", Codec.INT).isPresent()) {
            String spawnWorld = data.a("SpawnWorld", "");
            if (spawnWorld.equals("")) {
                spawnWorld = this.server.getWorlds().get(0).getName();
            }
            return new Location(this.server.getWorld(spawnWorld), (double)data.a("SpawnX", 0), (double)data.a("SpawnY", 0), (double)data.a("SpawnZ", 0));
        }
        return null;
    }

    public void setMetadata(String metadataKey, MetadataValue metadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, metadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin plugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, plugin);
    }

    private bck getStatisticManager() {
        return this.server.getHandle().getPlayerStats(this.getUniqueId(), this.getName());
    }

    public void incrementStatistic(Statistic statistic) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic);
        } else {
            bck manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, null);
            manager.a();
        }
    }

    public void decrementStatistic(Statistic statistic) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic);
        } else {
            bck manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, null);
            manager.a();
        }
    }

    public int getStatistic(Statistic statistic) {
        if (this.isOnline()) {
            return this.getPlayer().getStatistic(statistic);
        }
        return CraftStatistic.getStatistic(this.getStatisticManager(), statistic);
    }

    public void incrementStatistic(Statistic statistic, int amount) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, amount);
        } else {
            bck manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, amount, null);
            manager.a();
        }
    }

    public void decrementStatistic(Statistic statistic, int amount) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, amount);
        } else {
            bck manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, amount, null);
            manager.a();
        }
    }

    public void setStatistic(Statistic statistic, int newValue) {
        if (this.isOnline()) {
            this.getPlayer().setStatistic(statistic, newValue);
        } else {
            bck manager = this.getStatisticManager();
            CraftStatistic.setStatistic(manager, statistic, newValue, null);
            manager.a();
        }
    }

    public void incrementStatistic(Statistic statistic, Material material) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, material);
        } else {
            bck manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, material, null);
            manager.a();
        }
    }

    public void decrementStatistic(Statistic statistic, Material material) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, material);
        } else {
            bck manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, material, null);
            manager.a();
        }
    }

    public int getStatistic(Statistic statistic, Material material) {
        if (this.isOnline()) {
            return this.getPlayer().getStatistic(statistic, material);
        }
        return CraftStatistic.getStatistic(this.getStatisticManager(), statistic, material);
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, material, amount);
        } else {
            bck manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, material, amount, null);
            manager.a();
        }
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, material, amount);
        } else {
            bck manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, material, amount, null);
            manager.a();
        }
    }

    public void setStatistic(Statistic statistic, Material material, int newValue) {
        if (this.isOnline()) {
            this.getPlayer().setStatistic(statistic, material, newValue);
        } else {
            bck manager = this.getStatisticManager();
            CraftStatistic.setStatistic(manager, statistic, material, newValue, null);
            manager.a();
        }
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, entityType);
        } else {
            bck manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, entityType, null);
            manager.a();
        }
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, entityType);
        } else {
            bck manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, entityType, null);
            manager.a();
        }
    }

    public int getStatistic(Statistic statistic, EntityType entityType) {
        if (this.isOnline()) {
            return this.getPlayer().getStatistic(statistic, entityType);
        }
        return CraftStatistic.getStatistic(this.getStatisticManager(), statistic, entityType);
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, entityType, amount);
        } else {
            bck manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, entityType, amount, null);
            manager.a();
        }
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, entityType, amount);
        } else {
            bck manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, entityType, amount, null);
            manager.a();
        }
    }

    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        if (this.isOnline()) {
            this.getPlayer().setStatistic(statistic, entityType, newValue);
        } else {
            bck manager = this.getStatisticManager();
            CraftStatistic.setStatistic(manager, statistic, entityType, newValue, null);
            manager.a();
        }
    }
}

