/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.attribute;

import com.google.common.base.Preconditions;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R6.registry.CraftOldEnumRegistryItem;
import org.bukkit.craftbukkit.v1_21_R6.util.ApiVersion;
import org.jetbrains.annotations.NotNull;

public class CraftAttribute
extends CraftOldEnumRegistryItem<Attribute, cfx>
implements Attribute {
    private static int count = 0;

    public static Attribute minecraftToBukkit(cfx minecraft) {
        return (Attribute)CraftRegistry.minecraftToBukkit(minecraft, mp.c, Registry.ATTRIBUTE);
    }

    public static Attribute minecraftHolderToBukkit(jk<cfx> minecraft) {
        return CraftAttribute.minecraftToBukkit(minecraft.a());
    }

    public static Attribute stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        string = FieldRename.convertAttributeName(ApiVersion.CURRENT, string);
        string = string.toLowerCase(Locale.ROOT);
        NamespacedKey key = NamespacedKey.fromString((String)string);
        return (Attribute)CraftRegistry.get(Registry.ATTRIBUTE, key, ApiVersion.CURRENT);
    }

    public static cfx bukkitToMinecraft(Attribute bukkit) {
        return (cfx)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static jk<cfx> bukkitToMinecraftHolder(Attribute bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        jx registry = CraftRegistry.getMinecraftRegistry(mp.c);
        jk<cfx> jk2 = registry.e(CraftAttribute.bukkitToMinecraft(bukkit));
        if (jk2 instanceof jk.c) {
            jk.c holder = (jk.c)jk2;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own sound effect with out properly registering it.");
    }

    public static String bukkitToString(Attribute bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.getKey().toString();
    }

    public CraftAttribute(NamespacedKey key, jk<cfx> handle) {
        super(key, handle, count++);
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.getKeyOrThrow();
    }

    @NotNull
    public String getTranslationKey() {
        return ((cfx)this.getHandle()).c();
    }
}

