/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.DecoratedPot;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryDecoratedPot;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.inventory.DecoratedPotInventory;

public class CraftDecoratedPot
extends CraftBlockEntityState<egz>
implements DecoratedPot {
    public CraftDecoratedPot(World world, egz tileEntity) {
        super(world, tileEntity);
    }

    protected CraftDecoratedPot(CraftDecoratedPot state, Location location) {
        super(state, location);
    }

    public DecoratedPotInventory getSnapshotInventory() {
        return new CraftInventoryDecoratedPot((cbj)this.getSnapshot());
    }

    public DecoratedPotInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryDecoratedPot((cbj)this.getTileEntity());
    }

    public void setSherd(DecoratedPot.Side face, Material sherd) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        Preconditions.checkArgument((sherd == null || sherd == Material.BRICK || Tag.ITEMS_DECORATED_POT_SHERDS.isTagged((Keyed)sherd) ? 1 : 0) != 0, (String)"sherd is not a valid sherd material: %s", (Object)sherd);
        Optional<dhl> sherdItem = sherd != null ? Optional.of(CraftItemType.bukkitToMinecraft(sherd)) : Optional.of(dht.sx);
        ehq decorations = ((egz)this.getSnapshot()).m();
        switch (face) {
            case BACK: {
                ((egz)this.getSnapshot()).k = new ehq(sherdItem, decorations.c(), decorations.d(), decorations.e());
                break;
            }
            case LEFT: {
                ((egz)this.getSnapshot()).k = new ehq(decorations.b(), sherdItem, decorations.d(), decorations.e());
                break;
            }
            case RIGHT: {
                ((egz)this.getSnapshot()).k = new ehq(decorations.b(), decorations.c(), sherdItem, decorations.e());
                break;
            }
            case FRONT: {
                ((egz)this.getSnapshot()).k = new ehq(decorations.b(), decorations.c(), decorations.d(), sherdItem);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf(face));
            }
        }
    }

    public Material getSherd(DecoratedPot.Side face) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        ehq decorations = ((egz)this.getSnapshot()).m();
        Optional<dhl> sherdItem = switch (face) {
            case DecoratedPot.Side.BACK -> decorations.b();
            case DecoratedPot.Side.LEFT -> decorations.c();
            case DecoratedPot.Side.RIGHT -> decorations.d();
            case DecoratedPot.Side.FRONT -> decorations.e();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(face));
        };
        return CraftItemType.minecraftToBukkit(sherdItem.orElse(dht.sx));
    }

    public Map<DecoratedPot.Side, Material> getSherds() {
        ehq decorations = ((egz)this.getSnapshot()).m();
        EnumMap<DecoratedPot.Side, Material> sherds = new EnumMap<DecoratedPot.Side, Material>(DecoratedPot.Side.class);
        sherds.put(DecoratedPot.Side.BACK, CraftItemType.minecraftToBukkit(decorations.b().orElse(dht.sx)));
        sherds.put(DecoratedPot.Side.LEFT, CraftItemType.minecraftToBukkit(decorations.c().orElse(dht.sx)));
        sherds.put(DecoratedPot.Side.RIGHT, CraftItemType.minecraftToBukkit(decorations.d().orElse(dht.sx)));
        sherds.put(DecoratedPot.Side.FRONT, CraftItemType.minecraftToBukkit(decorations.e().orElse(dht.sx)));
        return sherds;
    }

    public List<Material> getShards() {
        return ((egz)this.getSnapshot()).m().a().stream().map(CraftItemType::minecraftToBukkit).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public CraftDecoratedPot copy() {
        return new CraftDecoratedPot(this, null);
    }

    @Override
    public CraftDecoratedPot copy(Location location) {
        return new CraftDecoratedPot(this, location);
    }
}

