/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.type.Fire;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;

public final class CraftFire
extends CraftBlockData
implements Fire,
Ageable,
MultipleFacing {
    private static final ekm AGE = CraftFire.getInteger(dya.class, "age");
    private static final ekd[] FACES = new ekd[]{CraftFire.getBoolean(dya.class, "north", true), CraftFire.getBoolean(dya.class, "east", true), CraftFire.getBoolean(dya.class, "south", true), CraftFire.getBoolean(dya.class, "west", true), CraftFire.getBoolean(dya.class, "up", true), CraftFire.getBoolean(dya.class, "down", true)};

    public CraftFire() {
    }

    public CraftFire(ejm state) {
        super(state);
    }

    public int getAge() {
        return this.get(AGE);
    }

    public void setAge(int age2) {
        this.set(AGE, age2);
    }

    public int getMaximumAge() {
        return CraftFire.getMax(AGE);
    }

    public boolean hasFace(BlockFace face) {
        ekd state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + String.valueOf(face) + ". Check MultipleFacing.getAllowedFaces.");
        }
        return this.get(state);
    }

    public void setFace(BlockFace face, boolean has) {
        ekd state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + String.valueOf(face) + ". Check MultipleFacing.getAllowedFaces.");
        }
        this.set(state, has);
    }

    public Set<BlockFace> getFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i2 = 0; i2 < FACES.length; ++i2) {
            if (FACES[i2] == null || !this.get(FACES[i2]).booleanValue()) continue;
            faces.add((Object)BlockFace.values()[i2]);
        }
        return faces.build();
    }

    public Set<BlockFace> getAllowedFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i2 = 0; i2 < FACES.length; ++i2) {
            if (FACES[i2] == null) continue;
            faces.add((Object)BlockFace.values()[i2]);
        }
        return faces.build();
    }
}

