/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;

public class BukkitCommandWrapper
implements com.mojang.brigadier.Command<ej>,
Predicate<ej>,
SuggestionProvider<ej> {
    private final CraftServer server;
    private final Command command;

    public BukkitCommandWrapper(CraftServer server, Command command) {
        this.server = server;
        this.command = command;
    }

    public LiteralCommandNode<ej> register(CommandDispatcher<ej> dispatcher, String label) {
        return dispatcher.register((LiteralArgumentBuilder<ej>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)label).requires((Predicate)this)).executes((com.mojang.brigadier.Command)this)).then(RequiredArgumentBuilder.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)this).executes((com.mojang.brigadier.Command)this))));
    }

    @Override
    public boolean test(ej wrapper) {
        return this.command.testPermissionSilent(wrapper.getBukkitSender());
    }

    public int run(CommandContext<ej> context) throws CommandSyntaxException {
        CommandSender sender = ((ej)context.getSource()).getBukkitSender();
        try {
            return this.server.dispatchCommand(sender, context.getInput()) ? 1 : 0;
        }
        catch (CommandException ex2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "An internal error occurred while attempting to perform this command");
            this.server.getLogger().log(Level.SEVERE, null, ex2);
            return 0;
        }
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<ej> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        List<String> results = this.server.tabComplete(((ej)context.getSource()).getBukkitSender(), builder.getInput(), ((ej)context.getSource()).e(), ((ej)context.getSource()).d(), true);
        builder = builder.createOffset(builder.getInput().lastIndexOf(32) + 1);
        for (String s2 : results) {
            builder.suggest(s2);
        }
        return builder.buildFuture();
    }
}

