/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntityType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;

public class CraftEntitySnapshot
implements EntitySnapshot {
    private final up data;
    private final EntityType type;

    private CraftEntitySnapshot(up data, EntityType type) {
        this.data = data;
        this.type = type;
    }

    public EntityType getEntityType() {
        return this.type;
    }

    public Entity createEntity(World world) {
        cdv internal = this.createInternal(world);
        return internal.getBukkitEntity();
    }

    public Entity createEntity(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location has no world");
        cdv internal = this.createInternal(location.getWorld());
        internal.a_(location.getX(), location.getY(), location.getZ());
        return location.getWorld().addEntity((Entity)internal.getBukkitEntity());
    }

    public String getAsString() {
        return this.data.toString();
    }

    private cdv createInternal(World world) {
        awx nms = ((CraftWorld)world).getHandle();
        cdv internal = cee.a(this.data, (drq)nms, ced.r, Function.identity());
        if (internal == null) {
            internal = CraftEntityType.bukkitToMinecraft(this.type).a(nms, ced.r);
        }
        Preconditions.checkArgument((internal != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        fip val = fin.a(bfo.a, (jm.a)nms.L_(), this.data);
        internal.d(val);
        return internal;
    }

    public up getData() {
        return this.data;
    }

    public dkw<cee<?>> getEntityTag() {
        return dkw.a(CraftEntityType.bukkitToMinecraft(this.type), this.data);
    }

    public static CraftEntitySnapshot create(CraftEntity entity) {
        fio tag = fio.a(bfo.a, entity.getHandle().ej());
        if (!entity.getHandle().saveAsPassenger(tag, false)) {
            return null;
        }
        return new CraftEntitySnapshot(tag.b(), entity.getType());
    }

    public static CraftEntitySnapshot create(up tag, EntityType type) {
        if (tag == null || tag.j() || type == null) {
            return null;
        }
        return new CraftEntitySnapshot(tag, type);
    }

    public static CraftEntitySnapshot create(up tag) {
        EntityType type = tag.a("id", cee.a).map(CraftEntityType::minecraftToBukkit).orElse(null);
        return CraftEntitySnapshot.create(tag, type);
    }

    public static CraftEntitySnapshot create(dkw<cee<?>> tag) {
        return CraftEntitySnapshot.create(tag.c(), CraftEntityType.minecraftToBukkit(tag.a()));
    }
}

