/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftMonster;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.LivingEntity;

public class CraftGuardian
extends CraftMonster
implements Guardian {
    private static final int MINIMUM_ATTACK_TICKS = -10;

    public CraftGuardian(CraftServer server, cwj entity) {
        super(server, entity);
    }

    @Override
    public cwj getHandle() {
        return (cwj)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftGuardian";
    }

    @Override
    public void setTarget(LivingEntity target) {
        super.setTarget(target);
        if (target == null) {
            this.getHandle().b(0);
        }
    }

    public boolean setLaser(boolean activated) {
        if (activated) {
            CraftLivingEntity target = this.getTarget();
            if (target == null) {
                return false;
            }
            this.getHandle().b(target.getEntityId());
        } else {
            this.getHandle().b(0);
        }
        return true;
    }

    public boolean hasLaser() {
        return this.getHandle().gJ();
    }

    public int getLaserDuration() {
        return this.getHandle().m();
    }

    public void setLaserTicks(int ticks) {
        Preconditions.checkArgument((ticks >= -10 ? 1 : 0) != 0, (String)"ticks must be >= %s. Given %s", (int)-10, (int)ticks);
        cwj.a goal = this.getHandle().guardianAttackGoal;
        if (goal != null) {
            goal.b = ticks;
        }
    }

    public int getLaserTicks() {
        cwj.a goal = this.getHandle().guardianAttackGoal;
        return goal != null ? goal.b : -10;
    }

    public boolean isElder() {
        return false;
    }

    public void setElder(boolean shouldBeElder) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean isMoving() {
        return this.getHandle().gI();
    }
}

