/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Sniffer;

public class CraftSniffer
extends CraftAnimals
implements Sniffer {
    public CraftSniffer(CraftServer server, ctx entity) {
        super(server, entity);
    }

    @Override
    public ctx getHandle() {
        return (ctx)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftSniffer";
    }

    public Collection<Location> getExploredLocations() {
        return this.getHandle().ha().map(blockPosition -> CraftLocation.toBukkit(blockPosition.b(), this.server.getServer().a(blockPosition.a()))).collect(Collectors.toList());
    }

    public void removeExploredLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        if (location.getWorld() != this.getWorld()) {
            return;
        }
        ja blockPosition = CraftLocation.toBlockPosition(location);
        this.getHandle().eq().a(cnz.aU, this.getHandle().ha().filter(blockPositionExplored -> !blockPositionExplored.equals(blockPosition)).collect(Collectors.toList()));
    }

    public void addExploredLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        if (location.getWorld() != this.getWorld()) {
            return;
        }
        this.getHandle().i(CraftLocation.toBlockPosition(location));
    }

    public Sniffer.State getState() {
        return this.stateToBukkit(this.getHandle().gV());
    }

    public void setState(Sniffer.State state) {
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)"state cannot be null");
        this.getHandle().a(this.stateToNMS(state));
    }

    public Location findPossibleDigLocation() {
        return this.getHandle().gK().map(blockPosition -> CraftLocation.toBukkit(blockPosition, this.getLocation().getWorld())).orElse(null);
    }

    public boolean canDig() {
        return this.getHandle().gL();
    }

    private ctx.a stateToNMS(Sniffer.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case Sniffer.State.IDLING -> ctx.a.a;
            case Sniffer.State.FEELING_HAPPY -> ctx.a.b;
            case Sniffer.State.SCENTING -> ctx.a.c;
            case Sniffer.State.SNIFFING -> ctx.a.d;
            case Sniffer.State.SEARCHING -> ctx.a.e;
            case Sniffer.State.DIGGING -> ctx.a.f;
            case Sniffer.State.RISING -> ctx.a.g;
        };
    }

    private Sniffer.State stateToBukkit(ctx.a state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case ctx.a.a -> Sniffer.State.IDLING;
            case ctx.a.b -> Sniffer.State.FEELING_HAPPY;
            case ctx.a.c -> Sniffer.State.SCENTING;
            case ctx.a.d -> Sniffer.State.SNIFFING;
            case ctx.a.e -> Sniffer.State.SEARCHING;
            case ctx.a.f -> Sniffer.State.DIGGING;
            case ctx.a.g -> Sniffer.State.RISING;
        };
    }
}

