/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R6.inventory.SerializableMeta;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BundleMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaBundle
extends CraftMetaItem
implements BundleMeta {
    static final CraftMetaItem.ItemMetaKeyType<djt> ITEMS = new CraftMetaItem.ItemMetaKeyType<djt>(kp.Q, "items");
    private List<ItemStack> items;

    CraftMetaBundle(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaBundle)) {
            return;
        }
        CraftMetaBundle bundle = (CraftMetaBundle)meta;
        if (bundle.hasItems()) {
            this.items = new ArrayList<ItemStack>(bundle.items);
        }
    }

    CraftMetaBundle(kn tag) {
        super(tag);
        CraftMetaBundle.getOrEmpty(tag, ITEMS).ifPresent(bundle -> bundle.c().forEach(item -> {
            CraftItemStack itemStack = CraftItemStack.asCraftMirror(item);
            if (!itemStack.getType().isAir()) {
                this.addItem(itemStack);
            }
        }));
    }

    CraftMetaBundle(Map<String, Object> map) {
        super(map);
        Iterable items = SerializableMeta.getObject(Iterable.class, map, CraftMetaBundle.ITEMS.BUKKIT, true);
        if (items != null) {
            for (Object stack : items) {
                ItemStack itemStack;
                if (!(stack instanceof ItemStack) || (itemStack = (ItemStack)stack).getType().isAir()) continue;
                this.addItem(itemStack);
            }
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        if (this.hasItems()) {
            ArrayList<dhp> list = new ArrayList<dhp>();
            for (ItemStack item : this.items) {
                list.add(CraftItemStack.asNMSCopy(item));
            }
            tag.put(ITEMS, new djt(list));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isBundleEmpty();
    }

    boolean isBundleEmpty() {
        return !this.hasItems();
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public List<ItemStack> getItems() {
        return this.items == null ? ImmutableList.of() : ImmutableList.copyOf(this.items);
    }

    public void setItems(List<ItemStack> items) {
        this.items = null;
        if (items == null) {
            return;
        }
        for (ItemStack i2 : items) {
            this.addItem(i2);
        }
    }

    public void addItem(ItemStack item) {
        Preconditions.checkArgument((item != null && !item.getType().isAir() ? 1 : 0) != 0, (Object)"item is null or air");
        if (this.items == null) {
            this.items = new ArrayList<ItemStack>();
        }
        this.items.add(item);
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaBundle) {
            CraftMetaBundle that = (CraftMetaBundle)meta;
            return this.hasItems() ? that.hasItems() && this.items.equals(that.items) : !that.hasItems();
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBundle || this.isBundleEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasItems()) {
            hash = 61 * hash + this.items.hashCode();
        }
        return original != hash ? CraftMetaBundle.class.hashCode() ^ hash : hash;
    }

    @Override
    public CraftMetaBundle clone() {
        return (CraftMetaBundle)super.clone();
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasItems()) {
            builder.put((Object)CraftMetaBundle.ITEMS.BUKKIT, this.items);
        }
        return builder;
    }
}

