/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R6.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftSound;
import org.bukkit.craftbukkit.v1_21_R6.Overridden;
import org.bukkit.craftbukkit.v1_21_R6.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R6.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemFlag;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaArmor;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaArmorStand;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaAxolotlBucket;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaBundle;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaCompass;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaCrossbow;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaEntityTag;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaKnowledgeBook;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaMusicInstrument;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaOminousBottle;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaShield;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaSpawnEgg;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaSuspiciousStew;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaTropicalFishBucket;
import org.bukkit.craftbukkit.v1_21_R6.inventory.ItemMetaKey;
import org.bukkit.craftbukkit.v1_21_R6.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R6.inventory.components.CraftBlocksAttacksComponent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.components.CraftCustomModelDataComponent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.components.CraftEquippableComponent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.components.CraftFoodComponent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.components.CraftJukeboxComponent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.components.CraftToolComponent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.components.CraftUseCooldownComponent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.components.CraftWeaponComponent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.components.consumable.CraftConsumableComponent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.tags.DeprecatedCustomTagContainer;
import org.bukkit.craftbukkit.v1_21_R6.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R6.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R6.tag.CraftDamageTag;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNBTTagConfigSerializer;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.components.BlocksAttacksComponent;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.inventory.meta.components.JukeboxPlayableComponent;
import org.bukkit.inventory.meta.components.ToolComponent;
import org.bukkit.inventory.meta.components.UseCooldownComponent;
import org.bukkit.inventory.meta.components.WeaponComponent;
import org.bukkit.inventory.meta.components.consumable.ConsumableComponent;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.tag.DamageTypeTags;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaItem
implements ItemMeta,
Damageable,
Repairable,
BlockDataMeta {
    static final ItemMetaKeyType<xx> NAME = new ItemMetaKeyType<xx>(kp.g, "display-name");
    static final ItemMetaKeyType<xx> ITEM_NAME = new ItemMetaKeyType<xx>(kp.h, "item-name");
    static final ItemMetaKeyType<dkj> LORE = new ItemMetaKeyType<dkj>(kp.j, "lore");
    static final ItemMetaKeyType<djz> CUSTOM_MODEL_DATA = new ItemMetaKeyType<djz>(kp.p, "custom-model-data");
    static final ItemMetaKeyType<doc> ENCHANTABLE = new ItemMetaKeyType<doc>(kp.C, "enchantable");
    static final ItemMetaKeyType<dok> ENCHANTMENTS = new ItemMetaKeyType<dok>(kp.l, "enchants");
    static final ItemMetaKeyType<Integer> REPAIR = new ItemMetaKeyType<Integer>(kp.r, "repair-cost");
    static final ItemMetaKeyType<dkh> ATTRIBUTES = new ItemMetaKeyType<dkh>(kp.o, "attribute-modifiers");
    static final ItemMetaKey ATTRIBUTES_IDENTIFIER = new ItemMetaKey("AttributeName");
    static final ItemMetaKey ATTRIBUTES_SLOT = new ItemMetaKey("Slot");
    static final ItemMetaKeyType<dku> HIDEFLAGS = new ItemMetaKeyType<dku>(kp.q, "ItemFlags");
    static final ItemMetaKey HIDE_TOOLTIP = new ItemMetaKey("hide-tool-tip");
    static final ItemMetaKeyType<amj> TOOLTIP_STYLE = new ItemMetaKeyType<amj>(kp.G, "tool-tip-style");
    static final ItemMetaKeyType<amj> ITEM_MODEL = new ItemMetaKeyType<amj>(kp.i, "item-model");
    static final ItemMetaKeyType<bgq> UNBREAKABLE = new ItemMetaKeyType<bgq>(kp.f, "Unbreakable");
    static final ItemMetaKeyType<Boolean> ENCHANTMENT_GLINT_OVERRIDE = new ItemMetaKeyType<Boolean>(kp.t, "enchantment-glint-override");
    static final ItemMetaKeyType<bgq> GLIDER = new ItemMetaKeyType<bgq>(kp.F, "glider");
    static final ItemMetaKeyType<dka> DAMAGE_RESISTANT = new ItemMetaKeyType<dka>(kp.z, "damage-resistant");
    static final ItemMetaKeyType<Integer> MAX_STACK_SIZE = new ItemMetaKeyType<Integer>(kp.c, "max-stack-size");
    static final ItemMetaKeyType<dil> RARITY = new ItemMetaKeyType<dil>(kp.k, "rarity");
    static final ItemMetaKeyType<dky> USE_REMAINDER = new ItemMetaKeyType<dky>(kp.x, "use-remainder");
    static final ItemMetaKeyType<dkx> USE_COOLDOWN = new ItemMetaKeyType<dkx>(kp.y, "use-cooldown");
    static final ItemMetaKeyType<ddd> FOOD = new ItemMetaKeyType<ddd>(kp.v, "food");
    static final ItemMetaKeyType<djv> CONSUMABLE = new ItemMetaKeyType<djv>(kp.w, "consumable");
    static final ItemMetaKeyType<dkt> TOOL = new ItemMetaKeyType<dkt>(kp.A, "tool");
    static final ItemMetaKeyType<djr> BLOCKS_ATTACKS = new ItemMetaKeyType<djr>(kp.I, "blocks-attacks");
    static final ItemMetaKeyType<dkz> WEAPON = new ItemMetaKeyType<dkz>(kp.B, "weapon");
    static final ItemMetaKeyType<dqa> EQUIPPABLE = new ItemMetaKeyType<dqa>(kp.D, "equippable");
    static final ItemMetaKeyType<dhu> JUKEBOX_PLAYABLE = new ItemMetaKeyType<dhu>(kp.ae, "jukebox-playable");
    static final ItemMetaKeyType<jk<bcd>> BREAK_SOUND = new ItemMetaKeyType<jk<bcd>>(kp.au, "break-sound");
    static final ItemMetaKeyType<Integer> DAMAGE = new ItemMetaKeyType<Integer>(kp.e, "Damage");
    static final ItemMetaKeyType<Integer> MAX_DAMAGE = new ItemMetaKeyType<Integer>(kp.d, "max-damage");
    static final ItemMetaKeyType<djq> BLOCK_DATA = new ItemMetaKeyType<djq>(kp.aq, "BlockStateTag");
    static final ItemMetaKey BUKKIT_CUSTOM_TAG = new ItemMetaKey("PublicBukkitValues");
    static final ItemMetaKeyType<djy> CUSTOM_DATA = new ItemMetaKeyType<djy>(kp.b);
    private xx displayName;
    private xx itemName;
    private List<xx> lore;
    private CraftCustomModelDataComponent customModelData;
    private Integer enchantableValue;
    private Map<String, String> blockData;
    private Map<Enchantment, Integer> enchantments;
    private Multimap<Attribute, AttributeModifier> attributeModifiers;
    private int repairCost;
    private SequencedSet<ko<?>> hiddenComponents;
    private boolean hideTooltip;
    private NamespacedKey tooltipStyle;
    private NamespacedKey itemModel;
    private boolean unbreakable;
    private Boolean enchantmentGlintOverride;
    private boolean glider;
    private bdj<cck> damageResistant;
    private Integer maxStackSize;
    private ItemRarity rarity;
    private ItemStack useRemainder;
    private CraftUseCooldownComponent useCooldown;
    private CraftFoodComponent food;
    private CraftConsumableComponent consumable;
    private CraftToolComponent tool;
    private CraftBlocksAttacksComponent blocksAttacks;
    private CraftWeaponComponent weapon;
    private CraftEquippableComponent equippable;
    private CraftJukeboxComponent jukebox;
    private jk<bcd> breakSound;
    private int damage;
    private Integer maxDamage;
    private static final Set<ko> HANDLED_TAGS = Sets.newHashSet();
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private up customTag;
    protected kn.a unhandledTags = kn.a();
    private Set<ko<?>> removedTags = Sets.newHashSet();
    private CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private int version = CraftMagicNumbers.INSTANCE.getDataVersion();

    CraftMetaItem(CraftMetaItem meta) {
        if (meta == null) {
            return;
        }
        this.displayName = meta.displayName;
        this.itemName = meta.itemName;
        if (meta.lore != null) {
            this.lore = new ArrayList<xx>(meta.lore);
        }
        if (meta.hasCustomModelDataComponent()) {
            this.customModelData = new CraftCustomModelDataComponent(meta.customModelData);
        }
        this.enchantableValue = meta.enchantableValue;
        this.blockData = meta.blockData;
        if (meta.enchantments != null) {
            this.enchantments = new LinkedHashMap<Enchantment, Integer>(meta.enchantments);
        }
        if (meta.hasAttributeModifiers()) {
            this.attributeModifiers = LinkedHashMultimap.create(meta.attributeModifiers);
        }
        this.repairCost = meta.repairCost;
        if (meta.hasItemFlags()) {
            this.hiddenComponents = new LinkedHashSet(meta.hiddenComponents);
        }
        this.hideTooltip = meta.hideTooltip;
        this.tooltipStyle = meta.tooltipStyle;
        this.itemModel = meta.itemModel;
        this.unbreakable = meta.unbreakable;
        this.enchantmentGlintOverride = meta.enchantmentGlintOverride;
        this.glider = meta.glider;
        this.damageResistant = meta.damageResistant;
        this.maxStackSize = meta.maxStackSize;
        this.rarity = meta.rarity;
        if (meta.hasUseRemainder()) {
            this.useRemainder = meta.useRemainder.clone();
        }
        if (meta.hasUseCooldown()) {
            this.useCooldown = new CraftUseCooldownComponent(meta.useCooldown);
        }
        if (meta.hasFood()) {
            this.food = new CraftFoodComponent(meta.food);
        }
        if (meta.hasConsumable()) {
            this.consumable = new CraftConsumableComponent(meta.consumable);
        }
        if (meta.hasTool()) {
            this.tool = new CraftToolComponent(meta.tool);
        }
        if (meta.hasBlocksAttacks()) {
            this.blocksAttacks = new CraftBlocksAttacksComponent(meta.blocksAttacks);
        }
        if (meta.hasWeapon()) {
            this.weapon = new CraftWeaponComponent(meta.weapon);
        }
        if (meta.hasEquippable()) {
            this.equippable = new CraftEquippableComponent(meta.equippable);
        }
        if (meta.hasJukeboxPlayable()) {
            this.jukebox = new CraftJukeboxComponent(meta.jukebox);
        }
        this.breakSound = this.breakSound;
        this.damage = meta.damage;
        this.maxDamage = meta.maxDamage;
        this.unhandledTags.copy(meta.unhandledTags.a());
        this.removedTags.addAll(meta.removedTags);
        this.persistentDataContainer.putAll(meta.persistentDataContainer.getRaw());
        this.customTag = meta.customTag;
        this.version = meta.version;
    }

    CraftMetaItem(kn tag) {
        CraftMetaItem.getOrEmpty(tag, NAME).ifPresent(component -> {
            this.displayName = component;
        });
        CraftMetaItem.getOrEmpty(tag, ITEM_NAME).ifPresent(component -> {
            this.itemName = component;
        });
        CraftMetaItem.getOrEmpty(tag, LORE).ifPresent(l2 -> {
            List<xx> list = l2.a();
            this.lore = new ArrayList<xx>(list.size());
            for (int index = 0; index < list.size(); ++index) {
                xx line = list.get(index);
                this.lore.add(line);
            }
        });
        CraftMetaItem.getOrEmpty(tag, CUSTOM_MODEL_DATA).ifPresent(i2 -> {
            this.customModelData = new CraftCustomModelDataComponent((djz)i2);
        });
        CraftMetaItem.getOrEmpty(tag, ENCHANTABLE).ifPresent(i2 -> {
            this.enchantableValue = i2.a();
        });
        CraftMetaItem.getOrEmpty(tag, BLOCK_DATA).ifPresent(t2 -> {
            this.blockData = t2.b();
        });
        CraftMetaItem.getOrEmpty(tag, ENCHANTMENTS).ifPresent(en2 -> {
            this.enchantments = CraftMetaItem.buildEnchantments(en2);
        });
        CraftMetaItem.getOrEmpty(tag, ATTRIBUTES).ifPresent(en2 -> {
            this.attributeModifiers = CraftMetaItem.buildModifiers(en2);
        });
        CraftMetaItem.getOrEmpty(tag, REPAIR).ifPresent(i2 -> {
            this.repairCost = i2;
        });
        CraftMetaItem.getOrEmpty(tag, HIDEFLAGS).ifPresent(h2 -> {
            for (ko ko2 : h2.b()) {
                ItemFlag flag = CraftItemFlag.nmsToBukkit(ko2);
                if (flag == null) continue;
                this.addItemFlags(flag);
            }
            this.hideTooltip = h2.a();
        });
        CraftMetaItem.getOrEmpty(tag, TOOLTIP_STYLE).ifPresent(key -> {
            this.tooltipStyle = CraftNamespacedKey.fromMinecraft(key);
        });
        CraftMetaItem.getOrEmpty(tag, ITEM_MODEL).ifPresent(key -> {
            this.itemModel = CraftNamespacedKey.fromMinecraft(key);
        });
        CraftMetaItem.getOrEmpty(tag, UNBREAKABLE).ifPresent(u2 -> {
            this.unbreakable = true;
        });
        CraftMetaItem.getOrEmpty(tag, ENCHANTMENT_GLINT_OVERRIDE).ifPresent(override -> {
            this.enchantmentGlintOverride = override;
        });
        CraftMetaItem.getOrEmpty(tag, GLIDER).ifPresent(u2 -> {
            this.glider = true;
        });
        CraftMetaItem.getOrEmpty(tag, DAMAGE_RESISTANT).ifPresent(tags -> {
            this.damageResistant = tags.a();
        });
        CraftMetaItem.getOrEmpty(tag, MAX_STACK_SIZE).ifPresent(i2 -> {
            this.maxStackSize = i2;
        });
        CraftMetaItem.getOrEmpty(tag, RARITY).ifPresent(enumItemRarity -> {
            this.rarity = ItemRarity.valueOf((String)enumItemRarity.name());
        });
        CraftMetaItem.getOrEmpty(tag, USE_REMAINDER).ifPresent(remainder -> {
            this.useRemainder = CraftItemStack.asCraftMirror(remainder.a());
        });
        CraftMetaItem.getOrEmpty(tag, USE_COOLDOWN).ifPresent(cooldown -> {
            this.useCooldown = new CraftUseCooldownComponent((dkx)cooldown);
        });
        CraftMetaItem.getOrEmpty(tag, FOOD).ifPresent(foodInfo -> {
            this.food = new CraftFoodComponent((ddd)foodInfo);
        });
        CraftMetaItem.getOrEmpty(tag, CONSUMABLE).ifPresent(consumableInfo -> {
            this.consumable = new CraftConsumableComponent((djv)consumableInfo);
        });
        CraftMetaItem.getOrEmpty(tag, TOOL).ifPresent(toolInfo -> {
            this.tool = new CraftToolComponent((dkt)toolInfo);
        });
        CraftMetaItem.getOrEmpty(tag, BLOCKS_ATTACKS).ifPresent(blocksInfo -> {
            this.blocksAttacks = new CraftBlocksAttacksComponent((djr)blocksInfo);
        });
        CraftMetaItem.getOrEmpty(tag, WEAPON).ifPresent(weaponInfo -> {
            this.weapon = new CraftWeaponComponent((dkz)weaponInfo);
        });
        CraftMetaItem.getOrEmpty(tag, EQUIPPABLE).ifPresent(equippableInfo -> {
            this.equippable = new CraftEquippableComponent((dqa)equippableInfo);
        });
        CraftMetaItem.getOrEmpty(tag, JUKEBOX_PLAYABLE).ifPresent(jukeboxPlayable -> {
            this.jukebox = new CraftJukeboxComponent((dhu)jukeboxPlayable);
        });
        CraftMetaItem.getOrEmpty(tag, BREAK_SOUND).ifPresent(sound -> {
            this.breakSound = sound;
        });
        CraftMetaItem.getOrEmpty(tag, DAMAGE).ifPresent(i2 -> {
            this.damage = i2;
        });
        CraftMetaItem.getOrEmpty(tag, MAX_DAMAGE).ifPresent(i2 -> {
            this.maxDamage = i2;
        });
        CraftMetaItem.getOrEmpty(tag, CUSTOM_DATA).ifPresent(customData -> {
            this.customTag = customData.b();
            this.customTag.m(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT).ifPresent(compound -> {
                Set<String> keys = compound.e();
                for (String key : keys) {
                    this.persistentDataContainer.put(key, compound.a(key).d());
                }
                this.customTag.r(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT);
            });
            if (this.customTag.j()) {
                this.customTag = null;
            }
        });
        Set<Map.Entry<ko<?>, Optional<?>>> keys = tag.b();
        for (Map.Entry<ko<?>, Optional<?>> key2 : keys) {
            if (!CraftMetaItem.getHandledTags().contains(key2.getKey())) {
                key2.getValue().ifPresent(value -> this.unhandledTags.a((ko)key2.getKey(), value));
            }
            if (!key2.getValue().isEmpty()) continue;
            this.removedTags.add(key2.getKey());
        }
    }

    static Map<Enchantment, Integer> buildEnchantments(dok tag) {
        LinkedHashMap<Enchantment, Integer> enchantments = new LinkedHashMap<Enchantment, Integer>(tag.c());
        tag.b().forEach(entry -> {
            jk id2 = (jk)entry.getKey();
            int level = entry.getIntValue();
            Enchantment enchant = CraftEnchantment.minecraftHolderToBukkit(id2);
            if (enchant != null) {
                enchantments.put(enchant, level);
            }
        });
        return enchantments;
    }

    static Multimap<Attribute, AttributeModifier> buildModifiers(dkh tag) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        List<dkh.c> mods = tag.b();
        int size = mods.size();
        for (int i2 = 0; i2 < size; ++i2) {
            dkh.c entry = mods.get(i2);
            cga nmsModifier = entry.b();
            if (nmsModifier == null) continue;
            AttributeModifier attribMod = CraftAttributeInstance.convert(nmsModifier);
            Attribute attribute = CraftAttribute.minecraftHolderToBukkit(entry.a());
            if (attribute == null) continue;
            if (entry.c() != null) {
                ceg slotName = entry.c();
                if (slotName == null) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                EquipmentSlotGroup slot = null;
                try {
                    slot = CraftEquipmentSlot.getSlot(slotName);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (slot == null) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                attribMod = new AttributeModifier(attribMod.getKey(), attribMod.getAmount(), attribMod.getOperation(), slot);
            }
            modifiers.put((Object)attribute, (Object)attribMod);
        }
        return modifiers;
    }

    CraftMetaItem(Map<String, Object> map) {
        String custom;
        Object nbtMap;
        Iterable removed;
        String unhandled;
        String internal;
        Integer maxDamage;
        Integer damage;
        String snd;
        CraftJukeboxComponent jukeboxPlayable;
        CraftEquippableComponent equippable;
        CraftWeaponComponent weapon;
        CraftBlocksAttacksComponent blocksAttacks;
        CraftToolComponent tool;
        CraftConsumableComponent consumable;
        CraftFoodComponent food;
        CraftUseCooldownComponent cooldown;
        ItemStack remainder;
        String rarity;
        Integer maxStackSize;
        Tag tag;
        String damageResistant;
        Boolean glider;
        Boolean enchantmentGlintOverride;
        Boolean unbreakable;
        String itemModel;
        String tooltipStyle;
        Boolean bl2;
        Iterable hideFlags;
        Object blockData;
        Object customModelData;
        this.displayName = CraftChatMessage.fromJSONOrString(SerializableMeta.getString(map, CraftMetaItem.NAME.BUKKIT, true), true, false);
        this.itemName = CraftChatMessage.fromJSONOrNull(SerializableMeta.getString(map, CraftMetaItem.ITEM_NAME.BUKKIT, true));
        Iterable lore = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.LORE.BUKKIT, true);
        if (lore != null) {
            this.lore = new ArrayList<xx>();
            CraftMetaItem.safelyAdd(lore, this.lore, true);
        }
        if ((customModelData = SerializableMeta.getObject(Object.class, map, CraftMetaItem.CUSTOM_MODEL_DATA.BUKKIT, true)) instanceof CustomModelDataComponent) {
            CustomModelDataComponent component = (CustomModelDataComponent)customModelData;
            this.setCustomModelDataComponent(component);
        } else {
            this.setCustomModelData((Integer)customModelData);
        }
        Integer enchantmentValue = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.ENCHANTABLE.BUKKIT, true);
        if (enchantmentValue != null) {
            this.setEnchantable(enchantmentValue);
        }
        if ((blockData = SerializableMeta.getObject(Object.class, map, CraftMetaItem.BLOCK_DATA.BUKKIT, true)) != null) {
            HashMap<String, String> mapBlockData = new HashMap<String, String>();
            if (blockData instanceof Map) {
                for (Map.Entry entry : ((Map)blockData).entrySet()) {
                    mapBlockData.put(entry.getKey().toString(), entry.getValue().toString());
                }
            } else {
                up nbtBlockData = (up)CraftNBTTagConfigSerializer.deserialize(blockData);
                for (String key : nbtBlockData.e()) {
                    mapBlockData.put(key, nbtBlockData.b(key, ""));
                }
            }
            this.blockData = mapBlockData;
        }
        this.enchantments = CraftMetaItem.buildEnchantments(map, ENCHANTMENTS);
        this.attributeModifiers = CraftMetaItem.buildModifiers(map, ATTRIBUTES);
        Integer repairCost = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.REPAIR.BUKKIT, true);
        if (repairCost != null) {
            this.setRepairCost(repairCost);
        }
        if ((hideFlags = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.HIDEFLAGS.BUKKIT, true)) != null) {
            for (Object hideFlagObject : hideFlags) {
                String hideFlagString = (String)hideFlagObject;
                try {
                    ItemFlag hideFlatEnum = CraftItemFlag.stringToBukkit(hideFlagString);
                    this.addItemFlags(hideFlatEnum);
                }
                catch (IllegalArgumentException hideFlatEnum) {}
            }
        }
        if ((bl2 = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.HIDE_TOOLTIP.BUKKIT, true)) != null) {
            this.setHideTooltip(bl2);
        }
        if ((tooltipStyle = SerializableMeta.getString(map, CraftMetaItem.TOOLTIP_STYLE.BUKKIT, true)) != null) {
            this.setTooltipStyle(NamespacedKey.fromString((String)tooltipStyle));
        }
        if ((itemModel = SerializableMeta.getString(map, CraftMetaItem.ITEM_MODEL.BUKKIT, true)) != null) {
            this.setItemModel(NamespacedKey.fromString((String)itemModel));
        }
        if ((unbreakable = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.UNBREAKABLE.BUKKIT, true)) != null) {
            this.setUnbreakable(unbreakable);
        }
        if ((enchantmentGlintOverride = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.BUKKIT, true)) != null) {
            this.setEnchantmentGlintOverride(enchantmentGlintOverride);
        }
        if ((glider = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.GLIDER.BUKKIT, true)) != null) {
            this.setGlider(glider);
        }
        if ((damageResistant = SerializableMeta.getString(map, CraftMetaItem.DAMAGE_RESISTANT.BUKKIT, true)) != null && (tag = Bukkit.getTag((String)"damage_types", (NamespacedKey)NamespacedKey.fromString((String)damageResistant), DamageType.class)) != null) {
            this.setDamageResistant((Tag<DamageType>)tag);
        }
        if ((maxStackSize = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.MAX_STACK_SIZE.BUKKIT, true)) != null) {
            this.setMaxStackSize(maxStackSize);
        }
        if ((rarity = SerializableMeta.getString(map, CraftMetaItem.RARITY.BUKKIT, true)) != null) {
            this.setRarity(ItemRarity.valueOf((String)rarity));
        }
        if ((remainder = SerializableMeta.getObject(ItemStack.class, map, CraftMetaItem.USE_REMAINDER.BUKKIT, true)) != null) {
            this.setUseRemainder(remainder);
        }
        if ((cooldown = SerializableMeta.getObject(CraftUseCooldownComponent.class, map, CraftMetaItem.USE_COOLDOWN.BUKKIT, true)) != null) {
            this.setUseCooldown(cooldown);
        }
        if ((food = SerializableMeta.getObject(CraftFoodComponent.class, map, CraftMetaItem.FOOD.BUKKIT, true)) != null) {
            this.setFood(food);
        }
        if ((consumable = SerializableMeta.getObject(CraftConsumableComponent.class, map, CraftMetaItem.CONSUMABLE.BUKKIT, true)) != null) {
            this.setConsumable(consumable);
        }
        if ((tool = SerializableMeta.getObject(CraftToolComponent.class, map, CraftMetaItem.TOOL.BUKKIT, true)) != null) {
            this.setTool(tool);
        }
        if ((blocksAttacks = SerializableMeta.getObject(CraftBlocksAttacksComponent.class, map, CraftMetaItem.BLOCKS_ATTACKS.BUKKIT, true)) != null) {
            this.setBlocksAttacks(blocksAttacks);
        }
        if ((weapon = SerializableMeta.getObject(CraftWeaponComponent.class, map, CraftMetaItem.WEAPON.BUKKIT, true)) != null) {
            this.setWeapon(weapon);
        }
        if ((equippable = SerializableMeta.getObject(CraftEquippableComponent.class, map, CraftMetaItem.EQUIPPABLE.BUKKIT, true)) != null) {
            this.setEquippable(equippable);
        }
        if ((jukeboxPlayable = SerializableMeta.getObject(CraftJukeboxComponent.class, map, CraftMetaItem.JUKEBOX_PLAYABLE.BUKKIT, true)) != null) {
            this.setJukeboxPlayable(jukeboxPlayable);
        }
        if ((snd = SerializableMeta.getString(map, "break-sound", true)) != null) {
            this.setBreakSound((Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)snd)));
        }
        if ((damage = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.DAMAGE.BUKKIT, true)) != null) {
            this.setDamage(damage);
        }
        if ((maxDamage = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.MAX_DAMAGE.BUKKIT, true)) != null) {
            this.setMaxDamage(maxDamage);
        }
        if ((internal = SerializableMeta.getString(map, "internal", true)) != null) {
            ByteArrayInputStream buf2 = new ByteArrayInputStream(Base64.getDecoder().decode(internal));
            try {
                up internalTag = vc.a(buf2, uy.a());
                this.deserializeInternal(internalTag, map);
            }
            catch (IOException ex2) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex2);
            }
        }
        if ((unhandled = SerializableMeta.getString(map, "unhandled", true)) != null) {
            ByteArrayInputStream buf3 = new ByteArrayInputStream(Base64.getDecoder().decode(unhandled));
            try {
                up unhandledTag = vc.a(buf3, uy.a());
                kn unhandledPatch = (kn)kn.b.parse(MinecraftServer.getDefaultRegistryAccess().a(vd.a), (Object)unhandledTag).result().get();
                this.unhandledTags.copy(unhandledPatch);
                for (Map.Entry entry : unhandledPatch.b()) {
                    if (((Optional)entry.getValue()).isPresent()) continue;
                    ko key = (ko)entry.getKey();
                    this.unhandledTags.clear(key);
                    this.removedTags.add(key);
                }
            }
            catch (IOException ex3) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex3);
            }
        }
        if ((removed = SerializableMeta.getObject(Iterable.class, map, "removed", true)) != null) {
            jy registryAccess = CraftRegistry.getMinecraftRegistry();
            jx<ko<?>> componentTypeRegistry = registryAccess.f(mp.r);
            for (Object t2 : removed) {
                String removedString = (String)t2;
                ko<?> component = componentTypeRegistry.a(amj.a(removedString));
                if (component == null) continue;
                this.removedTags.add(component);
            }
        }
        if ((nbtMap = SerializableMeta.getObject(Object.class, map, CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, true)) != null) {
            this.persistentDataContainer.putAll((up)CraftNBTTagConfigSerializer.deserialize(nbtMap));
        }
        if ((custom = SerializableMeta.getString(map, "custom", true)) != null) {
            ByteArrayInputStream buf4 = new ByteArrayInputStream(Base64.getDecoder().decode(custom));
            try {
                this.customTag = vc.a(buf4, uy.a());
            }
            catch (IOException iOException) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    void deserializeInternal(up tag, Object context) {
        tag.o(CraftMetaItem.ATTRIBUTES.NBT).ifPresent(ignore -> {
            this.attributeModifiers = CraftMetaItem.buildModifiersLegacy(tag, ATTRIBUTES);
        });
    }

    private static Multimap<Attribute, AttributeModifier> buildModifiersLegacy(up tag, ItemMetaKey key) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        uv mods = tag.p(key.NBT);
        int size = mods.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Attribute attribute;
            cga nmsModifier;
            up entry = mods.b(i2);
            if (entry.j() || (nmsModifier = (cga)entry.a(cga.a).orElse(null)) == null) continue;
            AttributeModifier attribMod = CraftAttributeInstance.convert(nmsModifier);
            String attributeName = entry.b(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT, null);
            if (attributeName == null || attributeName.isEmpty() || (attribute = CraftAttribute.stringToBukkit(attributeName)) == null) continue;
            String slotName = entry.b(CraftMetaItem.ATTRIBUTES_SLOT.NBT, null);
            if (slotName == null || slotName.isEmpty()) {
                modifiers.put((Object)attribute, (Object)attribMod);
                continue;
            }
            EquipmentSlot slot = null;
            try {
                slot = CraftEquipmentSlot.getSlot(cef.a(slotName.toLowerCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (slot == null) {
                modifiers.put((Object)attribute, (Object)attribMod);
                continue;
            }
            attribMod = new AttributeModifier(attribMod.getKey(), attribMod.getAmount(), attribMod.getOperation(), slot.getGroup());
            modifiers.put((Object)attribute, (Object)attribMod);
        }
        return modifiers;
    }

    static Map<Enchantment, Integer> buildEnchantments(Map<String, Object> map, ItemMetaKey key) {
        Map ench = SerializableMeta.getObject(Map.class, map, key.BUKKIT, true);
        if (ench == null) {
            return null;
        }
        LinkedHashMap<Enchantment, Integer> enchantments = new LinkedHashMap<Enchantment, Integer>(ench.size());
        for (Map.Entry entry : ench.entrySet()) {
            Enchantment enchantment = CraftEnchantment.stringToBukkit(entry.getKey().toString());
            if (enchantment == null || !(entry.getValue() instanceof Integer)) continue;
            enchantments.put(enchantment, (Integer)entry.getValue());
        }
        return enchantments;
    }

    static Multimap<Attribute, AttributeModifier> buildModifiers(Map<String, Object> map, ItemMetaKey key) {
        Map mods = SerializableMeta.getObject(Map.class, map, key.BUKKIT, true);
        LinkedHashMultimap result = LinkedHashMultimap.create();
        if (mods == null) {
            return result;
        }
        for (Object obj : mods.keySet()) {
            String attributeName;
            if (!(obj instanceof String) || Strings.isNullOrEmpty((String)(attributeName = (String)obj))) continue;
            List list = SerializableMeta.getObject(List.class, mods, attributeName, true);
            if (list == null || list.isEmpty()) {
                return result;
            }
            for (Object o2 : list) {
                if (!(o2 instanceof AttributeModifier)) continue;
                AttributeModifier modifier = (AttributeModifier)o2;
                Attribute attribute = CraftAttribute.stringToBukkit(attributeName);
                if (attribute == null) continue;
                result.put((Object)attribute, (Object)modifier);
            }
        }
        return result;
    }

    @Overridden
    void applyToItem(Applicator itemTag) {
        up customTag;
        if (this.hasDisplayName()) {
            itemTag.put(NAME, this.displayName);
        }
        if (this.hasItemName()) {
            itemTag.put(ITEM_NAME, this.itemName);
        }
        if (this.lore != null) {
            itemTag.put(LORE, new dkj(this.lore));
        }
        if (this.hasCustomModelDataComponent()) {
            itemTag.put(CUSTOM_MODEL_DATA, this.customModelData.getHandle());
        }
        if (this.hasEnchantable()) {
            itemTag.put(ENCHANTABLE, new doc(this.enchantableValue));
        }
        if (this.hasBlockData()) {
            itemTag.put(BLOCK_DATA, new djq(this.blockData));
        }
        if (this.hiddenComponents != null || this.hideTooltip) {
            Iterator<ko<?>> hidden = this.hiddenComponents != null ? this.hiddenComponents : new LinkedHashSet();
            itemTag.put(HIDEFLAGS, new dku(this.hideTooltip, (SequencedSet<ko<?>>)((Object)hidden)));
        }
        this.applyEnchantments(this.enchantments, itemTag, ENCHANTMENTS, ItemFlag.HIDE_ENCHANTS);
        this.applyModifiers(this.attributeModifiers, itemTag);
        if (this.hasRepairCost()) {
            itemTag.put(REPAIR, this.repairCost);
        }
        if (this.hasTooltipStyle()) {
            itemTag.put(TOOLTIP_STYLE, CraftNamespacedKey.toMinecraft(this.getTooltipStyle()));
        }
        if (this.hasItemModel()) {
            itemTag.put(ITEM_MODEL, CraftNamespacedKey.toMinecraft(this.getItemModel()));
        }
        if (this.isUnbreakable()) {
            itemTag.put(UNBREAKABLE, bgq.a);
        }
        if (this.hasEnchantmentGlintOverride()) {
            itemTag.put(ENCHANTMENT_GLINT_OVERRIDE, this.getEnchantmentGlintOverride());
        }
        if (this.isGlider()) {
            itemTag.put(GLIDER, bgq.a);
        }
        if (this.hasDamageResistant()) {
            itemTag.put(DAMAGE_RESISTANT, new dka(this.damageResistant));
        }
        if (this.hasMaxStackSize()) {
            itemTag.put(MAX_STACK_SIZE, this.maxStackSize);
        }
        if (this.hasRarity()) {
            itemTag.put(RARITY, dil.valueOf(this.rarity.name()));
        }
        if (this.hasUseRemainder()) {
            itemTag.put(USE_REMAINDER, new dky(CraftItemStack.asNMSCopy(this.useRemainder)));
        }
        if (this.hasUseCooldown()) {
            itemTag.put(USE_COOLDOWN, this.useCooldown.getHandle());
        }
        if (this.hasFood()) {
            itemTag.put(FOOD, this.food.getHandle());
        }
        if (this.hasConsumable()) {
            itemTag.put(CONSUMABLE, this.consumable.getHandle());
        }
        if (this.hasTool()) {
            itemTag.put(TOOL, this.tool.getHandle());
        }
        if (this.hasBlocksAttacks()) {
            itemTag.put(BLOCKS_ATTACKS, this.blocksAttacks.getHandle());
        }
        if (this.hasWeapon()) {
            itemTag.put(WEAPON, this.weapon.getHandle());
        }
        if (this.hasEquippable()) {
            itemTag.put(EQUIPPABLE, this.equippable.getHandle());
        }
        if (this.hasJukeboxPlayable()) {
            itemTag.put(JUKEBOX_PLAYABLE, this.jukebox.getHandle());
        }
        if (this.hasBreakSound()) {
            itemTag.put(BREAK_SOUND, this.breakSound);
        }
        if (this.hasDamage()) {
            itemTag.put(DAMAGE, this.damage);
        }
        if (this.hasMaxDamage()) {
            itemTag.put(MAX_DAMAGE, this.maxDamage);
        }
        for (Map.Entry entry : this.unhandledTags.a().b()) {
            ((Optional)entry.getValue()).ifPresent(value -> itemTag.builder.a((ko)e2.getKey(), value));
        }
        for (ko<?> ko2 : this.removedTags) {
            if (itemTag.builder.isSet(ko2)) continue;
            itemTag.builder.a(ko2);
        }
        up up2 = customTag = this.customTag != null ? this.customTag.l() : null;
        if (!this.persistentDataContainer.isEmpty()) {
            up up3 = new up();
            Map<String, vp> rawPublicMap = this.persistentDataContainer.getRaw();
            for (Map.Entry<String, vp> nbtBaseEntry : rawPublicMap.entrySet()) {
                up3.a(nbtBaseEntry.getKey(), nbtBaseEntry.getValue());
            }
            if (customTag == null) {
                customTag = new up();
            }
            customTag.a(CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, up3);
        }
        if (customTag != null) {
            itemTag.put(CUSTOM_DATA, djy.a(customTag));
        }
    }

    void applyEnchantments(Map<Enchantment, Integer> enchantments, Applicator tag, ItemMetaKeyType<dok> key, ItemFlag itemFlag) {
        if (enchantments == null && !this.hasItemFlag(itemFlag)) {
            return;
        }
        dok.a list = new dok.a(dok.a);
        if (enchantments != null) {
            for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
                list.a(CraftEnchantment.bukkitToMinecraftHolder(entry.getKey()), entry.getValue());
            }
        }
        tag.put(key, list.b());
    }

    void applyModifiers(Multimap<Attribute, AttributeModifier> modifiers, Applicator tag) {
        if (modifiers == null || modifiers.isEmpty()) {
            return;
        }
        dkh.a list = dkh.a();
        for (Map.Entry entry : modifiers.entries()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            cga nmsModifier = CraftAttributeInstance.convert((AttributeModifier)entry.getValue());
            jk<cfx> name = CraftAttribute.bukkitToMinecraftHolder((Attribute)entry.getKey());
            if (name == null) continue;
            ceg group = CraftEquipmentSlot.getNMSGroup(((AttributeModifier)entry.getValue()).getSlotGroup());
            list.a(name, nmsModifier, group);
        }
        tag.put(ATTRIBUTES, list.a());
    }

    boolean applicableTo(Material type) {
        if (type == Material.AIR || !type.isItem()) {
            return false;
        }
        if (this.getClass() == CraftMetaItem.class) {
            return true;
        }
        return type.asItemType().getItemMetaClass() == this.getClass().getInterfaces()[0];
    }

    @Overridden
    boolean isEmpty() {
        return !this.hasDisplayName() && !this.hasItemName() && !this.hasLocalizedName() && !this.hasEnchants() && this.lore == null && !this.hasCustomModelDataComponent() && !this.hasEnchantable() && !this.hasBlockData() && !this.hasRepairCost() && this.unhandledTags.a().d() && this.removedTags.isEmpty() && this.persistentDataContainer.isEmpty() && !this.hasItemFlags() && !this.isHideTooltip() && !this.hasTooltipStyle() && !this.hasItemModel() && !this.isUnbreakable() && !this.hasEnchantmentGlintOverride() && !this.isGlider() && !this.hasDamageResistant() && !this.hasMaxStackSize() && !this.hasRarity() && !this.hasUseRemainder() && !this.hasUseCooldown() && !this.hasFood() && !this.hasConsumable() && !this.hasTool() && !this.hasBlocksAttacks() && !this.hasWeapon() && !this.hasJukeboxPlayable() && !this.hasBreakSound() && !this.hasEquippable() && !this.hasDamage() && !this.hasMaxDamage() && !this.hasAttributeModifiers() && this.customTag == null;
    }

    public String getDisplayName() {
        return CraftChatMessage.fromComponent(this.displayName);
    }

    public final void setDisplayName(String name) {
        this.displayName = CraftChatMessage.fromStringOrNull(name);
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public String getItemName() {
        return CraftChatMessage.fromComponent(this.itemName);
    }

    public final void setItemName(String name) {
        this.itemName = CraftChatMessage.fromStringOrNull(name);
    }

    public boolean hasItemName() {
        return this.itemName != null;
    }

    public String getLocalizedName() {
        return this.getDisplayName();
    }

    public void setLocalizedName(String name) {
    }

    public boolean hasLocalizedName() {
        return false;
    }

    public boolean hasLore() {
        return this.lore != null && !this.lore.isEmpty();
    }

    public boolean hasRepairCost() {
        return this.repairCost > 0;
    }

    public boolean hasEnchant(Enchantment ench) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        return this.hasEnchants() && this.enchantments.containsKey(ench);
    }

    public int getEnchantLevel(Enchantment ench) {
        Integer level;
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        Integer n2 = level = this.hasEnchants() ? this.enchantments.get(ench) : null;
        if (level == null) {
            return 0;
        }
        return level;
    }

    public Map<Enchantment, Integer> getEnchants() {
        return this.hasEnchants() ? ImmutableMap.copyOf(this.enchantments) : ImmutableMap.of();
    }

    public boolean addEnchant(Enchantment ench, int level, boolean ignoreRestrictions) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        if (this.enchantments == null) {
            this.enchantments = new LinkedHashMap<Enchantment, Integer>(4);
        }
        if (ignoreRestrictions || level >= ench.getStartLevel() && level <= ench.getMaxLevel()) {
            Integer old = this.enchantments.put(ench, level);
            return old == null || old != level;
        }
        return false;
    }

    public boolean removeEnchant(Enchantment ench) {
        boolean enchantmentRemoved;
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        boolean bl2 = enchantmentRemoved = this.hasEnchants() && this.enchantments.remove(ench) != null;
        if (enchantmentRemoved && this.enchantments.isEmpty()) {
            this.enchantments = null;
        }
        return enchantmentRemoved;
    }

    public void removeEnchantments() {
        if (this.hasEnchants()) {
            this.enchantments.clear();
        }
    }

    public boolean hasEnchants() {
        return this.enchantments != null && !this.enchantments.isEmpty();
    }

    public boolean hasConflictingEnchant(Enchantment ench) {
        return CraftMetaItem.checkConflictingEnchants(this.enchantments, ench);
    }

    public void addItemFlags(ItemFlag ... hideFlags) {
        for (ItemFlag f2 : hideFlags) {
            Collection<ko<?>> nms = CraftItemFlag.bukkitToNMS(f2);
            if (nms == null) continue;
            if (this.hiddenComponents == null) {
                this.hiddenComponents = new LinkedHashSet();
            }
            this.hiddenComponents.addAll(nms);
        }
    }

    public void removeItemFlags(ItemFlag ... hideFlags) {
        if (this.hiddenComponents == null) {
            return;
        }
        for (ItemFlag f2 : hideFlags) {
            Collection<ko<?>> nms = CraftItemFlag.bukkitToNMS(f2);
            if (nms == null) continue;
            this.hiddenComponents.removeAll(nms);
        }
    }

    public Set<ItemFlag> getItemFlags() {
        EnumSet<ItemFlag> currentFlags = EnumSet.noneOf(ItemFlag.class);
        for (ItemFlag f2 : ItemFlag.values()) {
            if (!this.hasItemFlag(f2)) continue;
            currentFlags.add(f2);
        }
        return currentFlags;
    }

    public boolean hasItemFlag(ItemFlag flag) {
        Collection<ko<?>> nms = CraftItemFlag.bukkitToNMS(flag);
        return nms != null && this.hiddenComponents != null && this.hiddenComponents.containsAll(nms);
    }

    public boolean hasItemFlags() {
        return this.hiddenComponents != null && !this.hiddenComponents.isEmpty();
    }

    public List<String> getLore() {
        return this.lore == null ? null : new ArrayList(Lists.transform(this.lore, CraftChatMessage::fromComponent));
    }

    public void setLore(List<String> lore) {
        if (lore == null || lore.isEmpty()) {
            this.lore = null;
        } else {
            if (this.lore == null) {
                this.lore = new ArrayList<xx>(lore.size());
            } else {
                this.lore.clear();
            }
            CraftMetaItem.safelyAdd(lore, this.lore, false);
        }
    }

    public boolean hasCustomModelData() {
        if (this.customModelData != null) {
            List<Float> floats = this.customModelData.getFloats();
            return !floats.isEmpty();
        }
        return false;
    }

    public int getCustomModelData() {
        Preconditions.checkState((boolean)this.hasCustomModelData(), (Object)"We don't have CustomModelData! Check hasCustomModelData first!");
        return this.customModelData.getFloats().get(0).intValue();
    }

    public boolean hasCustomModelDataComponent() {
        return this.customModelData != null;
    }

    public CustomModelDataComponent getCustomModelDataComponent() {
        return this.hasCustomModelDataComponent() ? new CraftCustomModelDataComponent(this.customModelData) : new CraftCustomModelDataComponent(new djz(List.of(), List.of(), List.of(), List.of()));
    }

    public void setCustomModelData(Integer data) {
        this.customModelData = data == null ? null : new CraftCustomModelDataComponent(new djz(List.of(Float.valueOf(data.floatValue())), List.of(), List.of(), List.of()));
    }

    public void setCustomModelDataComponent(CustomModelDataComponent customModelData) {
        this.customModelData = customModelData == null ? null : new CraftCustomModelDataComponent((CraftCustomModelDataComponent)customModelData);
    }

    public boolean hasEnchantable() {
        return this.enchantableValue != null;
    }

    public int getEnchantable() {
        Preconditions.checkState((boolean)this.hasEnchantable(), (Object)"We don't have Enchantable! Check hasEnchantable first!");
        return this.enchantableValue;
    }

    public void setEnchantable(Integer data) {
        this.enchantableValue = data;
    }

    public boolean hasBlockData() {
        return this.blockData != null;
    }

    public BlockData getBlockData(Material material) {
        ejm defaultData = CraftBlockType.bukkitToMinecraft(material).m();
        return CraftBlockData.fromData(this.hasBlockData() ? new djq(this.blockData).a(defaultData) : defaultData);
    }

    public void setBlockData(BlockData blockData) {
        this.blockData = blockData == null ? null : ((CraftBlockData)blockData).toStates(true);
    }

    public int getRepairCost() {
        return this.repairCost;
    }

    public void setRepairCost(int cost) {
        this.repairCost = cost;
    }

    public boolean isHideTooltip() {
        return this.hideTooltip;
    }

    public void setHideTooltip(boolean hideTooltip) {
        this.hideTooltip = hideTooltip;
    }

    public boolean hasTooltipStyle() {
        return this.tooltipStyle != null;
    }

    public NamespacedKey getTooltipStyle() {
        return this.tooltipStyle;
    }

    public void setTooltipStyle(NamespacedKey tooltipStyle) {
        this.tooltipStyle = tooltipStyle;
    }

    public boolean hasItemModel() {
        return this.itemModel != null;
    }

    public NamespacedKey getItemModel() {
        return this.itemModel;
    }

    public void setItemModel(NamespacedKey itemModel) {
        this.itemModel = itemModel;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    public boolean hasEnchantmentGlintOverride() {
        return this.enchantmentGlintOverride != null;
    }

    public Boolean getEnchantmentGlintOverride() {
        Preconditions.checkState((boolean)this.hasEnchantmentGlintOverride(), (Object)"We don't have enchantment_glint_override! Check hasEnchantmentGlintOverride first!");
        return this.enchantmentGlintOverride;
    }

    public void setEnchantmentGlintOverride(Boolean override) {
        this.enchantmentGlintOverride = override;
    }

    public boolean isGlider() {
        return this.glider;
    }

    public void setGlider(boolean glider) {
        this.glider = glider;
    }

    public boolean isFireResistant() {
        return this.hasDamageResistant() && DamageTypeTags.IS_FIRE.equals(this.getDamageResistant());
    }

    public void setFireResistant(boolean fireResistant) {
        this.setDamageResistant((Tag<DamageType>)DamageTypeTags.IS_FIRE);
    }

    public boolean hasDamageResistant() {
        return this.damageResistant != null;
    }

    public Tag<DamageType> getDamageResistant() {
        return this.hasDamageResistant() ? Bukkit.getTag((String)"damage_types", (NamespacedKey)CraftNamespacedKey.fromMinecraft(this.damageResistant.b()), DamageType.class) : null;
    }

    public void setDamageResistant(Tag<DamageType> tag) {
        this.damageResistant = tag != null ? ((CraftDamageTag)tag).getHandle().h() : null;
    }

    public boolean hasMaxStackSize() {
        return this.maxStackSize != null;
    }

    public int getMaxStackSize() {
        Preconditions.checkState((boolean)this.hasMaxStackSize(), (Object)"We don't have max_stack_size! Check hasMaxStackSize first!");
        return this.maxStackSize;
    }

    public void setMaxStackSize(Integer max) {
        Preconditions.checkArgument((max == null || max > 0 ? 1 : 0) != 0, (Object)"max_stack_size must be > 0");
        Preconditions.checkArgument((max == null || max <= 99 ? 1 : 0) != 0, (Object)"max_stack_size must be <= 99");
        this.maxStackSize = max;
    }

    public boolean hasRarity() {
        return this.rarity != null;
    }

    public ItemRarity getRarity() {
        Preconditions.checkState((boolean)this.hasRarity(), (Object)"We don't have rarity! Check hasRarity first!");
        return this.rarity;
    }

    public void setRarity(ItemRarity rarity) {
        this.rarity = rarity;
    }

    public boolean hasUseRemainder() {
        return this.useRemainder != null;
    }

    public ItemStack getUseRemainder() {
        return this.useRemainder;
    }

    public void setUseRemainder(ItemStack useRemainder) {
        this.useRemainder = useRemainder;
    }

    public boolean hasUseCooldown() {
        return this.useCooldown != null;
    }

    public UseCooldownComponent getUseCooldown() {
        return this.hasUseCooldown() ? new CraftUseCooldownComponent(this.useCooldown) : new CraftUseCooldownComponent(new dkx(1.0f));
    }

    public void setUseCooldown(UseCooldownComponent cooldown) {
        this.useCooldown = cooldown == null ? null : new CraftUseCooldownComponent((CraftUseCooldownComponent)cooldown);
    }

    public boolean hasFood() {
        return this.food != null;
    }

    public FoodComponent getFood() {
        return this.hasFood() ? new CraftFoodComponent(this.food) : new CraftFoodComponent(new ddd(0, 0.0f, false));
    }

    public void setFood(FoodComponent food) {
        this.food = food == null ? null : new CraftFoodComponent((CraftFoodComponent)food);
    }

    public boolean hasConsumable() {
        return this.consumable != null;
    }

    public ConsumableComponent getConsumable() {
        return this.hasConsumable() ? new CraftConsumableComponent(this.consumable) : new CraftConsumableComponent(new djv(1.6f, dhr.b, bce.lv, true, List.of()));
    }

    public void setConsumable(ConsumableComponent consumable) {
        this.consumable = consumable == null ? null : new CraftConsumableComponent((CraftConsumableComponent)consumable);
    }

    public boolean hasTool() {
        return this.tool != null;
    }

    public ToolComponent getTool() {
        return this.hasTool() ? new CraftToolComponent(this.tool) : new CraftToolComponent(new dkt(Collections.emptyList(), 1.0f, 1, true));
    }

    public void setTool(ToolComponent tool) {
        this.tool = tool == null ? null : new CraftToolComponent((CraftToolComponent)tool);
    }

    public boolean hasBlocksAttacks() {
        return this.blocksAttacks != null;
    }

    public BlocksAttacksComponent getBlocksAttacks() {
        return this.hasBlocksAttacks() ? new CraftBlocksAttacksComponent(this.blocksAttacks) : new CraftBlocksAttacksComponent(new djr(0.0f, 1.0f, Collections.emptyList(), new djr.b(0.0f, 0.0f, 0.0f), Optional.empty(), Optional.empty(), Optional.empty()));
    }

    public void setBlocksAttacks(BlocksAttacksComponent blocksAttacks) {
        this.blocksAttacks = blocksAttacks == null ? null : new CraftBlocksAttacksComponent((CraftBlocksAttacksComponent)blocksAttacks);
    }

    public boolean hasWeapon() {
        return this.weapon != null;
    }

    public WeaponComponent getWeapon() {
        return this.hasWeapon() ? new CraftWeaponComponent(this.weapon) : new CraftWeaponComponent(new dkz(0));
    }

    public void setWeapon(WeaponComponent weapon) {
        this.weapon = weapon == null ? null : new CraftWeaponComponent((CraftWeaponComponent)weapon);
    }

    public boolean hasEquippable() {
        return this.equippable != null;
    }

    public EquippableComponent getEquippable() {
        return this.hasEquippable() ? new CraftEquippableComponent(this.equippable) : new CraftEquippableComponent(dqa.a(cef.f).a());
    }

    public void setEquippable(EquippableComponent equippable) {
        this.equippable = equippable == null ? null : new CraftEquippableComponent((CraftEquippableComponent)equippable);
    }

    public boolean hasJukeboxPlayable() {
        return this.jukebox != null;
    }

    public JukeboxPlayableComponent getJukeboxPlayable() {
        return this.hasJukeboxPlayable() ? new CraftJukeboxComponent(this.jukebox) : new CraftJukeboxComponent(new dhu(new dgq<dhv>(dhx.a)));
    }

    public void setJukeboxPlayable(JukeboxPlayableComponent jukeboxPlayable) {
        this.jukebox = jukeboxPlayable == null ? null : new CraftJukeboxComponent((CraftJukeboxComponent)jukeboxPlayable);
    }

    public boolean hasBreakSound() {
        return this.breakSound != null;
    }

    public Sound getBreakSound() {
        return this.breakSound != null ? CraftSound.minecraftHolderToBukkit(this.breakSound) : null;
    }

    public void setBreakSound(Sound sound) {
        this.breakSound = sound != null ? CraftSound.bukkitToMinecraftHolder(sound) : null;
    }

    public boolean hasAttributeModifiers() {
        return this.attributeModifiers != null && !this.attributeModifiers.isEmpty();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers() {
        return this.hasAttributeModifiers() ? ImmutableMultimap.copyOf(this.attributeModifiers) : null;
    }

    private void checkAttributeList() {
        if (this.attributeModifiers == null) {
            this.attributeModifiers = LinkedHashMultimap.create();
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nullable EquipmentSlot slot) {
        this.checkAttributeList();
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Map.Entry entry : this.attributeModifiers.entries()) {
            if (((AttributeModifier)entry.getValue()).getSlot() != null && ((AttributeModifier)entry.getValue()).getSlot() != slot) continue;
            result.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
        }
        return result;
    }

    public Collection<AttributeModifier> getAttributeModifiers(@Nonnull Attribute attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        return this.attributeModifiers.containsKey((Object)attribute) ? ImmutableList.copyOf((Collection)this.attributeModifiers.get((Object)attribute)) : null;
    }

    public boolean addAttributeModifier(@Nonnull Attribute attribute, @Nonnull AttributeModifier modifier) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        Preconditions.checkNotNull((Object)modifier, (Object)"AttributeModifier cannot be null");
        this.checkAttributeList();
        for (Map.Entry entry : this.attributeModifiers.entries()) {
            Preconditions.checkArgument((!((AttributeModifier)entry.getValue()).getKey().equals((Object)modifier.getKey()) ? 1 : 0) != 0, (String)"Cannot register AttributeModifier. Modifier is already applied! %s", (Object)modifier);
        }
        return this.attributeModifiers.put((Object)attribute, (Object)modifier);
    }

    public void setAttributeModifiers(@Nullable Multimap<Attribute, AttributeModifier> attributeModifiers) {
        if (attributeModifiers == null || attributeModifiers.isEmpty()) {
            this.attributeModifiers = LinkedHashMultimap.create();
            return;
        }
        this.checkAttributeList();
        this.attributeModifiers.clear();
        Iterator iterator = attributeModifiers.entries().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            if (next.getKey() == null || next.getValue() == null) {
                iterator.remove();
                continue;
            }
            this.attributeModifiers.put((Object)((Attribute)next.getKey()), (Object)((AttributeModifier)next.getValue()));
        }
    }

    public boolean removeAttributeModifier(@Nonnull Attribute attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        this.checkAttributeList();
        return !this.attributeModifiers.removeAll((Object)attribute).isEmpty();
    }

    public boolean removeAttributeModifier(@Nullable EquipmentSlot slot) {
        this.checkAttributeList();
        int removed = 0;
        Iterator iter = this.attributeModifiers.entries().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (((AttributeModifier)entry.getValue()).getSlot() != null && ((AttributeModifier)entry.getValue()).getSlot() != slot) continue;
            iter.remove();
            ++removed;
        }
        return removed > 0;
    }

    public boolean removeAttributeModifier(@Nonnull Attribute attribute, @Nonnull AttributeModifier modifier) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        Preconditions.checkNotNull((Object)modifier, (Object)"AttributeModifier cannot be null");
        this.checkAttributeList();
        int removed = 0;
        Iterator iter = this.attributeModifiers.entries().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (entry.getKey() == null || entry.getValue() == null) {
                iter.remove();
                ++removed;
                continue;
            }
            if (entry.getKey() != attribute || !((AttributeModifier)entry.getValue()).getKey().equals((Object)modifier.getKey())) continue;
            iter.remove();
            ++removed;
        }
        return removed > 0;
    }

    public String getAsString() {
        Applicator tag = new Applicator();
        this.applyToItem(tag);
        kn patch = tag.build();
        vp nbt = (vp)kn.b.encodeStart(MinecraftServer.getDefaultRegistryAccess().a(vd.a), (Object)patch).getOrThrow();
        return nbt.toString();
    }

    public String getAsComponentString() {
        Applicator tag = new Applicator();
        this.applyToItem(tag);
        kn patch = tag.build();
        jy registryAccess = CraftRegistry.getMinecraftRegistry();
        amh<vp> ops = registryAccess.a(vd.a);
        jx<ko<?>> componentTypeRegistry = registryAccess.f(mp.r);
        StringJoiner componentString = new StringJoiner(",", "[", "]");
        for (Map.Entry<ko<?>, Optional<?>> entry : patch.b()) {
            ko<?> componentType = entry.getKey();
            Optional<?> componentValue = entry.getValue();
            String componentKey = componentTypeRegistry.d(componentType).orElseThrow().a().toString();
            if (componentValue.isPresent()) {
                vp componentValueAsNBT = (vp)componentType.c().encodeStart(ops, componentValue.get()).getOrThrow();
                String componentValueAsNBTString = new vl("", 0, new ArrayList<String>()).a(componentValueAsNBT);
                componentString.add(componentKey + "=" + componentValueAsNBTString);
                continue;
            }
            componentString.add("!" + componentKey);
        }
        return componentString.toString();
    }

    public CustomItemTagContainer getCustomTagContainer() {
        return new DeprecatedCustomTagContainer(this.getPersistentDataContainer());
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    private static boolean compareModifiers(Multimap<Attribute, AttributeModifier> first, Multimap<Attribute, AttributeModifier> second) {
        if (first == null || second == null) {
            return false;
        }
        for (Map.Entry entry : first.entries()) {
            if (second.containsEntry(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        for (Map.Entry entry : second.entries()) {
            if (first.containsEntry(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean hasDamage() {
        return this.damage > 0;
    }

    public int getDamage() {
        return this.damage;
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public boolean hasMaxDamage() {
        return this.maxDamage != null;
    }

    public int getMaxDamage() {
        Preconditions.checkState((boolean)this.hasMaxDamage(), (Object)"We don't have max_damage! Check hasMaxDamage first!");
        return this.maxDamage;
    }

    public void setMaxDamage(Integer maxDamage) {
        this.maxDamage = maxDamage;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof CraftMetaItem)) {
            return false;
        }
        return CraftItemFactory.instance().equals((ItemMeta)this, (ItemMeta)object);
    }

    @Overridden
    boolean equalsCommon(CraftMetaItem that) {
        return (this.hasDisplayName() ? that.hasDisplayName() && this.displayName.equals(that.displayName) : !that.hasDisplayName()) && (this.hasItemName() ? that.hasItemName() && this.itemName.equals(that.itemName) : !that.hasItemName()) && (this.hasEnchants() ? that.hasEnchants() && this.enchantments.equals(that.enchantments) : !that.hasEnchants()) && Objects.equals(this.lore, that.lore) && (this.hasCustomModelDataComponent() ? that.hasCustomModelDataComponent() && this.customModelData.equals(that.customModelData) : !that.hasCustomModelDataComponent()) && (this.hasEnchantable() ? that.hasEnchantable() && this.enchantableValue.equals(that.enchantableValue) : !that.hasEnchantable()) && (this.hasBlockData() ? that.hasBlockData() && this.blockData.equals(that.blockData) : !that.hasBlockData()) && (this.hasRepairCost() ? that.hasRepairCost() && this.repairCost == that.repairCost : !that.hasRepairCost()) && (this.hasAttributeModifiers() ? that.hasAttributeModifiers() && CraftMetaItem.compareModifiers(this.attributeModifiers, that.attributeModifiers) : !that.hasAttributeModifiers()) && this.unhandledTags.equals(that.unhandledTags) && this.removedTags.equals(that.removedTags) && Objects.equals(this.customTag, that.customTag) && this.persistentDataContainer.equals(that.persistentDataContainer) && (this.hasItemFlags() ? that.hasItemFlags() && this.hiddenComponents.equals(that.hiddenComponents) : !that.hasItemFlags()) && this.isHideTooltip() == that.isHideTooltip() && (this.hasTooltipStyle() ? that.hasTooltipStyle() && this.tooltipStyle.equals((Object)that.tooltipStyle) : !that.hasTooltipStyle()) && (this.hasItemModel() ? that.hasItemModel() && this.itemModel.equals((Object)that.itemModel) : !that.hasItemModel()) && this.isUnbreakable() == that.isUnbreakable() && (this.hasEnchantmentGlintOverride() ? that.hasEnchantmentGlintOverride() && this.enchantmentGlintOverride.equals(that.enchantmentGlintOverride) : !that.hasEnchantmentGlintOverride()) && this.glider == that.glider && (this.hasDamageResistant() ? that.hasDamageResistant() && this.damageResistant.equals(that.damageResistant) : !that.hasDamageResistant()) && (this.hasMaxStackSize() ? that.hasMaxStackSize() && this.maxStackSize.equals(that.maxStackSize) : !that.hasMaxStackSize()) && this.rarity == that.rarity && (this.hasUseRemainder() ? that.hasUseRemainder() && this.useRemainder.equals((Object)that.useRemainder) : !that.hasUseRemainder()) && (this.hasUseCooldown() ? that.hasUseCooldown() && this.useCooldown.equals(that.useCooldown) : !that.hasUseCooldown()) && (this.hasFood() ? that.hasFood() && this.food.equals(that.food) : !that.hasFood()) && (this.hasConsumable() ? that.hasConsumable() && this.consumable.equals(that.consumable) : !that.hasConsumable()) && (this.hasTool() ? that.hasTool() && this.tool.equals(that.tool) : !that.hasTool()) && (this.hasBlocksAttacks() ? that.hasBlocksAttacks() && this.blocksAttacks.equals(that.blocksAttacks) : !that.hasBlocksAttacks()) && (this.hasWeapon() ? that.hasWeapon() && this.weapon.equals(that.weapon) : !that.hasWeapon()) && (this.hasEquippable() ? that.hasEquippable() && this.equippable.equals(that.equippable) : !that.hasEquippable()) && (this.hasJukeboxPlayable() ? that.hasJukeboxPlayable() && this.jukebox.equals(that.jukebox) : !that.hasJukeboxPlayable()) && (this.hasBreakSound() ? that.hasBreakSound() && this.breakSound.equals(that.breakSound) : !that.hasBreakSound()) && (this.hasDamage() ? that.hasDamage() && this.damage == that.damage : !that.hasDamage()) && (this.hasMaxDamage() ? that.hasMaxDamage() && this.maxDamage.equals(that.maxDamage) : !that.hasMaxDamage()) && this.version == that.version;
    }

    @Overridden
    boolean notUncommon(CraftMetaItem meta) {
        return true;
    }

    public final int hashCode() {
        return this.applyHash();
    }

    @Overridden
    int applyHash() {
        int hash = 3;
        hash = 61 * hash + (this.hasDisplayName() ? this.displayName.hashCode() : 0);
        hash = 61 * hash + (this.hasItemName() ? this.itemName.hashCode() : 0);
        hash = 61 * hash + (this.lore != null ? this.lore.hashCode() : 0);
        hash = 61 * hash + (this.hasCustomModelDataComponent() ? this.customModelData.hashCode() : 0);
        hash = 61 * hash + (this.hasEnchantable() ? this.enchantableValue.hashCode() : 0);
        hash = 61 * hash + (this.hasBlockData() ? this.blockData.hashCode() : 0);
        hash = 61 * hash + (this.hasEnchants() ? this.enchantments.hashCode() : 0);
        hash = 61 * hash + (this.hasRepairCost() ? this.repairCost : 0);
        hash = 61 * hash + this.unhandledTags.hashCode();
        hash = 61 * hash + this.removedTags.hashCode();
        hash = 61 * hash + (this.customTag != null ? this.customTag.hashCode() : 0);
        hash = 61 * hash + (!this.persistentDataContainer.isEmpty() ? this.persistentDataContainer.hashCode() : 0);
        hash = 61 * hash + (this.hasItemFlags() ? this.hiddenComponents.hashCode() : 0);
        hash = 61 * hash + (this.isHideTooltip() ? 1231 : 1237);
        hash = 61 * hash + (this.hasTooltipStyle() ? this.tooltipStyle.hashCode() : 0);
        hash = 61 * hash + (this.hasItemModel() ? this.itemModel.hashCode() : 0);
        hash = 61 * hash + (this.isUnbreakable() ? 1231 : 1237);
        hash = 61 * hash + (this.hasEnchantmentGlintOverride() ? this.enchantmentGlintOverride.hashCode() : 0);
        hash = 61 * hash + (this.isGlider() ? 1231 : 1237);
        hash = 61 * hash + (this.hasDamageResistant() ? this.damageResistant.hashCode() : 0);
        hash = 61 * hash + (this.hasMaxStackSize() ? this.maxStackSize.hashCode() : 0);
        hash = 61 * hash + (this.hasRarity() ? this.rarity.hashCode() : 0);
        hash = 61 * hash + (this.hasUseRemainder() ? this.useRemainder.hashCode() : 0);
        hash = 61 * hash + (this.hasUseCooldown() ? this.useCooldown.hashCode() : 0);
        hash = 61 * hash + (this.hasFood() ? this.food.hashCode() : 0);
        hash = 61 * hash + (this.hasConsumable() ? this.consumable.hashCode() : 0);
        hash = 61 * hash + (this.hasTool() ? this.tool.hashCode() : 0);
        hash = 61 * hash + (this.hasBlocksAttacks() ? this.blocksAttacks.hashCode() : 0);
        hash = 61 * hash + (this.hasWeapon() ? this.weapon.hashCode() : 0);
        hash = 61 * hash + (this.hasJukeboxPlayable() ? this.jukebox.hashCode() : 0);
        hash = 61 * hash + (this.hasBreakSound() ? this.breakSound.hashCode() : 0);
        hash = 61 * hash + (this.hasEquippable() ? this.equippable.hashCode() : 0);
        hash = 61 * hash + (this.hasDamage() ? this.damage : 0);
        hash = 61 * hash + (this.hasMaxDamage() ? 1231 : 1237);
        hash = 61 * hash + (this.hasAttributeModifiers() ? this.attributeModifiers.hashCode() : 0);
        hash = 61 * hash + this.version;
        return hash;
    }

    @Overridden
    public CraftMetaItem clone() {
        try {
            CraftMetaItem clone = (CraftMetaItem)super.clone();
            if (this.lore != null) {
                clone.lore = new ArrayList<xx>(this.lore);
            }
            if (this.hasCustomModelDataComponent()) {
                clone.customModelData = new CraftCustomModelDataComponent(this.customModelData);
            }
            clone.enchantableValue = this.enchantableValue;
            clone.blockData = this.blockData;
            if (this.enchantments != null) {
                clone.enchantments = new LinkedHashMap<Enchantment, Integer>(this.enchantments);
            }
            if (this.hasAttributeModifiers()) {
                clone.attributeModifiers = LinkedHashMultimap.create(this.attributeModifiers);
            }
            if (this.customTag != null) {
                clone.customTag = this.customTag.l();
            }
            clone.removedTags = Sets.newHashSet(this.removedTags);
            clone.persistentDataContainer = new CraftPersistentDataContainer(this.persistentDataContainer.getRaw(), DATA_TYPE_REGISTRY);
            if (this.hasItemFlags()) {
                clone.hiddenComponents = new LinkedHashSet(this.hiddenComponents);
            }
            clone.hideTooltip = this.hideTooltip;
            clone.tooltipStyle = this.tooltipStyle;
            clone.itemModel = this.itemModel;
            clone.unbreakable = this.unbreakable;
            clone.enchantmentGlintOverride = this.enchantmentGlintOverride;
            clone.glider = this.glider;
            clone.damageResistant = this.damageResistant;
            clone.maxStackSize = this.maxStackSize;
            clone.rarity = this.rarity;
            if (this.hasUseRemainder()) {
                clone.useRemainder = this.useRemainder.clone();
            }
            if (this.hasUseCooldown()) {
                clone.useCooldown = new CraftUseCooldownComponent(this.useCooldown);
            }
            if (this.hasFood()) {
                clone.food = new CraftFoodComponent(this.food);
            }
            if (this.hasConsumable()) {
                clone.consumable = new CraftConsumableComponent(this.consumable);
            }
            if (this.hasTool()) {
                clone.tool = new CraftToolComponent(this.tool);
            }
            if (this.hasBlocksAttacks()) {
                clone.blocksAttacks = new CraftBlocksAttacksComponent(this.blocksAttacks);
            }
            if (this.hasWeapon()) {
                clone.weapon = new CraftWeaponComponent(this.weapon);
            }
            if (this.hasEquippable()) {
                clone.equippable = new CraftEquippableComponent(this.equippable);
            }
            if (this.hasJukeboxPlayable()) {
                clone.jukebox = new CraftJukeboxComponent(this.jukebox);
            }
            clone.breakSound = this.breakSound;
            clone.damage = this.damage;
            clone.maxDamage = this.maxDamage;
            clone.version = this.version;
            return clone;
        }
        catch (CloneNotSupportedException e2) {
            throw new Error(e2);
        }
    }

    public final Map<String, Object> serialize() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"meta-type", SerializableMeta.classMap.get(this.getClass()));
        this.serialize((ImmutableMap.Builder<String, Object>)map);
        return map.build();
    }

    @Overridden
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        ByteArrayOutputStream buf2;
        if (this.hasDisplayName()) {
            builder.put((Object)CraftMetaItem.NAME.BUKKIT, (Object)CraftChatMessage.toJSON(this.displayName));
        }
        if (this.hasItemName()) {
            builder.put((Object)CraftMetaItem.ITEM_NAME.BUKKIT, (Object)CraftChatMessage.toJSON(this.itemName));
        }
        if (this.hasLore()) {
            ArrayList<String> jsonLore = new ArrayList<String>();
            for (xx component : this.lore) {
                jsonLore.add(CraftChatMessage.toJSON(component));
            }
            builder.put((Object)CraftMetaItem.LORE.BUKKIT, jsonLore);
        }
        if (this.hasCustomModelDataComponent()) {
            builder.put((Object)CraftMetaItem.CUSTOM_MODEL_DATA.BUKKIT, (Object)this.customModelData);
        }
        if (this.hasEnchantable()) {
            builder.put((Object)CraftMetaItem.ENCHANTABLE.BUKKIT, (Object)this.enchantableValue);
        }
        if (this.hasBlockData()) {
            builder.put((Object)CraftMetaItem.BLOCK_DATA.BUKKIT, this.blockData);
        }
        CraftMetaItem.serializeEnchantments(this.enchantments, builder, ENCHANTMENTS);
        CraftMetaItem.serializeModifiers(this.attributeModifiers, builder, ATTRIBUTES);
        if (this.hasRepairCost()) {
            builder.put((Object)CraftMetaItem.REPAIR.BUKKIT, (Object)this.repairCost);
        }
        ArrayList<String> hideFlags = new ArrayList<String>();
        for (ItemFlag hideFlagEnum : this.getItemFlags()) {
            hideFlags.add(CraftItemFlag.bukkitToString(hideFlagEnum));
        }
        if (!hideFlags.isEmpty()) {
            builder.put((Object)CraftMetaItem.HIDEFLAGS.BUKKIT, hideFlags);
        }
        if (this.isHideTooltip()) {
            builder.put((Object)CraftMetaItem.HIDE_TOOLTIP.BUKKIT, (Object)this.hideTooltip);
        }
        if (this.hasTooltipStyle()) {
            builder.put((Object)CraftMetaItem.TOOLTIP_STYLE.BUKKIT, (Object)this.tooltipStyle.toString());
        }
        if (this.hasItemModel()) {
            builder.put((Object)CraftMetaItem.ITEM_MODEL.BUKKIT, (Object)this.itemModel.toString());
        }
        if (this.isUnbreakable()) {
            builder.put((Object)CraftMetaItem.UNBREAKABLE.BUKKIT, (Object)this.unbreakable);
        }
        if (this.hasEnchantmentGlintOverride()) {
            builder.put((Object)CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.BUKKIT, (Object)this.enchantmentGlintOverride);
        }
        if (this.isGlider()) {
            builder.put((Object)CraftMetaItem.GLIDER.BUKKIT, (Object)this.glider);
        }
        if (this.hasDamageResistant()) {
            builder.put((Object)CraftMetaItem.DAMAGE_RESISTANT.BUKKIT, (Object)this.damageResistant.b().toString());
        }
        if (this.hasMaxStackSize()) {
            builder.put((Object)CraftMetaItem.MAX_STACK_SIZE.BUKKIT, (Object)this.maxStackSize);
        }
        if (this.hasRarity()) {
            builder.put((Object)CraftMetaItem.RARITY.BUKKIT, (Object)this.rarity.name());
        }
        if (this.hasUseRemainder()) {
            builder.put((Object)CraftMetaItem.USE_REMAINDER.BUKKIT, (Object)this.useRemainder);
        }
        if (this.hasUseCooldown()) {
            builder.put((Object)CraftMetaItem.USE_COOLDOWN.BUKKIT, (Object)this.useCooldown);
        }
        if (this.hasFood()) {
            builder.put((Object)CraftMetaItem.FOOD.BUKKIT, (Object)this.food);
        }
        if (this.hasConsumable()) {
            builder.put((Object)CraftMetaItem.CONSUMABLE.BUKKIT, (Object)this.consumable);
        }
        if (this.hasTool()) {
            builder.put((Object)CraftMetaItem.TOOL.BUKKIT, (Object)this.tool);
        }
        if (this.hasBlocksAttacks()) {
            builder.put((Object)CraftMetaItem.BLOCKS_ATTACKS.BUKKIT, (Object)this.blocksAttacks);
        }
        if (this.hasWeapon()) {
            builder.put((Object)CraftMetaItem.WEAPON.BUKKIT, (Object)this.weapon);
        }
        if (this.hasEquippable()) {
            builder.put((Object)CraftMetaItem.EQUIPPABLE.BUKKIT, (Object)this.equippable);
        }
        if (this.hasJukeboxPlayable()) {
            builder.put((Object)CraftMetaItem.JUKEBOX_PLAYABLE.BUKKIT, (Object)this.jukebox);
        }
        if (this.hasBreakSound()) {
            builder.put((Object)CraftMetaItem.BREAK_SOUND.BUKKIT, (Object)this.getBreakSound().getKey().toString());
        }
        if (this.hasDamage()) {
            builder.put((Object)CraftMetaItem.DAMAGE.BUKKIT, (Object)this.damage);
        }
        if (this.hasMaxDamage()) {
            builder.put((Object)CraftMetaItem.MAX_DAMAGE.BUKKIT, (Object)this.maxDamage);
        }
        HashMap<String, vp> internalTags = new HashMap<String, vp>();
        this.serializeInternal(internalTags);
        if (!internalTags.isEmpty()) {
            up internal = new up();
            for (Map.Entry e2 : internalTags.entrySet()) {
                internal.a((String)e2.getKey(), (vp)e2.getValue());
            }
            try {
                buf2 = new ByteArrayOutputStream();
                vc.a(internal, buf2);
                builder.put((Object)"internal", (Object)Base64.getEncoder().encodeToString(buf2.toByteArray()));
            }
            catch (IOException ex2) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex2);
            }
        }
        if (!this.unhandledTags.isEmpty()) {
            vp unhandled = (vp)kn.b.encodeStart(MinecraftServer.getDefaultRegistryAccess().a(vd.a), (Object)this.unhandledTags.a()).getOrThrow(IllegalStateException::new);
            try {
                buf2 = new ByteArrayOutputStream();
                vc.a((up)unhandled, buf2);
                builder.put((Object)"unhandled", (Object)Base64.getEncoder().encodeToString(buf2.toByteArray()));
            }
            catch (IOException ex3) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex3);
            }
        }
        if (!this.removedTags.isEmpty()) {
            jy registryAccess = CraftRegistry.getMinecraftRegistry();
            jx<ko<?>> componentTypeRegistry = registryAccess.f(mp.r);
            ArrayList<String> removedTags = new ArrayList<String>();
            for (ko<?> removed : this.removedTags) {
                String componentKey = componentTypeRegistry.d(removed).orElseThrow().a().toString();
                removedTags.add(componentKey);
            }
            builder.put((Object)"removed", removedTags);
        }
        if (!this.persistentDataContainer.isEmpty()) {
            builder.put((Object)CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, (Object)this.persistentDataContainer.serialize());
        }
        if (this.customTag != null) {
            try {
                ByteArrayOutputStream buf3 = new ByteArrayOutputStream();
                vc.a(this.customTag, buf3);
                builder.put((Object)"custom", (Object)Base64.getEncoder().encodeToString(buf3.toByteArray()));
            }
            catch (IOException ex4) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex4);
            }
        }
        return builder;
    }

    void serializeInternal(Map<String, vp> unhandledTags) {
    }

    static void serializeEnchantments(Map<Enchantment, Integer> enchantments, ImmutableMap.Builder<String, Object> builder, ItemMetaKey key) {
        if (enchantments == null || enchantments.isEmpty()) {
            return;
        }
        ImmutableMap.Builder enchants = ImmutableMap.builder();
        for (Map.Entry<Enchantment, Integer> enchant : enchantments.entrySet()) {
            enchants.put((Object)CraftEnchantment.bukkitToString(enchant.getKey()), (Object)enchant.getValue());
        }
        builder.put((Object)key.BUKKIT, (Object)enchants.build());
    }

    static void serializeModifiers(Multimap<Attribute, AttributeModifier> modifiers, ImmutableMap.Builder<String, Object> builder, ItemMetaKey key) {
        if (modifiers == null || modifiers.isEmpty()) {
            return;
        }
        LinkedHashMap mods = new LinkedHashMap();
        for (Map.Entry entry : modifiers.entries()) {
            Collection modCollection;
            if (entry.getKey() == null || (modCollection = modifiers.get((Object)((Attribute)entry.getKey()))) == null || modCollection.isEmpty()) continue;
            mods.put(CraftAttribute.bukkitToString((Attribute)entry.getKey()), new ArrayList(modCollection));
        }
        builder.put((Object)key.BUKKIT, mods);
    }

    static void safelyAdd(Iterable<?> addFrom, Collection<xx> addTo, boolean possiblyJsonInput) {
        if (addFrom == null) {
            return;
        }
        for (Object object : addFrom) {
            xx component;
            if (!(object instanceof String)) {
                if (object != null) {
                    throw new IllegalArgumentException(String.valueOf(addFrom) + " cannot contain non-string " + object.getClass().getName());
                }
                addTo.add(xx.i());
                continue;
            }
            String entry = object.toString();
            xx xx2 = component = possiblyJsonInput ? CraftChatMessage.fromJSONOrString(entry) : CraftChatMessage.fromStringOrNull(entry);
            if (component != null) {
                addTo.add(component);
                continue;
            }
            addTo.add(xx.i());
        }
    }

    static boolean checkConflictingEnchants(Map<Enchantment, Integer> enchantments, Enchantment ench) {
        if (enchantments == null || enchantments.isEmpty()) {
            return false;
        }
        for (Enchantment enchant : enchantments.keySet()) {
            if (!enchant.conflictsWith(ench)) continue;
            return true;
        }
        return false;
    }

    public final String toString() {
        return (String)SerializableMeta.classMap.get(this.getClass()) + "_META:" + String.valueOf(this.serialize());
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ko> getHandledTags() {
        Set<ko> set = HANDLED_TAGS;
        synchronized (set) {
            if (HANDLED_TAGS.isEmpty()) {
                HANDLED_TAGS.addAll(Arrays.asList(CraftMetaItem.NAME.TYPE, CraftMetaItem.ITEM_NAME.TYPE, CraftMetaItem.LORE.TYPE, CraftMetaItem.CUSTOM_MODEL_DATA.TYPE, CraftMetaItem.ENCHANTABLE.TYPE, CraftMetaItem.BLOCK_DATA.TYPE, CraftMetaItem.REPAIR.TYPE, CraftMetaItem.ENCHANTMENTS.TYPE, CraftMetaItem.HIDEFLAGS.TYPE, CraftMetaItem.TOOLTIP_STYLE.TYPE, CraftMetaItem.ITEM_MODEL.TYPE, CraftMetaItem.UNBREAKABLE.TYPE, CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.TYPE, CraftMetaItem.GLIDER.TYPE, CraftMetaItem.DAMAGE_RESISTANT.TYPE, CraftMetaItem.MAX_STACK_SIZE.TYPE, CraftMetaItem.RARITY.TYPE, CraftMetaItem.USE_REMAINDER.TYPE, CraftMetaItem.USE_COOLDOWN.TYPE, CraftMetaItem.FOOD.TYPE, CraftMetaItem.CONSUMABLE.TYPE, CraftMetaItem.TOOL.TYPE, CraftMetaItem.BLOCKS_ATTACKS.TYPE, CraftMetaItem.WEAPON.TYPE, CraftMetaItem.EQUIPPABLE.TYPE, CraftMetaItem.JUKEBOX_PLAYABLE.TYPE, CraftMetaItem.BREAK_SOUND.TYPE, CraftMetaItem.DAMAGE.TYPE, CraftMetaItem.MAX_DAMAGE.TYPE, CraftMetaItem.CUSTOM_DATA.TYPE, CraftMetaItem.ATTRIBUTES.TYPE, CraftMetaArmor.TRIM.TYPE, CraftMetaArmorStand.ENTITY_TAG.TYPE, CraftMetaBanner.PATTERNS.TYPE, CraftMetaEntityTag.ENTITY_TAG.TYPE, CraftMetaLeatherArmor.COLOR.TYPE, CraftMetaMap.MAP_POST_PROCESSING.TYPE, CraftMetaMap.MAP_COLOR.TYPE, CraftMetaMap.MAP_ID.TYPE, CraftMetaPotion.POTION_CONTENTS.TYPE, CraftMetaShield.BASE_COLOR.TYPE, CraftMetaSkull.SKULL_PROFILE.TYPE, CraftMetaSkull.NOTE_BLOCK_SOUND.TYPE, CraftMetaSpawnEgg.ENTITY_TAG.TYPE, CraftMetaBlockState.BLOCK_ENTITY_TAG.TYPE, CraftMetaBook.BOOK_CONTENT.TYPE, CraftMetaBookSigned.BOOK_CONTENT.TYPE, CraftMetaFirework.FIREWORKS.TYPE, CraftMetaEnchantedBook.STORED_ENCHANTMENTS.TYPE, CraftMetaCharge.EXPLOSION.TYPE, CraftMetaKnowledgeBook.BOOK_RECIPES.TYPE, CraftMetaTropicalFishBucket.ENTITY_TAG.TYPE, CraftMetaTropicalFishBucket.BUCKET_ENTITY_TAG.TYPE, CraftMetaAxolotlBucket.ENTITY_TAG.TYPE, CraftMetaAxolotlBucket.BUCKET_ENTITY_TAG.TYPE, CraftMetaCrossbow.CHARGED_PROJECTILES.TYPE, CraftMetaSuspiciousStew.EFFECTS.TYPE, CraftMetaCompass.LODESTONE_TARGET.TYPE, CraftMetaBundle.ITEMS.TYPE, CraftMetaMusicInstrument.GOAT_HORN_INSTRUMENT.TYPE, CraftMetaOminousBottle.OMINOUS_BOTTLE_AMPLIFIER.TYPE));
            }
            return HANDLED_TAGS;
        }
    }

    protected static <T> Optional<? extends T> getOrEmpty(kn tag, ItemMetaKeyType<T> type) {
        Optional result = tag.a(type.TYPE);
        return result != null ? result : Optional.empty();
    }

    static final class ItemMetaKeyType<T>
    extends ItemMetaKey {
        final ko<T> TYPE;

        ItemMetaKeyType(ko<T> type) {
            this(type, null, null);
        }

        ItemMetaKeyType(ko<T> type, String both) {
            this(type, both, both);
        }

        ItemMetaKeyType(ko<T> type, String nbt, String bukkit) {
            super(nbt, bukkit);
            this.TYPE = type;
        }
    }

    static final class Applicator {
        private final kn.a builder = kn.a();

        Applicator() {
        }

        <T> Applicator put(ItemMetaKeyType<T> key, T value) {
            this.builder.a(key.TYPE, value);
            return this;
        }

        <T> Applicator putIfAbsent(kr<?> component) {
            if (!this.builder.isSet(component.a())) {
                this.builder.a(component);
            }
            return this;
        }

        kn build() {
            return this.builder.a();
        }
    }
}

