/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.projectiles;

import com.google.common.base.Preconditions;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AbstractWindCharge;
import org.bukkit.entity.BreezeWindCharge;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.WitherSkull;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.util.Vector;

public class CraftBlockProjectileSource
implements BlockProjectileSource {
    private final ehc dispenserBlock;

    public CraftBlockProjectileSource(ehc dispenserBlock) {
        this.dispenserBlock = dispenserBlock;
    }

    public Block getBlock() {
        return this.dispenserBlock.j().getWorld().getBlockAt(this.dispenserBlock.aD_().u(), this.dispenserBlock.aD_().v(), this.dispenserBlock.aD_().w());
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        Preconditions.checkArgument((this.getBlock().getType() == Material.DISPENSER ? 1 : 0) != 0, (Object)"Block is no longer dispenser");
        lj sourceblock = new lj((awx)this.dispenserBlock.j(), this.dispenserBlock.aD_(), this.dispenserBlock.o(), this.dispenserBlock);
        jg enumdirection = sourceblock.d().c(dxd.b);
        drq world = this.dispenserBlock.j();
        dhl item = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            item = dht.so;
        } else if (Egg.class.isAssignableFrom(projectile)) {
            item = dht.sD;
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            item = dht.uj;
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            item = dht.wd;
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            item = LingeringPotion.class.isAssignableFrom(projectile) ? dht.xB : dht.xy;
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            item = TippedArrow.class.isAssignableFrom(projectile) ? dht.xA : (SpectralArrow.class.isAssignableFrom(projectile) ? dht.xz : dht.pX);
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            item = AbstractWindCharge.class.isAssignableFrom(projectile) ? dht.wf : dht.we;
        } else if (Firework.class.isAssignableFrom(projectile)) {
            item = dht.wC;
        }
        Preconditions.checkArgument((boolean)(item instanceof dij), (Object)"Projectile not supported");
        dhp itemstack = new dhp(item);
        dij projectileItem = (dij)((Object)item);
        dij.a dispenseConfig = projectileItem.a();
        ju iposition = dispenseConfig.b().getDispensePosition(sourceblock, enumdirection);
        dai launch = projectileItem.a(world, iposition, itemstack, enumdirection);
        if (Fireball.class.isAssignableFrom(projectile)) {
            czw customFireball = null;
            if (WitherSkull.class.isAssignableFrom(projectile)) {
                customFireball = cee.bQ.a(world, ced.k);
                launch = customFireball;
            } else if (DragonFireball.class.isAssignableFrom(projectile)) {
                launch = cee.M.a(world, ced.k);
            } else if (BreezeWindCharge.class.isAssignableFrom(projectile)) {
                customFireball = cee.u.a(world, ced.k);
                launch = customFireball;
            } else if (LargeFireball.class.isAssignableFrom(projectile)) {
                customFireball = cee.ab.a(world, ced.k);
                launch = customFireball;
            }
            if (customFireball != null) {
                customFireball.a_(iposition.a(), iposition.b(), iposition.c());
                bfq randomsource = world.I_();
                double d0 = randomsource.a((double)enumdirection.j(), 0.11485000000000001);
                double d1 = randomsource.a((double)enumdirection.k(), 0.11485000000000001);
                double d2 = randomsource.a((double)enumdirection.l(), 0.11485000000000001);
                foh vec3d = new foh(d0, d1, d2);
                customFireball.a(vec3d, 0.1);
            }
        }
        if (launch instanceof czv) {
            czv arrow = (czv)launch;
            arrow.b = czv.a.b;
        }
        launch.projectileSource = this;
        projectileItem.a(launch, enumdirection.j(), enumdirection.k(), enumdirection.l(), dispenseConfig.d(), dispenseConfig.c());
        if (velocity != null) {
            ((Projectile)launch.getBukkitEntity()).setVelocity(velocity);
        }
        world.b(launch);
        return (T)((Projectile)launch.getBukkitEntity());
    }
}

