/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.JsonOps;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.md_5.bungee.chat.ChatVersion;
import net.md_5.bungee.chat.VersionedComponentSerializer;
import net.minecraft.server.MinecraftServer;
import org.bukkit.ChatColor;

public final class CraftChatMessage {
    private static final Pattern LINK_PATTERN = Pattern.compile("((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))");
    private static final Map<Character, o> formatMap;

    public static VersionedComponentSerializer getBungee() {
        return VersionedComponentSerializer.forVersion((ChatVersion)ChatVersion.V1_21_5);
    }

    public static o getColor(ChatColor color) {
        return formatMap.get(Character.valueOf(color.getChar()));
    }

    public static ChatColor getColor(o format) {
        return ChatColor.getByChar((char)format.C);
    }

    public static Optional<xx> fromStringOrOptional(String message) {
        return Optional.ofNullable(CraftChatMessage.fromStringOrNull(message));
    }

    public static Optional<xx> fromStringOrOptional(String message, boolean keepNewlines) {
        return Optional.ofNullable(CraftChatMessage.fromStringOrNull(message, keepNewlines));
    }

    public static xx fromStringOrNull(String message) {
        return CraftChatMessage.fromStringOrNull(message, false);
    }

    public static xx fromStringOrNull(String message, boolean keepNewlines) {
        return message == null || message.isEmpty() ? null : CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static xx fromStringOrEmpty(String message) {
        return CraftChatMessage.fromStringOrEmpty(message, false);
    }

    public static xx fromStringOrEmpty(String message, boolean keepNewlines) {
        return CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static xx[] fromString(String message) {
        return CraftChatMessage.fromString(message, false);
    }

    public static xx[] fromString(String message, boolean keepNewlines) {
        return CraftChatMessage.fromString(message, keepNewlines, false);
    }

    public static xx[] fromString(String message, boolean keepNewlines, boolean plain) {
        return new StringMessage(message, keepNewlines, plain).getOutput();
    }

    public static String toJSON(xx component) {
        return ChatSerializer.toJson(component, MinecraftServer.getDefaultRegistryAccess());
    }

    public static String toJSONOrNull(xx component) {
        if (component == null) {
            return null;
        }
        return CraftChatMessage.toJSON(component);
    }

    public static xx fromJSON(String jsonMessage) throws JsonParseException {
        return ChatSerializer.fromJson(jsonMessage, MinecraftServer.getDefaultRegistryAccess());
    }

    public static xx fromJSONOrNull(String jsonMessage) {
        if (jsonMessage == null) {
            return null;
        }
        try {
            return CraftChatMessage.fromJSON(jsonMessage);
        }
        catch (JsonParseException ex2) {
            return null;
        }
    }

    public static xx fromJSONOrString(String message) {
        return CraftChatMessage.fromJSONOrString(message, false);
    }

    public static xx fromJSONOrString(String message, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrString(message, false, keepNewlines);
    }

    public static xx fromJSONOrString(String message, boolean nullable, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrString(message, nullable, keepNewlines, Integer.MAX_VALUE, false);
    }

    public static xx fromJSONOrString(String message, boolean nullable, boolean keepNewlines, int maxLength, boolean checkJsonContentLength) {
        if (message == null) {
            message = "";
        }
        if (nullable && message.isEmpty()) {
            return null;
        }
        xx component = CraftChatMessage.fromJSONOrNull(message);
        if (component != null) {
            String trimmedContent;
            String content;
            if (checkJsonContentLength && (content = CraftChatMessage.fromComponent(component)) != (trimmedContent = CraftChatMessage.trimMessage(content, maxLength))) {
                return CraftChatMessage.fromString(trimmedContent, keepNewlines)[0];
            }
            return component;
        }
        message = CraftChatMessage.trimMessage(message, maxLength);
        return CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static String trimMessage(String message, int maxLength) {
        if (message != null && message.length() > maxLength) {
            return message.substring(0, maxLength);
        }
        return message;
    }

    public static String fromComponent(xx component) {
        if (component == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        boolean hadFormat = false;
        for (xx c2 : component) {
            yv modi = c2.a();
            yx color = modi.a();
            if (c2.b() != zd.b || color != null) {
                if (color != null) {
                    if (color.format != null) {
                        out.append(color.format);
                    } else {
                        out.append('\u00a7').append("x");
                        for (char magic : color.b().substring(1).toCharArray()) {
                            out.append('\u00a7').append(magic);
                        }
                    }
                    hadFormat = true;
                } else if (hadFormat) {
                    out.append(ChatColor.RESET);
                    hadFormat = false;
                }
            }
            if (modi.c()) {
                out.append(o.r);
                hadFormat = true;
            }
            if (modi.d()) {
                out.append(o.u);
                hadFormat = true;
            }
            if (modi.f()) {
                out.append(o.t);
                hadFormat = true;
            }
            if (modi.e()) {
                out.append(o.s);
                hadFormat = true;
            }
            if (modi.g()) {
                out.append(o.q);
                hadFormat = true;
            }
            c2.b().a(x2 -> {
                out.append(x2);
                return Optional.empty();
            });
        }
        return out.toString();
    }

    public static xx fixComponent(ym component) {
        Matcher matcher = LINK_PATTERN.matcher("");
        return CraftChatMessage.fixComponent(component, matcher);
    }

    private static xx fixComponent(ym component, Matcher matcher) {
        zd text;
        String msg;
        if (component.b() instanceof zd && matcher.reset(msg = (text = (zd)component.b()).b()).find()) {
            matcher.reset();
            yv modifier = component.a();
            ArrayList<xx> extras = new ArrayList<xx>();
            ArrayList<xx> extrasOld = new ArrayList<xx>(component.c());
            component = xx.i();
            int pos = 0;
            while (matcher.find()) {
                Object match = matcher.group();
                if (!((String)match).startsWith("http://") && !((String)match).startsWith("https://")) {
                    match = "http://" + (String)match;
                }
                ym prev = xx.b(msg.substring(pos, matcher.start()));
                prev.b(modifier);
                extras.add(prev);
                ym link = xx.b(matcher.group());
                try {
                    yv linkModi = modifier.a(new xv.f(ag.a((String)match)));
                    link.b(linkModi);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                extras.add(link);
                pos = matcher.end();
            }
            ym prev = xx.b(msg.substring(pos));
            prev.b(modifier);
            extras.add(prev);
            extras.addAll(extrasOld);
            for (xx c2 : extras) {
                component.b(c2);
            }
        }
        List<xx> extras = component.c();
        for (int i2 = 0; i2 < extras.size(); ++i2) {
            xx comp = extras.get(i2);
            if (comp.a() == null || comp.a().i() != null) continue;
            extras.set(i2, CraftChatMessage.fixComponent(comp.f(), matcher));
        }
        if (component.b() instanceof zg) {
            Object[] subs = ((zg)component.b()).d();
            for (int i3 = 0; i3 < subs.length; ++i3) {
                Object comp = subs[i3];
                if (comp instanceof xx) {
                    xx c3 = (xx)comp;
                    if (c3.a() == null || c3.a().i() != null) continue;
                    subs[i3] = CraftChatMessage.fixComponent(c3.f(), matcher);
                    continue;
                }
                if (!(comp instanceof String) || !matcher.reset((String)comp).find()) continue;
                subs[i3] = CraftChatMessage.fixComponent(xx.b((String)comp), matcher);
            }
        }
        return component;
    }

    private CraftChatMessage() {
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (o format : o.values()) {
            builder.put((Object)Character.valueOf(Character.toLowerCase(format.toString().charAt(1))), (Object)format);
        }
        formatMap = builder.build();
    }

    private static final class StringMessage {
        private static final Pattern INCREMENTAL_PATTERN = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-orx])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))|(\\n)", 2);
        private static final Pattern INCREMENTAL_PATTERN_KEEP_NEWLINES = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-orx])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " ]|$))))", 2);
        private static final yv RESET = yv.a.a(false).b(false).c(false).d(false).e(false);
        private final List<xx> list = new ArrayList<xx>();
        private ym currentChatComponent = xx.i();
        private yv modifier = yv.a;
        private final xx[] output;
        private int currentIndex;
        private StringBuilder hex;
        private final String message;

        /*
         * Unable to fully structure code
         */
        private StringMessage(String message, boolean keepNewlines, boolean plain) {
            super();
            this.message = message;
            if (message == null) {
                this.output = new xx[]{this.currentChatComponent};
                return;
            }
            this.list.add(this.currentChatComponent);
            matcher = (keepNewlines != false ? StringMessage.INCREMENTAL_PATTERN_KEEP_NEWLINES : StringMessage.INCREMENTAL_PATTERN).matcher(message);
            match = null;
            needsAdd = false;
            while (matcher.find()) {
                groupId = 0;
                while ((match = matcher.group(++groupId)) == null) {
                }
                index = matcher.start(groupId);
                if (index > this.currentIndex) {
                    needsAdd = false;
                    this.appendNewComponent(index);
                }
                switch (groupId) {
                    case 1: {
                        c = match.toLowerCase(Locale.ROOT).charAt(1);
                        format = CraftChatMessage.formatMap.get(Character.valueOf(c));
                        if (c != 'x') ** GOTO lbl29
                        this.hex = new StringBuilder("#");
                        ** GOTO lbl56
lbl29:
                        // 1 sources

                        if (this.hex == null) ** GOTO lbl36
                        this.hex.append(c);
                        if (this.hex.length() == 7) {
                            this.modifier = StringMessage.RESET.a((yx)yx.a(this.hex.toString()).result().get());
                            this.hex = null;
                        }
                        ** GOTO lbl56
lbl36:
                        // 1 sources

                        if (!format.d() || format == o.v) ** GOTO lbl55
                        switch (1.$SwitchMap$net$minecraft$EnumChatFormat[format.ordinal()]) {
                            case 1: {
                                this.modifier = this.modifier.a(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 2: {
                                this.modifier = this.modifier.b(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 3: {
                                this.modifier = this.modifier.d(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 4: {
                                this.modifier = this.modifier.c(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 5: {
                                this.modifier = this.modifier.e(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            default: {
                                throw new AssertionError((Object)"Unexpected message format");
                            }
                        }
lbl55:
                        // 1 sources

                        this.modifier = StringMessage.RESET.a(format);
lbl56:
                        // 8 sources

                        needsAdd = true;
                        break;
                    }
                    case 2: {
                        if (plain) {
                            this.appendNewComponent(matcher.end(groupId));
                            break;
                        }
                        if (!match.startsWith("http://") && !match.startsWith("https://")) {
                            match = "http://" + (String)match;
                        }
                        try {
                            this.modifier = this.modifier.a(new xv.f(ag.a((String)match)));
                        }
                        catch (URISyntaxException var11_11) {
                            // empty catch block
                        }
                        this.appendNewComponent(matcher.end(groupId));
                        this.modifier = this.modifier.a((xv)null);
                        break;
                    }
                    case 3: {
                        if (needsAdd) {
                            this.appendNewComponent(index);
                        }
                        this.currentChatComponent = null;
                    }
                }
                this.currentIndex = matcher.end(groupId);
            }
            if (this.currentIndex < message.length() || needsAdd) {
                this.appendNewComponent(message.length());
            }
            this.output = this.list.toArray(new xx[this.list.size()]);
        }

        private void appendNewComponent(int index) {
            ym addition = xx.b(this.message.substring(this.currentIndex, index)).b(this.modifier);
            this.currentIndex = index;
            if (this.currentChatComponent == null) {
                this.currentChatComponent = xx.i();
                this.list.add(this.currentChatComponent);
            }
            this.currentChatComponent.b(addition);
        }

        private xx[] getOutput() {
            return this.output;
        }
    }

    public static class ChatSerializer {
        private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

        private ChatSerializer() {
        }

        private static ym deserialize(JsonElement jsonelement, jm.a holderlookup_a) {
            return (ym)xz.a.parse(holderlookup_a.a(JsonOps.INSTANCE), (Object)jsonelement).getOrThrow(JsonParseException::new);
        }

        private static JsonElement serialize(xx ichatbasecomponent, jm.a holderlookup_a) {
            return (JsonElement)xz.a.encodeStart(holderlookup_a.a(JsonOps.INSTANCE), (Object)ichatbasecomponent).getOrThrow(JsonParseException::new);
        }

        public static String toJson(xx ichatbasecomponent, jm.a holderlookup_a) {
            return GSON.toJson(ChatSerializer.serialize(ichatbasecomponent, holderlookup_a));
        }

        @Nullable
        public static ym fromJson(String s2, jm.a holderlookup_a) {
            JsonElement jsonelement = JsonParser.parseString((String)s2);
            return jsonelement == null ? null : ChatSerializer.deserialize(jsonelement, holderlookup_a);
        }
    }
}

