/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import net.minecraft.server.MinecraftServer;
import org.bukkit.craftbukkit.v1_21_R6.SpigotTimings;
import org.spigotmc.SpigotWorldConfig;

public class ActivationRange {
    static foc maxBB = new foc(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public static ActivationType initializeEntityActivationType(cdv entity) {
        if (entity instanceof dbe) {
            return ActivationType.RAIDER;
        }
        if (entity instanceof cwn || entity instanceof cww) {
            return ActivationType.MONSTER;
        }
        if (entity instanceof cfe || entity instanceof cqi) {
            return ActivationType.ANIMAL;
        }
        return ActivationType.MISC;
    }

    public static boolean initializeEntityActivationState(cdv entity, SpigotWorldConfig config) {
        if (config == null) {
            return false;
        }
        return entity.activationType == ActivationType.MISC && config.miscActivationRange == 0 || entity.activationType == ActivationType.RAIDER && config.raiderActivationRange == 0 || entity.activationType == ActivationType.ANIMAL && config.animalActivationRange == 0 || entity.activationType == ActivationType.MONSTER && config.monsterActivationRange == 0 || entity instanceof czl || entity instanceof daq || entity instanceof cuj || entity instanceof cug || entity instanceof cvd || entity instanceof czw || entity instanceof cev || entity instanceof cvs || entity instanceof cui || entity instanceof dad || entity instanceof daw;
    }

    public static void activateEntities(drq world) {
        SpigotTimings.entityActivationCheckTimer.startTiming();
        int miscActivationRange = world.spigotConfig.miscActivationRange;
        int raiderActivationRange = world.spigotConfig.raiderActivationRange;
        int animalActivationRange = world.spigotConfig.animalActivationRange;
        int monsterActivationRange = world.spigotConfig.monsterActivationRange;
        int maxRange = Math.max(monsterActivationRange, animalActivationRange);
        maxRange = Math.max(maxRange, raiderActivationRange);
        maxRange = Math.max(maxRange, miscActivationRange);
        maxRange = Math.min((world.spigotConfig.simulationDistance << 4) - 8, maxRange);
        for (czl czl2 : world.C()) {
            czl2.activatedTick = MinecraftServer.currentTick;
            if (world.spigotConfig.ignoreSpectatorActivation && czl2.at()) continue;
            maxBB = czl2.de().c(maxRange, 256.0, maxRange);
            ActivationType.MISC.boundingBox = czl2.de().c(miscActivationRange, 256.0, miscActivationRange);
            ActivationType.RAIDER.boundingBox = czl2.de().c(raiderActivationRange, 256.0, raiderActivationRange);
            ActivationType.ANIMAL.boundingBox = czl2.de().c(animalActivationRange, 256.0, animalActivationRange);
            ActivationType.MONSTER.boundingBox = czl2.de().c(monsterActivationRange, 256.0, monsterActivationRange);
            world.K().a(maxBB, ActivationRange::activateEntity);
        }
        SpigotTimings.entityActivationCheckTimer.stopTiming();
    }

    private static void activateEntity(cdv entity) {
        if ((long)MinecraftServer.currentTick > entity.activatedTick) {
            if (entity.defaultActivationState) {
                entity.activatedTick = MinecraftServer.currentTick;
                return;
            }
            if (entity.activationType.boundingBox.c(entity.de())) {
                entity.activatedTick = MinecraftServer.currentTick;
            }
        }
    }

    public static boolean checkEntityImmunities(cdv entity) {
        if (entity.au || entity.aP() > 0) {
            return true;
        }
        if (!(entity instanceof czv) ? !entity.aS() || !entity.aS.isEmpty() || entity.cl() : !((czv)entity).e()) {
            return true;
        }
        if (entity instanceof cew) {
            cew living = (cew)entity;
            if (living.bt > 0 || living.cl.size() > 0) {
                return true;
            }
            if (entity instanceof cfe && ((cfe)entity).e() != null) {
                return true;
            }
            if (entity instanceof cyx && ((cyx)entity).Z_()) {
                return true;
            }
            if (entity instanceof cqq) {
                cqq animal = (cqq)entity;
                if (animal.g_() || animal.gS()) {
                    return true;
                }
                if (entity instanceof ctu && ((ctu)entity).s()) {
                    return true;
                }
            }
            if (entity instanceof cvz && ((cvz)entity).s()) {
                return true;
            }
        }
        return entity instanceof cej;
    }

    public static boolean checkIfActive(cdv entity) {
        boolean isActive;
        SpigotTimings.checkIfActiveTimer.startTiming();
        if (entity instanceof dad || entity instanceof cvr && (entity.at + entity.az() + 1) % 4 == 0) {
            SpigotTimings.checkIfActiveTimer.stopTiming();
            return true;
        }
        boolean bl2 = isActive = entity.activatedTick >= (long)MinecraftServer.currentTick || entity.defaultActivationState;
        if (!isActive) {
            if (((long)MinecraftServer.currentTick - entity.activatedTick - 1L) % 20L == 0L) {
                if (ActivationRange.checkEntityImmunities(entity)) {
                    entity.activatedTick = MinecraftServer.currentTick + 20;
                }
                isActive = true;
            }
        } else if (!entity.defaultActivationState && entity.at % 4 == 0 && !ActivationRange.checkEntityImmunities(entity)) {
            isActive = false;
        }
        SpigotTimings.checkIfActiveTimer.stopTiming();
        return isActive;
    }

    public static enum ActivationType {
        MONSTER,
        ANIMAL,
        RAIDER,
        MISC;

        foc boundingBox = new foc(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }
}

